/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.scan;

import com.groupcdg.arcmutate.spring.scan.SimpleScanner;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilePositions {
    private final Map<String, List<Integer>> annotations;
    private final Map<String, Integer> identifiers;

    public FilePositions(Map<String, List<Integer>> annotations, Map<String, Integer> identifiers) {
        this.annotations = annotations;
        this.identifiers = identifiers;
    }

    public static FilePositions scan(Path p) {
        FilePositions filePositions;
        block8: {
            Stream lines = Files.readAllLines(p, StandardCharsets.UTF_8).stream();
            try {
                filePositions = FilePositions.scan(lines.collect(Collectors.toList()));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            lines.close();
        }
        return filePositions;
    }

    public static FilePositions scan(List<String> lines) {
        HashMap<String, List<Integer>> annotations = new HashMap<String, List<Integer>>();
        HashMap<String, Integer> identifiers = new HashMap<String, Integer>();
        SimpleScanner scan = new SimpleScanner("\\s|\\(");
        for (int line = 0; line != lines.size(); ++line) {
            String currentLine = lines.get(line);
            List<String> parts = scan.scan(currentLine);
            int recordedLine = line + 1;
            for (String identifier : parts) {
                String cleaned = FilePositions.cleanIdentifier(identifier);
                if (cleaned.isEmpty()) continue;
                identifiers.computeIfAbsent(cleaned, k -> recordedLine);
            }
            List<String> annotation = FilePositions.scanAnnotations(parts);
            for (String a : annotation) {
                List is = annotations.getOrDefault(a, new ArrayList());
                is.add(recordedLine);
                annotations.put(a, is);
            }
        }
        return new FilePositions(annotations, identifiers);
    }

    private static String cleanIdentifier(String identifier) {
        return identifier.replace(";", "");
    }

    private static List<String> scanAnnotations(List<String> parts) {
        boolean takeNext = false;
        ArrayList<String> annotations = new ArrayList<String>();
        for (String each : parts) {
            if (takeNext) {
                annotations.add(FilePositions.unqualifyAnnotation(each));
            }
            if (!each.contains("@") || (takeNext = each.equals("@"))) continue;
            annotations.add(FilePositions.unqualifyAnnotation(each.replace("@", "")));
        }
        return annotations;
    }

    public int nearestAnnotationForIdentifier(String annotation, String field) {
        int firstOccurrence = this.identifiers.getOrDefault(field, 0);
        return this.nearestAnnotationForLine(annotation, firstOccurrence);
    }

    public int nearestAnnotationForLine(String annotation, int line) {
        List lines = this.annotations.getOrDefault(annotation, Collections.emptyList());
        return lines.stream().filter(l -> l <= line).max(Integer::compare).orElse(0);
    }

    private static String unqualifyAnnotation(String annotation) {
        int start = Math.max(annotation.lastIndexOf(46) + 1, 0);
        return annotation.substring(start);
    }
}

