/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.scan;

import com.groupcdg.arcmutate.spring.scan.Locator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;

public class DirectoryLocator
implements Locator {
    private final Path root;

    public DirectoryLocator(Path root) {
        this.root = root;
    }

    @Override
    public Optional<Path> locate(List<String> classes, String fileName) {
        if (!Files.exists(this.root, new LinkOption[0])) {
            return Optional.empty();
        }
        Optional<Path> path = classes.stream().map(ClassName::fromString).map(ClassName::getPackage).distinct().map(c -> DirectoryLocator.toFileName(c, fileName)).map(file -> this.root.resolve((String)file)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst();
        if (path.isPresent()) {
            return path;
        }
        return this.searchFromRoot(fileName);
    }

    static String toFileName(ClassName packge, String fileName) {
        if (packge.asJavaName().equals("")) {
            return fileName;
        }
        return packge.asJavaName().replace(".", File.separator) + File.separator + fileName;
    }

    private Optional<Path> searchFromRoot(String fileName) {
        Optional<Path> optional;
        block8: {
            Stream<Path> matches = Files.find(this.root, 100, (path, attributes) -> path.getFileName().toString().equals(fileName) && attributes.isRegularFile(), new FileVisitOption[0]);
            try {
                optional = matches.findFirst();
                if (matches == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (matches != null) {
                        try {
                            matches.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            matches.close();
        }
        return optional;
    }
}

