/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.mutators;

import com.groupcdg.arcmutate.spring.MutableAnnotation;
import com.groupcdg.arcmutate.spring.mutators.IdEncoder;
import com.groupcdg.arcmutate.spring.mutators.Position;
import com.groupcdg.arcmutate.spring.scan.FilePositions;
import com.groupcdg.arcmutate.spring.scan.Locator;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.util.Log;

class AnnotationMutationModifier
implements MutationInterceptor {
    private static final Logger log = Log.getLogger();
    private final Locator locator;
    private ClassTree currentClass;
    private FilePositions fp;
    private final Predicate<ClassName> licenceFilter;

    public AnnotationMutationModifier(Locator locator, Predicate<ClassName> licenceFilter) {
        this.locator = locator;
        this.licenceFilter = licenceFilter;
    }

    public InterceptorType type() {
        return InterceptorType.MODIFY;
    }

    public void begin(ClassTree classTree) {
        this.failIfNotLicenced(classTree.name());
        this.currentClass = classTree;
    }

    private void failIfNotLicenced(ClassName name) {
        if (!this.licenceFilter.test(name)) {
            throw new IllegalStateException("Spring plugin not licenced for use with " + String.valueOf(name));
        }
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> collection, Mutater mutater) {
        return collection.stream().map(this::modify).collect(Collectors.toList());
    }

    private MutationDetails modify(MutationDetails md) {
        Optional<MutableAnnotation> maybeAnnotation = MutableAnnotation.fromMutator(md.getId().getMutator());
        if (maybeAnnotation.isPresent()) {
            Position position = IdEncoder.parsePosition(md.getId());
            switch (position) {
                case FIELD: {
                    return this.handleField(md);
                }
                case CLASS: {
                    return this.handleClass(md);
                }
            }
            return this.handleMethod(md);
        }
        return md;
    }

    private MutationDetails handleClass(MutationDetails md) {
        String unqualifiedAnnotation = this.extractUnqualifiedAnnotation(md.getId());
        String className = md.getClassName().getNameWithoutPackage().asJavaName();
        int annotationLine = this.positions().nearestAnnotationForIdentifier(unqualifiedAnnotation, className);
        MutationIdentifier id = new MutationIdentifier(md.getId().getLocation(), md.getFirstIndex(), md.getMutator());
        return new MutationDetails(id, md.getFilename(), md.getDescription(), annotationLine, md.getBlocks());
    }

    private MutationDetails handleField(MutationDetails md) {
        String fieldName = this.extractField(md);
        String unqualifiedAnnotation = this.extractUnqualifiedAnnotation(md.getId());
        int annotationLine = this.positions().nearestAnnotationForIdentifier(unqualifiedAnnotation, fieldName);
        MutationIdentifier id = new MutationIdentifier(md.getId().getLocation(), md.getFirstIndex(), md.getMutator());
        return new MutationDetails(id, md.getFilename(), md.getDescription(), annotationLine, md.getBlocks());
    }

    private MutationDetails handleMethod(MutationDetails md) {
        Optional method = this.currentClass.method(md.getId().getLocation());
        Optional<Integer> firstLine = method.flatMap(m -> m.instructions().stream().filter(n -> n instanceof LineNumberNode).findFirst());
        String unqualifiedAnnotation = this.extractUnqualifiedAnnotation(md.getId());
        int line = firstLine.map(a -> ((LineNumberNode)a).line).orElse(0);
        int annotationLine = this.positions().nearestAnnotationForLine(unqualifiedAnnotation, line);
        MutationIdentifier id = new MutationIdentifier(md.getId().getLocation(), md.getFirstIndex(), md.getMutator());
        return new MutationDetails(id, md.getFilename(), md.getDescription(), annotationLine, md.getBlocks());
    }

    private String extractUnqualifiedAnnotation(MutationIdentifier id) {
        int start = Math.max(id.getMutator().lastIndexOf(46) + 1, 0);
        return id.getMutator().substring(start);
    }

    private String extractField(MutationDetails md) {
        return md.getId().getLocation().getMethodName();
    }

    private FilePositions positions() {
        if (this.fp == null) {
            Optional<Path> maybePath = this.locator.locate(Arrays.asList(this.currentClass.name().asJavaName()), this.currentClass.rawNode().sourceFile);
            if (maybePath.isPresent()) {
                this.fp = FilePositions.scan(maybePath.get());
            } else {
                log.warning("Could not locate source file for " + this.currentClass.name().asJavaName());
                this.fp = new FilePositions(Collections.emptyMap(), Collections.emptyMap());
            }
        }
        return this.fp;
    }

    public void end() {
        this.currentClass = null;
        this.fp = null;
    }
}

