/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ws;

import com.arcadedb.GlobalConfiguration;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONException;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.ws.ChangeEvent;
import com.arcadedb.server.http.ws.WebSocketEventBus;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class WebSocketReceiveListener
extends AbstractReceiveListener {
    private final HttpServer httpServer;
    private final WebSocketEventBus webSocketEventBus;

    public WebSocketReceiveListener(HttpServer httpServer, WebSocketEventBus webSocketEventBus) {
        this.httpServer = httpServer;
        this.webSocketEventBus = webSocketEventBus;
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage textMessage) throws IOException {
        try {
            JSONObject message = new JSONObject(textMessage.getData());
            String rawAction = message.getString("action", "");
            ACTION action = ACTION.UNKNOWN;
            try {
                action = ACTION.valueOf(rawAction.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            switch (action.ordinal()) {
                case 1: {
                    JSONArray jsonChangeTypes = !message.isNull("changeTypes") ? message.getJSONArray("changeTypes") : null;
                    Set<ChangeEvent.TYPE> changeTypes = jsonChangeTypes == null ? null : jsonChangeTypes.toList().stream().map(t -> ChangeEvent.TYPE.valueOf(t.toString().toUpperCase(Locale.ENGLISH))).collect(Collectors.toSet());
                    this.webSocketEventBus.subscribe(message.getString("database"), message.getString("type", null), changeTypes, channel);
                    this.sendAck(channel, action);
                    break;
                }
                case 2: {
                    this.webSocketEventBus.unsubscribe(message.getString("database"), (UUID)channel.getAttribute("ID"));
                    this.sendAck(channel, action);
                    break;
                }
                default: {
                    if (rawAction.equals("")) {
                        this.sendError(channel, "Message error", "Property 'action' is required.", null);
                        break;
                    }
                    this.sendError(channel, "Unknown action", "%s is not a valid action.".formatted(rawAction), null);
                    break;
                }
            }
        }
        catch (JSONException e) {
            this.sendError(channel, "Unable to parse JSON", e.getMessage(), e);
        }
        catch (DatabaseOperationException e) {
            this.sendError(channel, "Database error", e.getMessage(), e);
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, this.getErrorLogLevel(), "Error on command execution (%s)", (Throwable)e, (Object)((Object)((Object)this)).getClass().getSimpleName());
            this.sendError(channel, "Internal error", e.getMessage(), e);
        }
    }

    protected void onClose(WebSocketChannel channel, StreamSourceFrameChannel frameChannel) throws IOException {
        UUID channelId = (UUID)channel.getAttribute("ID");
        this.webSocketEventBus.unsubscribeAll(channelId);
    }

    private void sendAck(WebSocketChannel channel, ACTION action) {
        JSONObject json = new JSONObject("{\"result\": \"ok\"}");
        json.put("action", action.toString().toLowerCase(Locale.ENGLISH));
        WebSockets.sendText((String)json.toString(), (WebSocketChannel)channel, null);
    }

    private void sendError(WebSocketChannel channel, String error, String detail, Throwable exception) {
        JSONObject json = new JSONObject("{\"result\": \"error\"}");
        json.put("error", error);
        if (detail != null) {
            json.put("detail", this.encodeError(detail));
        }
        if (exception != null) {
            json.put("exception", exception.getClass().getName());
        }
        WebSockets.sendText((String)json.toString(), (WebSocketChannel)channel, null);
    }

    private String encodeError(String message) {
        return message.replace("\\\\", " ").replace("\n", " ");
    }

    private Level getErrorLogLevel() {
        return "development".equals(this.httpServer.getServer().getConfiguration().getValueAsString(GlobalConfiguration.SERVER_MODE)) ? Level.INFO : Level.FINE;
    }

    public static enum ACTION {
        UNKNOWN,
        SUBSCRIBE,
        UNSUBSCRIBE;

    }
}

