/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseContext;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.TransactionContext;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.HttpSession;
import com.arcadedb.server.http.handler.DatabaseAbstractHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import io.micrometer.core.instrument.Metrics;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.Map;

public class PostBeginHandler
extends DatabaseAbstractHandler {
    public PostBeginHandler(HttpServer httpServer) {
        super(httpServer);
    }

    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user, Database database, JSONObject payload) throws IOException {
        HttpSession tx;
        HeaderValues txId = exchange.getRequestHeaders().get("arcadedb-session-id");
        if (txId != null && !txId.isEmpty() && (tx = this.httpServer.getSessionManager().getSessionById(user, txId.getFirst())) != null) {
            return new ExecutionResponse(401, "{ \"error\" : \"Transaction already started\" }");
        }
        DatabaseContext.INSTANCE.init((DatabaseInternal)database);
        if (payload != null) {
            Map requestMap = payload.toMap();
            String isolationLevel = (String)requestMap.get("isolationLevel");
            if (isolationLevel == null) {
                return new ExecutionResponse(400, "Missing parameter 'isolationLevel'");
            }
            database.begin(Database.TRANSACTION_ISOLATION_LEVEL.valueOf((String)isolationLevel));
        } else {
            database.begin();
        }
        tx = ((DatabaseInternal)database).getTransaction();
        HttpSession session = this.httpServer.getSessionManager().createSession(user, (TransactionContext)tx);
        tx.setRequester(session.id);
        DatabaseContext.INSTANCE.removeContext(database.getDatabasePath());
        exchange.getResponseHeaders().put(new HttpString("arcadedb-session-id"), session.id);
        Metrics.counter((String)"http.begin", (String[])new String[0]).increment();
        return new ExecutionResponse(204, "");
    }

    @Override
    protected boolean requiresTransaction() {
        return false;
    }

    @Override
    protected boolean mustExecuteOnWorkerThread() {
        return true;
    }
}

