/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.Constants;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.exception.CommandParsingException;
import com.arcadedb.exception.DuplicatedKeyException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.security.SecurityUser;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityException;
import com.arcadedb.server.security.ServerSecurityUser;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Base64;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public abstract class AbstractServerHttpHandler
implements HttpHandler {
    private static final String AUTHORIZATION_BASIC = "Basic";
    protected final HttpServer httpServer;

    public AbstractServerHttpHandler(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    protected abstract ExecutionResponse execute(HttpServerExchange var1, ServerSecurityUser var2, JSONObject var3) throws Exception;

    protected String parseRequestPayload(HttpServerExchange e) {
        if (!e.isInIoThread() && !e.isBlocking()) {
            e.startBlocking();
        }
        if (!this.mustExecuteOnWorkerThread()) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error: handler must return true at mustExecuteOnWorkerThread() to read payload from request");
        }
        AtomicReference result = new AtomicReference();
        e.getRequestReceiver().receiveFullBytes((exchange, data) -> result.set(new String(data, DatabaseFactory.getDefaultCharset())), (exchange, err) -> {
            LogManager.instance().log((Object)this, Level.SEVERE, "receiveFullBytes completed with an error: %s", (Throwable)err, (Object)err.getMessage());
            exchange.setStatusCode(500);
            exchange.getResponseSender().send("Invalid Request");
        });
        return (String)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) {
        Throwable realException;
        if (this.mustExecuteOnWorkerThread() && exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        try {
            ExecutionResponse response;
            String payloadAsString;
            LogManager.instance().setContext(this.httpServer.getServer().getServerName());
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            HeaderValues authorization = exchange.getRequestHeaders().get("Authorization");
            if (this.isRequireAuthentication() && (authorization == null || authorization.isEmpty())) {
                exchange.setStatusCode(401);
                exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, AUTHORIZATION_BASIC);
                this.sendErrorResponse(exchange, 401, "", null, null);
                return;
            }
            ServerSecurityUser user = null;
            if (authorization != null) {
                String auth;
                block38: {
                    auth = authorization.getFirst();
                    if (auth.startsWith(AUTHORIZATION_BASIC)) break block38;
                    this.sendErrorResponse(exchange, 403, "Authentication not supported", null, null);
                    return;
                }
                String authPairCypher = auth.substring(AUTHORIZATION_BASIC.length() + 1);
                String authPairClear = new String(Base64.getDecoder().decode(authPairCypher), DatabaseFactory.getDefaultCharset());
                String[] authPair = authPairClear.split(":");
                if (authPair.length != 2) {
                    this.sendErrorResponse(exchange, 403, "Basic authentication error", null, null);
                    return;
                }
                try {
                    user = this.authenticate(authPair[0], authPair[1]);
                }
                catch (ServerSecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServerSecurityException("Authentication error");
                }
            }
            JSONObject payload = null;
            if (this.mustExecuteOnWorkerThread() && (payloadAsString = this.parseRequestPayload(exchange)) != null && !payloadAsString.isBlank()) {
                try {
                    payload = new JSONObject(payloadAsString.trim());
                }
                catch (Exception e) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Error parsing request payload: %s", (Object)e.getMessage());
                }
            }
            if ((response = this.execute(exchange, user, payload)) != null) {
                response.send(exchange);
            }
        }
        catch (ServerSecurityException e) {
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Security error on command execution (%s): %s", (Object)SecurityException.class.getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 403, "Security error", e, null);
        }
        catch (ServerIsNotTheLeaderException e) {
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 400, "Cannot execute command", e, e.getLeaderAddress());
        }
        catch (NeedRetryException e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 503, "Cannot execute command", e, null);
        }
        catch (DuplicatedKeyException e) {
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 503, "Found duplicate key in index", e, e.getIndexName() + "|" + e.getKeys() + "|" + String.valueOf(e.getCurrentIndexedRID()));
        }
        catch (RecordNotFoundException e) {
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 404, "Record not found", e, null);
        }
        catch (IllegalArgumentException e) {
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 400, "Cannot execute command", e, null);
        }
        catch (CommandExecutionException | CommandParsingException e) {
            realException = e;
            if (e.getCause() != null) {
                realException = e.getCause();
            }
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 500, "Cannot execute command", realException, null);
        }
        catch (TransactionException e) {
            realException = e;
            if (e.getCause() != null) {
                realException = e.getCause();
            }
            LogManager.instance().log((Object)this, this.getUserSevereErrorLogLevel(), "Error on transaction execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 500, "Error on transaction commit", realException, null);
        }
        catch (Throwable e) {
            LogManager.instance().log((Object)this, this.getErrorLogLevel(), "Error on command execution (%s): %s", (Object)this.getClass().getSimpleName(), (Object)e.getMessage());
            this.sendErrorResponse(exchange, 500, "Internal error", e, null);
        }
        finally {
            LogManager.instance().setContext(null);
        }
    }

    public boolean isRequireAuthentication() {
        return true;
    }

    protected ServerSecurityUser authenticate(String userName, String userPassword) {
        return this.httpServer.getServer().getSecurity().authenticate(userName, userPassword, null);
    }

    protected void checkRootUser(ServerSecurityUser user) {
        if (!"root".equals(user.getName())) {
            throw new ServerSecurityException("Only root user is authorized to execute server commands");
        }
    }

    protected JSONObject createResult(SecurityUser user, Database database) {
        JSONObject json = new JSONObject();
        if (database != null) {
            json.setDateFormat(database.getSchema().getDateFormat()).setDateTimeFormat(database.getSchema().getDateTimeFormat());
        }
        json.put("user", user.getName()).put("version", Constants.getVersion()).put("serverName", this.httpServer.getServer().getServerName());
        return json;
    }

    protected String decode(String command) {
        return command.replace("&amp;", " ").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&#039;", "'");
    }

    protected String error2json(String error, String detail, Throwable exception, String exceptionArgs, String help) {
        JSONObject json = new JSONObject();
        json.put("error", error);
        if (detail != null) {
            json.put("detail", this.encodeError(detail));
        }
        if (exception != null) {
            json.put("exception", exception.getClass().getName());
        }
        if (exceptionArgs != null) {
            json.put("exceptionArgs", exceptionArgs);
        }
        if (help != null) {
            json.put("help", help);
        }
        return json.toString();
    }

    protected boolean mustExecuteOnWorkerThread() {
        return false;
    }

    protected String encodeError(String message) {
        return message.replace("\\\\", " ").replace('\n', ' ');
    }

    protected String getQueryParameter(HttpServerExchange exchange, String name) {
        return this.getQueryParameter(exchange, name, null);
    }

    protected String getQueryParameter(HttpServerExchange exchange, String name, String defaultValue) {
        Deque par = (Deque)exchange.getQueryParameters().get(name);
        return par == null || par.isEmpty() ? defaultValue : (String)par.getFirst();
    }

    private Level getErrorLogLevel() {
        return "development".equals(this.httpServer.getServer().getConfiguration().getValueAsString(GlobalConfiguration.SERVER_MODE)) ? Level.SEVERE : Level.FINE;
    }

    private Level getUserSevereErrorLogLevel() {
        return "development".equals(this.httpServer.getServer().getConfiguration().getValueAsString(GlobalConfiguration.SERVER_MODE)) ? Level.INFO : Level.FINE;
    }

    private void sendErrorResponse(HttpServerExchange exchange, int code, String errorMessage, Throwable e, String exceptionArgs) {
        if (!exchange.isResponseStarted()) {
            exchange.setStatusCode(code);
        }
        exchange.getResponseSender().send(this.error2json(errorMessage, e != null ? e.getMessage() : "", e, exceptionArgs, null));
    }
}

