/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.engine.WALException;
import com.arcadedb.engine.WALFile;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.DatabaseChangeStructureRequest;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.OkResponse;
import com.arcadedb.server.ha.message.TxRequestAbstract;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.logging.Level;

public class TxRequest
extends TxRequestAbstract {
    private boolean waitForResponse;
    public DatabaseChangeStructureRequest changeStructure;
    public long installDatabaseLastLogNumber = -1L;

    public TxRequest() {
    }

    public TxRequest(String dbName, Map<Integer, Integer> bucketRecordDelta, Binary bufferChanges, boolean waitForResponse) {
        super(dbName, bucketRecordDelta, bufferChanges);
        this.waitForResponse = waitForResponse;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putByte((byte)(this.waitForResponse ? 1 : 0));
        if (this.changeStructure != null) {
            stream.putByte((byte)1);
            this.changeStructure.toStream(stream);
        } else {
            stream.putByte((byte)0);
        }
        super.toStream(stream);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        boolean bl = this.waitForResponse = stream.getByte() == 1;
        if (stream.getByte() == 1) {
            this.changeStructure = new DatabaseChangeStructureRequest();
            this.changeStructure.fromStream(server, stream);
        }
        super.fromStream(server, stream);
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase db = server.getServer().getDatabase(this.databaseName);
        if (!db.isOpen()) {
            throw new ReplicationException("Database '" + this.databaseName + "' is closed");
        }
        if (this.changeStructure != null) {
            try {
                this.changeStructure.updateFiles(db);
                db.getSchema().getEmbedded().load(ComponentFile.MODE.READ_WRITE, false);
            }
            catch (Exception e) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Error on changing database structure request from the leader node", (Throwable)e);
                throw new ReplicationException("Error on changing database structure request from the leader node", e);
            }
        }
        WALFile.WALTransaction walTx = this.readTxFromBuffer();
        try {
            LogManager.instance().log((Object)this, Level.FINE, "Applying tx %d from server %s (modifiedPages=%d)...", (Object)walTx.txId, (Object)remoteServerName, (Object)walTx.pages.length);
            boolean ignoreErrors = this.installDatabaseLastLogNumber > -1L && messageNumber <= this.installDatabaseLastLogNumber;
            db.getTransactionManager().applyChanges(walTx, this.bucketRecordDelta, ignoreErrors);
        }
        catch (WALException e) {
            if (e.getCause() instanceof ClosedChannelException) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Closed file during transaction, closing the entire database (error=%s)", (Object)e.toString());
                db.getEmbedded().close();
            }
            throw e;
        }
        if (this.changeStructure != null) {
            db.getSchema().getEmbedded().initComponents();
        }
        if (this.waitForResponse) {
            return new OkResponse();
        }
        return null;
    }

    public String toString() {
        return "tx(" + this.databaseName + ")";
    }
}

