/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseContext;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.DocumentCallback;
import com.arcadedb.database.DocumentIndexer;
import com.arcadedb.database.EmbeddedModifier;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.MutableEmbeddedDocument;
import com.arcadedb.database.RID;
import com.arcadedb.database.Record;
import com.arcadedb.database.RecordCallback;
import com.arcadedb.database.RecordEvents;
import com.arcadedb.database.RecordFactory;
import com.arcadedb.database.TransactionContext;
import com.arcadedb.database.TransactionExplicitLock;
import com.arcadedb.database.async.DatabaseAsyncExecutor;
import com.arcadedb.database.async.ErrorCallback;
import com.arcadedb.database.async.OkCallback;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.engine.ErrorRecordCallback;
import com.arcadedb.engine.FileManager;
import com.arcadedb.engine.PageManager;
import com.arcadedb.engine.TransactionManager;
import com.arcadedb.engine.WALFile;
import com.arcadedb.engine.WALFileFactory;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.GraphEngine;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.IndexCursor;
import com.arcadedb.query.QueryEngine;
import com.arcadedb.query.select.Select;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.query.sql.parser.ExecutionPlanCache;
import com.arcadedb.query.sql.parser.StatementCache;
import com.arcadedb.schema.Schema;
import com.arcadedb.security.SecurityDatabaseUser;
import com.arcadedb.serializer.BinarySerializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;

public class ServerDatabase
implements DatabaseInternal {
    private final DatabaseInternal wrapped;

    public ServerDatabase(DatabaseInternal wrapped) {
        this.wrapped = wrapped;
    }

    public DatabaseInternal getWrappedDatabaseInstance() {
        return this.wrapped;
    }

    public void drop() {
        throw new UnsupportedOperationException("Embedded database taken from the server are shared and therefore cannot be dropped");
    }

    public void close() {
        throw new UnsupportedOperationException("Embedded database taken from the server are shared and therefore cannot be closed");
    }

    public void kill() {
        throw new UnsupportedOperationException("Embedded database taken from the server are shared and therefore cannot be killed");
    }

    public DatabaseAsyncExecutor async() {
        return this.wrapped.async();
    }

    public Map<String, Object> getStats() {
        return this.wrapped.getStats();
    }

    public String getDatabasePath() {
        return this.wrapped.getDatabasePath();
    }

    public String getCurrentUserName() {
        return this.wrapped.getCurrentUserName();
    }

    public Select select() {
        return this.wrapped.select();
    }

    public Map<String, Object> alignToReplicas() {
        throw new UnsupportedOperationException("Align Database not supported");
    }

    public Record invokeAfterReadEvents(Record record) {
        return record;
    }

    public TransactionContext getTransactionIfExists() {
        return this.wrapped.getTransactionIfExists();
    }

    public void begin() {
        this.wrapped.begin();
    }

    public void begin(Database.TRANSACTION_ISOLATION_LEVEL isolationLevel) {
        this.wrapped.begin(isolationLevel);
    }

    public void commit() {
        this.wrapped.commit();
    }

    public void rollback() {
        this.wrapped.rollback();
    }

    public void rollbackAllNested() {
        this.wrapped.rollbackAllNested();
    }

    public long countBucket(String bucketName) {
        return this.wrapped.countBucket(bucketName);
    }

    public long countType(String typeName, boolean polymorphic) {
        return this.wrapped.countType(typeName, polymorphic);
    }

    public void scanType(String typeName, boolean polymorphic, DocumentCallback callback) {
        this.wrapped.scanType(typeName, polymorphic, callback);
    }

    public void scanType(String typeName, boolean polymorphic, DocumentCallback callback, ErrorRecordCallback errorRecordCallback) {
        this.wrapped.scanType(typeName, polymorphic, callback, errorRecordCallback);
    }

    public void scanBucket(String bucketName, RecordCallback callback) {
        this.wrapped.scanBucket(bucketName, callback);
    }

    public void scanBucket(String bucketName, RecordCallback callback, ErrorRecordCallback errorRecordCallback) {
        this.wrapped.scanBucket(bucketName, callback, errorRecordCallback);
    }

    public Iterator<Record> iterateType(String typeName, boolean polymorphic) {
        return this.wrapped.iterateType(typeName, polymorphic);
    }

    public Iterator<Record> iterateBucket(String bucketName) {
        return this.wrapped.iterateBucket(bucketName);
    }

    public void checkPermissionsOnDatabase(SecurityDatabaseUser.DATABASE_ACCESS access) {
        this.wrapped.checkPermissionsOnDatabase(access);
    }

    public void checkPermissionsOnFile(int fileId, SecurityDatabaseUser.ACCESS access) {
        this.wrapped.checkPermissionsOnFile(fileId, access);
    }

    public long getResultSetLimit() {
        return this.wrapped.getResultSetLimit();
    }

    public long getReadTimeout() {
        return this.wrapped.getReadTimeout();
    }

    public boolean existsRecord(RID rid) {
        return this.wrapped.existsRecord(rid);
    }

    public Record lookupByRID(RID rid, boolean loadContent) {
        return this.wrapped.lookupByRID(rid, loadContent);
    }

    public IndexCursor lookupByKey(String type, String keyName, Object keyValue) {
        return this.wrapped.lookupByKey(type, keyName, keyValue);
    }

    public IndexCursor lookupByKey(String type, String[] keyNames, Object[] keyValues) {
        return this.wrapped.lookupByKey(type, keyNames, keyValues);
    }

    public void registerCallback(DatabaseInternal.CALLBACK_EVENT event, Callable<Void> callback) {
        this.wrapped.registerCallback(event, callback);
    }

    public void unregisterCallback(DatabaseInternal.CALLBACK_EVENT event, Callable<Void> callback) {
        this.wrapped.unregisterCallback(event, callback);
    }

    public GraphEngine getGraphEngine() {
        return this.wrapped.getGraphEngine();
    }

    public TransactionManager getTransactionManager() {
        return this.wrapped.getTransactionManager();
    }

    public boolean isReadYourWrites() {
        return this.wrapped.isReadYourWrites();
    }

    public Database setReadYourWrites(boolean readYourWrites) {
        this.wrapped.setReadYourWrites(readYourWrites);
        return this;
    }

    public Database setTransactionIsolationLevel(Database.TRANSACTION_ISOLATION_LEVEL level) {
        return this.wrapped.setTransactionIsolationLevel(level);
    }

    public Database.TRANSACTION_ISOLATION_LEVEL getTransactionIsolationLevel() {
        return this.wrapped.getTransactionIsolationLevel();
    }

    public int getEdgeListSize() {
        return this.wrapped.getEdgeListSize();
    }

    public Database setUseWAL(boolean useWAL) {
        return this.wrapped.setUseWAL(useWAL);
    }

    public Database setWALFlush(WALFile.FlushType flush) {
        return this.wrapped.setWALFlush(flush);
    }

    public boolean isAsyncFlush() {
        return this.wrapped.isAsyncFlush();
    }

    public Database setAsyncFlush(boolean value) {
        return this.wrapped.setAsyncFlush(value);
    }

    public void createRecord(MutableDocument record) {
        this.wrapped.createRecord(record);
    }

    public void createRecord(Record record, String bucketName) {
        this.wrapped.createRecord(record, bucketName);
    }

    public void createRecordNoLock(Record record, String bucketName, boolean discardRecordAfter) {
        this.wrapped.createRecordNoLock(record, bucketName, false);
    }

    public void updateRecord(Record record) {
        this.wrapped.updateRecord(record);
    }

    public void updateRecordNoLock(Record record, boolean discardRecordAfter) {
        this.wrapped.updateRecordNoLock(record, discardRecordAfter);
    }

    public void deleteRecordNoLock(Record record) {
        this.wrapped.deleteRecordNoLock(record);
    }

    public void deleteRecord(Record record) {
        this.wrapped.deleteRecord(record);
    }

    public boolean isTransactionActive() {
        return this.wrapped.isTransactionActive();
    }

    public int getNestedTransactions() {
        return this.wrapped.getNestedTransactions();
    }

    public TransactionExplicitLock acquireLock() {
        return this.wrapped.acquireLock();
    }

    public void transaction(BasicDatabase.TransactionScope txBlock) {
        this.wrapped.transaction(txBlock);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTx) {
        return this.wrapped.transaction(txBlock, joinCurrentTx);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTx, int retries) {
        return this.wrapped.transaction(txBlock, joinCurrentTx, retries);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTx, int attempts, OkCallback ok, ErrorCallback error) {
        return this.wrapped.transaction(txBlock, joinCurrentTx, attempts, ok, error);
    }

    public RecordFactory getRecordFactory() {
        return this.wrapped.getRecordFactory();
    }

    public Schema getSchema() {
        return this.wrapped.getSchema();
    }

    public RecordEvents getEvents() {
        return this.wrapped.getEvents();
    }

    public BinarySerializer getSerializer() {
        return this.wrapped.getSerializer();
    }

    public PageManager getPageManager() {
        return this.wrapped.getPageManager();
    }

    public MutableDocument newDocument(String typeName) {
        return this.wrapped.newDocument(typeName);
    }

    public MutableEmbeddedDocument newEmbeddedDocument(EmbeddedModifier modifier, String typeName) {
        return this.wrapped.newEmbeddedDocument(modifier, typeName);
    }

    public MutableVertex newVertex(String typeName) {
        return this.wrapped.newVertex(typeName);
    }

    public Edge newEdgeByKeys(String sourceVertexType, String[] sourceVertexKeyNames, Object[] sourceVertexKeyValues, String destinationVertexType, String[] destinationVertexKeyNames, Object[] destinationVertexKeyValues, boolean createVertexIfNotExist, String edgeType, boolean bidirectional, Object ... properties) {
        return this.wrapped.newEdgeByKeys(sourceVertexType, sourceVertexKeyNames, sourceVertexKeyValues, destinationVertexType, destinationVertexKeyNames, destinationVertexKeyValues, createVertexIfNotExist, edgeType, bidirectional, properties);
    }

    public Edge newEdgeByKeys(Vertex sourceVertex, String destinationVertexType, String[] destinationVertexKeyNames, Object[] destinationVertexKeyValues, boolean createVertexIfNotExist, String edgeType, boolean bidirectional, Object ... properties) {
        return this.wrapped.newEdgeByKeys(sourceVertex, destinationVertexType, destinationVertexKeyNames, destinationVertexKeyValues, createVertexIfNotExist, edgeType, bidirectional, properties);
    }

    public QueryEngine getQueryEngine(String language) {
        return this.wrapped.getQueryEngine(language);
    }

    public boolean isAutoTransaction() {
        return this.wrapped.isAutoTransaction();
    }

    public void setAutoTransaction(boolean autoTransaction) {
        this.wrapped.setAutoTransaction(autoTransaction);
    }

    public FileManager getFileManager() {
        return this.wrapped.getFileManager();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public ComponentFile.MODE getMode() {
        return this.wrapped.getMode();
    }

    public boolean checkTransactionIsActive(boolean createTx) {
        return this.wrapped.checkTransactionIsActive(createTx);
    }

    public boolean isAsyncProcessing() {
        return this.wrapped.isAsyncProcessing();
    }

    public DocumentIndexer getIndexer() {
        return this.wrapped.getIndexer();
    }

    public ResultSet command(String language, String query, ContextConfiguration configuration, Object ... args) {
        return this.wrapped.command(language, query, configuration, args);
    }

    public ResultSet command(String language, String query, Object ... parameters) {
        return this.wrapped.command(language, query, parameters);
    }

    public ResultSet command(String language, String query, Map<String, Object> parameters) {
        return this.wrapped.command(language, query, parameters);
    }

    public ResultSet command(String language, String query, ContextConfiguration configuration, Map<String, Object> args) {
        return this.wrapped.command(language, query, configuration, args);
    }

    @Deprecated
    public ResultSet execute(String language, String script, Map<String, Object> params) {
        return this.wrapped.execute(language, script, params);
    }

    @Deprecated
    public ResultSet execute(String language, String script, Object ... args) {
        return this.wrapped.execute(language, script, args);
    }

    public ResultSet query(String language, String query, Object ... parameters) {
        return this.wrapped.query(language, query, parameters);
    }

    public ResultSet query(String language, String query, Map<String, Object> parameters) {
        return this.wrapped.query(language, query, parameters);
    }

    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    public DatabaseContext.DatabaseContextTL getContext() {
        return this.wrapped.getContext();
    }

    public <RET> RET executeInReadLock(Callable<RET> callable) {
        return (RET)this.wrapped.executeInReadLock(callable);
    }

    public <RET> RET executeInWriteLock(Callable<RET> callable) {
        return (RET)this.wrapped.executeInWriteLock(callable);
    }

    public <RET> RET executeLockingFiles(Collection<Integer> fileIds, Callable<RET> callable) {
        return (RET)this.wrapped.executeLockingFiles(fileIds, callable);
    }

    public <RET> RET recordFileChanges(Callable<Object> callback) {
        return (RET)this.wrapped.recordFileChanges(callback);
    }

    public void saveConfiguration() throws IOException {
        this.wrapped.saveConfiguration();
    }

    public StatementCache getStatementCache() {
        return this.wrapped.getStatementCache();
    }

    public ExecutionPlanCache getExecutionPlanCache() {
        return this.wrapped.getExecutionPlanCache();
    }

    public WALFileFactory getWALFileFactory() {
        return this.wrapped.getWALFileFactory();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public void executeCallbacks(DatabaseInternal.CALLBACK_EVENT event) throws IOException {
        this.wrapped.executeCallbacks(event);
    }

    public DatabaseInternal getEmbedded() {
        return this.wrapped.getEmbedded();
    }

    public ContextConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public Database setEdgeListSize(int size) {
        this.wrapped.setEdgeListSize(size);
        return this;
    }

    public int getNewEdgeListSize(int previousSize) {
        return this.wrapped.getNewEdgeListSize(previousSize);
    }

    public Map<String, Object> getWrappers() {
        return this.wrapped.getWrappers();
    }

    public void setWrapper(String name, Object instance) {
        this.wrapped.setWrapper(name, instance);
    }

    public long getLastUpdatedOn() {
        return this.wrapped.getLastUpdatedOn();
    }

    public long getLastUsedOn() {
        return this.wrapped.getLastUsedOn();
    }

    public long getOpenedOn() {
        return this.wrapped.getOpenedOn();
    }
}

