/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.security;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.utility.Callable;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public class SecurityGroupFileRepository {
    public static final String FILE_NAME = "server-groups.json";
    private final String securityConfPath;
    private final File file;
    private final int checkConfigReloadEveryMs;
    private long fileLastUpdated = 0L;
    private Timer checkFileUpdatedTimer;
    private Callable<Void, JSONObject> reloadCallback = null;
    private volatile JSONObject latestGroupConfiguration;

    public SecurityGroupFileRepository(String securityConfPath, int checkConfigReloadEveryMs) {
        if (!((String)securityConfPath).endsWith(File.separator)) {
            securityConfPath = (String)securityConfPath + File.separator;
        }
        this.securityConfPath = securityConfPath;
        this.file = new File((String)securityConfPath, FILE_NAME);
        this.checkConfigReloadEveryMs = checkConfigReloadEveryMs;
    }

    public void stop() {
        if (this.checkFileUpdatedTimer != null) {
            this.checkFileUpdatedTimer.cancel();
        }
    }

    public synchronized void save(JSONObject configuration) throws IOException {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(this.file, DatabaseFactory.getDefaultCharset());){
            writer.write(configuration.toString(2));
            this.latestGroupConfiguration = configuration;
        }
    }

    public synchronized void saveInError(Exception e) {
        if (this.latestGroupConfiguration == null) {
            return;
        }
        LogManager.instance().log((Object)this, Level.SEVERE, "Error on loading file '%s', using the default configuration and saving the corrupt file as 'config/server-groups-error.json'", (Throwable)e, (Object)FILE_NAME);
        String fileName = this.securityConfPath + FILE_NAME;
        int pos = fileName.lastIndexOf(".");
        String errorFileName = fileName.substring(0, pos) + "-error.json";
        File file = new File(errorFileName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file, DatabaseFactory.getDefaultCharset());){
            writer.write(this.latestGroupConfiguration.toString());
        }
        catch (Exception e2) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on saving configuration in error in config/security-error.json", (Throwable)e2);
        }
    }

    public JSONObject getGroups() {
        if (this.latestGroupConfiguration == null) {
            try {
                this.load();
            }
            catch (Exception e) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Error on loading file '%s', using default configuration", (Throwable)e, (Object)FILE_NAME);
                this.saveInError(e);
                this.latestGroupConfiguration = this.createDefault();
            }
        }
        return this.latestGroupConfiguration;
    }

    protected synchronized JSONObject load() throws IOException {
        if (this.checkFileUpdatedTimer == null) {
            final Timer timer = this.checkFileUpdatedTimer = new Timer();
            this.checkFileUpdatedTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (SecurityGroupFileRepository.this.checkFileUpdatedTimer == timer) {
                        try {
                            if (SecurityGroupFileRepository.this.file.exists() && SecurityGroupFileRepository.this.file.lastModified() > SecurityGroupFileRepository.this.fileLastUpdated) {
                                LogManager.instance().log((Object)this, Level.INFO, "Server groups configuration changed, reloading it...");
                                SecurityGroupFileRepository.this.load();
                                if (SecurityGroupFileRepository.this.reloadCallback != null) {
                                    SecurityGroupFileRepository.this.reloadCallback.call((Object)SecurityGroupFileRepository.this.latestGroupConfiguration);
                                }
                            }
                        }
                        catch (Throwable e) {
                            LogManager.instance().log((Object)this, Level.SEVERE, "Error on reloading file '%s' after was changed", e, (Object)SecurityGroupFileRepository.FILE_NAME);
                        }
                    }
                }
            }, this.checkConfigReloadEveryMs, (long)this.checkConfigReloadEveryMs);
        }
        JSONObject json = null;
        if (this.file.exists()) {
            this.fileLastUpdated = this.file.lastModified();
            try (FileInputStream fis = new FileInputStream(this.file);){
                json = new JSONObject(FileUtils.readStreamAsString((InputStream)fis, (String)"UTF-8"));
            }
            if (!json.has("version")) {
                json = null;
            }
        }
        if (json == null) {
            json = this.createDefault();
        }
        if (json != null) {
            this.latestGroupConfiguration = json;
        }
        return json;
    }

    public JSONObject createDefault() {
        JSONObject json = new JSONObject();
        JSONObject defaultDatabase = new JSONObject().put("groups", (Object)new JSONObject().put("admin", (Object)new JSONObject().put("resultSetLimit", (Number)-1L).put("readTimeout", (Number)-1L).put("access", (Object)new JSONArray(new String[]{"updateSecurity", "updateSchema", "updateDatabaseSettings"})).put("types", (Object)new JSONObject().put("*", (Object)new JSONObject().put("access", (Object)new JSONArray(new String[]{"createRecord", "readRecord", "updateRecord", "deleteRecord"}))))).put("*", (Object)new JSONObject().put("resultSetLimit", (Number)-1L).put("readTimeout", (Number)-1L).put("access", (Object)new JSONArray()).put("types", (Object)new JSONObject().put("*", (Object)new JSONObject().put("access", (Object)new JSONArray())))));
        json.put("databases", (Object)new JSONObject().put("*", (Object)defaultDatabase));
        json.put("version", (Number)1);
        try {
            this.save(json);
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on saving default group configuration to file '%s'", (Throwable)e, (Object)FILE_NAME);
        }
        return json;
    }

    public SecurityGroupFileRepository onReload(Callable<Void, JSONObject> callback) {
        this.reloadCallback = callback;
        return this;
    }
}

