/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.monitor;

import com.arcadedb.server.monitor.ServerMetrics;

public class MetricMeter
implements ServerMetrics.Meter {
    private long totalCounter = 0L;
    private final long[] lastMinuteCounters = new long[60];
    private int lastMinuteCountersIndex = 0;
    private long lastHitTimestampInSecs = 0L;
    private long lastAskedTimestampInSecs = 0L;

    @Override
    public synchronized void hit() {
        ++this.totalCounter;
        this.updateCountersFromLastHit();
        int n = this.lastMinuteCountersIndex;
        this.lastMinuteCounters[n] = this.lastMinuteCounters[n] + 1L;
    }

    @Override
    public synchronized float getRequestsPerSecondInLastMinute() {
        return (float)this.getTotalRequestsInLastMinute() / 60.0f;
    }

    @Override
    public synchronized float getRequestsPerSecondSinceLastAsked() {
        long nowInSecs = this.updateCountersFromLastHit();
        long diffInSecs = nowInSecs - this.lastAskedTimestampInSecs;
        if (diffInSecs < 1L) {
            return 0.0f;
        }
        long total = 0L;
        int index = this.lastMinuteCountersIndex;
        int i = 0;
        while ((long)i < diffInSecs) {
            index = index == 0 ? 59 : --index;
            total += this.lastMinuteCounters[index];
            ++i;
        }
        this.lastAskedTimestampInSecs = nowInSecs;
        return total / diffInSecs;
    }

    @Override
    public synchronized long getTotalRequestsInLastMinute() {
        this.updateCountersFromLastHit();
        long total = 0L;
        for (int i = 0; i < 60; ++i) {
            total += this.lastMinuteCounters[i];
        }
        return total;
    }

    @Override
    public synchronized long getTotalCounter() {
        return this.totalCounter;
    }

    private long updateCountersFromLastHit() {
        long nowInSecs = System.currentTimeMillis() / 1000L;
        if (this.lastHitTimestampInSecs == 0L) {
            this.lastHitTimestampInSecs = nowInSecs;
            return nowInSecs;
        }
        long diffInSecsFromLastHit = nowInSecs - this.lastHitTimestampInSecs;
        if (diffInSecsFromLastHit > 0L) {
            int i = 0;
            while ((long)i < diffInSecsFromLastHit) {
                this.lastMinuteCountersIndex = this.lastMinuteCountersIndex >= 59 ? 0 : ++this.lastMinuteCountersIndex;
                this.lastMinuteCounters[this.lastMinuteCountersIndex] = 0L;
                ++i;
            }
            this.lastHitTimestampInSecs = nowInSecs;
        }
        return nowInSecs;
    }
}

