/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseContext;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.TransactionContext;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.security.SecurityDatabaseUser;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.HttpSession;
import com.arcadedb.server.http.handler.AbstractServerHttpHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public abstract class DatabaseAbstractHandler
extends AbstractServerHttpHandler {
    private static final HttpString SESSION_ID_HEADER = new HttpString("arcadedb-session-id");

    protected DatabaseAbstractHandler(HttpServer httpServer) {
        super(httpServer);
    }

    protected abstract ExecutionResponse execute(HttpServerExchange var1, ServerSecurityUser var2, Database var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user) throws Exception {
        ServerDatabase database;
        HttpSession activeSession = null;
        boolean atomicTransaction = false;
        if (this.requiresDatabase()) {
            SecurityDatabaseUser currentUser;
            Deque databaseName = (Deque)exchange.getQueryParameters().get("database");
            if (databaseName.isEmpty()) {
                return new ExecutionResponse(400, "{ \"error\" : \"Database parameter is null\"}");
            }
            database = this.httpServer.getServer().getDatabase((String)databaseName.getFirst(), false, false);
            DatabaseContext.DatabaseContextTL current = DatabaseContext.INSTANCE.getContextIfExists(database.getDatabasePath());
            if (current != null && !current.transactions.isEmpty() && ((TransactionContext)current.transactions.get(0)).isActive()) {
                LogManager.instance().log((Object)this, Level.WARNING, "Found a pending transaction from a previous operation. Rolling it back...");
                this.cleanTL((Database)database, current);
            }
            activeSession = this.setTransactionInThreadLocal(exchange, (Database)database, user);
            current = DatabaseContext.INSTANCE.getContextIfExists(database.getDatabasePath());
            if (current == null) {
                current = DatabaseContext.INSTANCE.init((DatabaseInternal)database);
            }
            if ((currentUser = current.getCurrentUser()) == null || !currentUser.equals((Object)user.getDatabaseUser((Database)database))) {
                current.setCurrentUser(user != null ? user.getDatabaseUser((Database)database) : null);
            }
            if (this.requiresTransaction() && activeSession == null) {
                atomicTransaction = true;
                database.begin();
            }
        } else {
            database = null;
        }
        AtomicReference<ExecutionResponse> response = new AtomicReference<ExecutionResponse>();
        try {
            if (activeSession != null) {
                activeSession.execute(user, () -> {
                    response.set(this.execute(exchange, user, (Database)database));
                    return null;
                });
            } else {
                response.set(this.execute(exchange, user, (Database)database));
            }
            if (database != null && atomicTransaction && database.isTransactionActive()) {
                database.commit();
            }
        }
        finally {
            if (activeSession != null) {
                DatabaseContext.INSTANCE.removeContext(database.getDatabasePath());
            } else if (database != null) {
                try {
                    if (!atomicTransaction) {
                        database.rollbackAllNested();
                    }
                }
                finally {
                    this.cleanTL((Database)database, null);
                }
            }
        }
        return (ExecutionResponse)response.get();
    }

    private void cleanTL(Database database, DatabaseContext.DatabaseContextTL current) {
        if (current == null) {
            current = DatabaseContext.INSTANCE.getContextIfExists(database.getDatabasePath());
        }
        if (current != null) {
            TransactionContext tx;
            while ((tx = current.popIfNotLastTransaction()) != null && tx.isActive()) {
                tx.rollback();
            }
            DatabaseContext.INSTANCE.removeContext(database.getDatabasePath());
        }
    }

    protected boolean requiresDatabase() {
        return true;
    }

    protected boolean requiresTransaction() {
        return true;
    }

    protected HttpSession setTransactionInThreadLocal(HttpServerExchange exchange, Database database, ServerSecurityUser user) {
        HeaderValues sessionId = exchange.getRequestHeaders().get("arcadedb-session-id");
        if (sessionId != null && !sessionId.isEmpty()) {
            HttpSession session = this.httpServer.getSessionManager().getSessionById(user, sessionId.getFirst());
            if (session == null) {
                exchange.setStatusCode(401);
                throw new TransactionException("Remote transaction not found or expired");
            }
            DatabaseContext.INSTANCE.init((DatabaseInternal)database, session.transaction);
            exchange.getResponseHeaders().put(SESSION_ID_HEADER, session.id);
            return session;
        }
        return null;
    }
}

