/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.RID;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.log.LogManager;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.LocalEdgeType;
import com.arcadedb.schema.LocalVertexType;
import com.arcadedb.serializer.JsonGraphSerializer;
import com.arcadedb.serializer.JsonSerializer;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.DatabaseAbstractHandler;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;

public abstract class AbstractQueryHandler
extends DatabaseAbstractHandler {
    protected static final int DEFAULT_LIMIT = 20000;

    public AbstractQueryHandler(HttpServer httpServer) {
        super(httpServer);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void serializeResultSet(Database database, String serializer, int limit, JSONObject response, ResultSet qResult) {
        if (qResult == null) {
            return;
        }
        var6_6 = serializer;
        var7_7 = -1;
        switch (var6_6.hashCode()) {
            case 98615630: {
                if (!var6_6.equals("graph")) break;
                var7_7 = 0;
                break;
            }
            case -891901482: {
                if (!var6_6.equals("studio")) break;
                var7_7 = 1;
                break;
            }
            case -934908847: {
                if (!var6_6.equals("record")) break;
                var7_7 = 2;
            }
        }
        switch (var7_7) {
            case 0: {
                serializerImpl = JsonGraphSerializer.createJsonGraphSerializer().setExpandVertexEdges(false);
                serializerImpl.setUseCollectionSize(false).setUseCollectionSizeForEdges(true);
                includedVertices = new HashSet<RID>();
                includedEdges = new HashSet<RID>();
                vertices = new JSONArray();
                edges = new JSONArray();
                while (qResult.hasNext()) {
                    row = qResult.next();
                    if (row.isVertex()) {
                        v = (Vertex)row.getVertex().get();
                        if (includedVertices.add(v.getIdentity())) {
                            vertices.put(serializerImpl.serializeGraphElement((Document)v));
                        }
                    } else if (row.isEdge()) {
                        e = (Edge)row.getEdge().get();
                        if (includedEdges.add(e.getIdentity())) {
                            edges.put(serializerImpl.serializeGraphElement((Document)e));
                        }
                    } else {
                        this.analyzeResultContent(database, serializerImpl, includedVertices, includedEdges, vertices, edges, row, limit);
                    }
                    if (limit <= 0 || vertices.length() + edges.length() < limit) continue;
                    break;
                }
                response.put("result", (Object)new JSONObject().put("vertices", (Object)vertices).put("edges", (Object)edges));
                break;
            }
            case 1: {
                serializerImpl = JsonGraphSerializer.createJsonGraphSerializer().setExpandVertexEdges(false);
                serializerImpl.setUseCollectionSize(false).setUseCollectionSizeForEdges(true);
                includedRecords = new HashSet<RID>();
                includedVertices = new HashSet<RID>();
                includedEdges = new HashSet<RID>();
                vertices = new JSONArray();
                edges = new JSONArray();
                records = new JSONArray();
                if (qResult == null) ** GOTO lbl103
                while (qResult.hasNext()) {
                    row = qResult.next();
                    try {
                        recordIncluded = true;
                        if (row.getIdentity().isPresent()) {
                            rid = (RID)row.getIdentity().get();
                            recordIncluded = includedRecords.add(rid);
                            if (recordIncluded) {
                                records.put(serializerImpl.serializeResult(database, row));
                            }
                        } else {
                            records.put(serializerImpl.serializeResult(database, row));
                        }
                        if (!row.isVertex()) ** GOTO lbl75
                        if (recordIncluded && includedVertices.add((v = (Vertex)row.getVertex().get()).getIdentity())) {
                            vertices.put(serializerImpl.serializeGraphElement((Document)v));
                        }
                        ** GOTO lbl101
lbl75:
                        // 1 sources

                        if (!row.isEdge()) ** GOTO lbl97
                        e = (Edge)row.getEdge().get();
                        if (!recordIncluded || !includedEdges.add(e.getIdentity())) ** GOTO lbl101
                        edges.put(serializerImpl.serializeGraphElement((Document)e));
                        try {
                            if (includedVertices.add(e.getIn())) {
                                includedRecords.add(e.getIn());
                                vertices.put(serializerImpl.serializeGraphElement((Document)e.getInVertex()));
                            }
                            if (includedVertices.add(e.getOut())) {
                                includedRecords.add(e.getOut());
                                vertices.put(serializerImpl.serializeGraphElement((Document)e.getOutVertex()));
                            }
                            ** GOTO lbl101
                        }
                        catch (RecordNotFoundException ex) {
                            LogManager.instance().log((Object)this, Level.SEVERE, "Record %s not found during serialization", (Object)ex.getRID());
                        }
                        ** GOTO lbl101
lbl97:
                        // 1 sources

                        this.analyzeResultContent(database, serializerImpl, includedVertices, includedEdges, vertices, edges, row, limit);
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Error on serializing element (error=%s)", (Object)e.getMessage());
                    }
lbl101:
                    // 7 sources

                    if (limit <= 0 || records.length() < limit) continue;
                    break;
                }
lbl103:
                // 5 sources

                for (Identifiable entry : includedVertices) {
                    if (limit > 0 && vertices.length() + edges.length() >= limit) break;
                    try {
                        vertex = entry.asVertex(true);
                        vEdgesOut = vertex.getEdges(Vertex.DIRECTION.OUT, new String[0]);
                        for (Edge e : vEdgesOut) {
                            if (!includedVertices.contains(e.getIn()) || includedEdges.contains(e.getIdentity())) continue;
                            edges.put(serializerImpl.serializeGraphElement((Document)e));
                        }
                        vEdgesIn = vertex.getEdges(Vertex.DIRECTION.IN, new String[0]);
                        for (Edge e : vEdgesIn) {
                            if (!includedVertices.contains(e.getOut()) || includedEdges.contains(e.getIdentity())) continue;
                            edges.put(serializerImpl.serializeGraphElement((Document)e));
                        }
                    }
                    catch (RecordNotFoundException e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Vertex %s not found during serialization", (Object)e.getRID());
                    }
                }
                response.put("result", (Object)new JSONObject().put("vertices", (Object)vertices).put("edges", (Object)edges).put("records", (Object)records));
                break;
            }
            case 2: {
                serializerImpl = JsonSerializer.createJsonSerializer().setIncludeVertexEdges(false).setUseCollectionSize(false).setUseCollectionSizeForEdges(false);
                result = new JSONArray();
                while (qResult.hasNext()) {
                    r = qResult.next();
                    result.put(serializerImpl.serializeResult(database, r));
                    if (limit <= 0 || result.length() < limit) continue;
                    break;
                }
                response.put("result", (Object)result);
                break;
            }
            default: {
                serializerImpl = JsonSerializer.createJsonSerializer().setIncludeVertexEdges(true).setUseCollectionSize(false).setUseCollectionSizeForEdges(false);
                result = new JSONArray(limit > 0 ? (Collection)qResult.stream().limit(limit + 1).map((Function<Result, JSONObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serializeResultSet$0(com.arcadedb.serializer.JsonSerializer com.arcadedb.database.Database com.arcadedb.query.sql.executor.Result ), (Lcom/arcadedb/query/sql/executor/Result;)Lcom/arcadedb/serializer/json/JSONObject;)((JsonSerializer)serializerImpl, (Database)database)).collect(Collectors.toList()) : (Collection)qResult.stream().map((Function<Result, JSONObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serializeResultSet$1(com.arcadedb.serializer.JsonSerializer com.arcadedb.database.Database com.arcadedb.query.sql.executor.Result ), (Lcom/arcadedb/query/sql/executor/Result;)Lcom/arcadedb/serializer/json/JSONObject;)((JsonSerializer)serializerImpl, (Database)database)).collect(Collectors.toList()));
                response.put("result", (Object)result);
            }
        }
    }

    protected void analyzeResultContent(Database database, JsonGraphSerializer serializerImpl, Set<RID> includedVertices, Set<RID> includedEdges, JSONArray vertices, JSONArray edges, Result row, int limit) {
        for (String prop : row.getPropertyNames()) {
            try {
                Object value = row.getProperty(prop);
                if (value == null) continue;
                if (limit > 0 && vertices.length() + edges.length() >= limit) break;
                if (prop.equals("@rid") && RID.is((Object)value)) {
                    this.analyzePropertyValue(database, serializerImpl, includedVertices, includedEdges, vertices, edges, new RID((BasicDatabase)database, value.toString()), limit);
                    continue;
                }
                this.analyzePropertyValue(database, serializerImpl, includedVertices, includedEdges, vertices, edges, value, limit);
            }
            catch (Exception e) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Error on serializing collection element (error=%s)", (Object)e.getMessage());
            }
        }
    }

    protected void analyzePropertyValue(Database database, JsonGraphSerializer serializerImpl, Set<RID> includedVertices, Set<RID> includedEdges, JSONArray vertices, JSONArray edges, Object value, int limit) {
        block13: {
            block14: {
                Edge edge;
                DocumentType type;
                block15: {
                    if (!(value instanceof Identifiable)) break block14;
                    if (value instanceof Document) {
                        Document document = (Document)value;
                        type = document.getType();
                    } else {
                        RID rid = ((Identifiable)value).getIdentity();
                        type = database.getSchema().getTypeByBucketId(rid.getBucketId());
                    }
                    if (!(type instanceof LocalVertexType)) break block15;
                    if (includedVertices.add(((Identifiable)value).getIdentity())) {
                        vertices.put(serializerImpl.serializeGraphElement((Document)((Identifiable)value).asVertex(true)));
                    }
                    break block13;
                }
                if (!(type instanceof LocalEdgeType) || !includedEdges.add((edge = ((Identifiable)value).asEdge(true)).getIdentity())) break block13;
                edges.put(serializerImpl.serializeGraphElement((Document)edge));
                try {
                    if (includedVertices.add(edge.getIn())) {
                        Vertex inV = edge.getInVertex();
                        vertices.put(serializerImpl.serializeGraphElement((Document)inV));
                    }
                    if (includedVertices.add(edge.getOut())) {
                        Vertex outV = edge.getOutVertex();
                        vertices.put(serializerImpl.serializeGraphElement((Document)outV));
                    }
                    break block13;
                }
                catch (RecordNotFoundException e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error on loading connecting vertices for edge %s: vertex %s not found", (Object)edge.getIdentity(), (Object)e.getRID());
                }
                break block13;
            }
            if (value instanceof Result) {
                Result result = (Result)value;
                this.analyzeResultContent(database, serializerImpl, includedVertices, includedEdges, vertices, edges, result, limit);
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    try {
                        this.analyzePropertyValue(database, serializerImpl, includedVertices, includedEdges, vertices, edges, it.next(), limit);
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Error on serializing collection element (error=%s)", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    protected Object mapParams(Map<String, Object> paramMap) {
        if (paramMap != null) {
            if (!paramMap.isEmpty() && paramMap.containsKey("0")) {
                Object[] array = new Object[paramMap.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = paramMap.get("" + i);
                }
                return array;
            }
        } else {
            paramMap = Collections.emptyMap();
        }
        return paramMap;
    }

    private static /* synthetic */ JSONObject lambda$serializeResultSet$1(JsonSerializer serializerImpl, Database database, Result r) {
        return serializerImpl.serializeResult(database, r);
    }

    private static /* synthetic */ JSONObject lambda$serializeResultSet$0(JsonSerializer serializerImpl, Database database, Result r) {
        return serializerImpl.serializeResult(database, r);
    }
}

