/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http;

import com.arcadedb.database.TransactionContext;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.security.ServerSecurityUser;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class HttpSession {
    private static final long DEFAULT_TIMEOUT = 5000L;
    public final String id;
    public final TransactionContext transaction;
    public final ServerSecurityUser user;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile long lastUpdate = 0L;

    public HttpSession(ServerSecurityUser user, String id, TransactionContext dbTx) {
        this.user = user;
        this.id = id;
        this.transaction = dbTx;
    }

    public long elapsedFromLastUpdate() {
        return System.currentTimeMillis() - this.lastUpdate;
    }

    public HttpSession execute(ServerSecurityUser user, Callable callback) throws Exception {
        if (!this.user.equals(user)) {
            throw new SecurityException("Cannot use the requested transaction because in use by a different user");
        }
        this.lastUpdate = System.currentTimeMillis();
        if (this.lock.tryLock(5000L, TimeUnit.MILLISECONDS)) {
            try {
                LogManager.instance().log((Object)this, Level.FINE, "Executing session %s for user %s", (Object)this.id, (Object)user.getName());
                callback.call();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            throw new TimeoutException("Timeout on locking http session");
        }
        this.lastUpdate = System.currentTimeMillis();
        return this;
    }
}

