/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.compression.CompressionFactory;
import com.arcadedb.database.Binary;
import com.arcadedb.engine.WALFile;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import java.util.HashMap;
import java.util.Map;

public abstract class TxRequestAbstract
extends HAAbstractCommand {
    protected String databaseName;
    protected int changesUncompressedLength;
    protected Binary changesBuffer;
    protected Map<Integer, Integer> bucketRecordDelta;

    protected TxRequestAbstract() {
    }

    protected TxRequestAbstract(String dbName, Map<Integer, Integer> bucketRecordDelta, Binary changesBuffer) {
        this.databaseName = dbName;
        changesBuffer.rewind();
        this.changesUncompressedLength = changesBuffer.size();
        this.changesBuffer = CompressionFactory.getDefault().compress(changesBuffer);
        this.bucketRecordDelta = bucketRecordDelta;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
        stream.putInt(this.changesUncompressedLength);
        stream.putBytes(this.changesBuffer.getContent(), this.changesBuffer.size());
        stream.putInt(this.bucketRecordDelta.size());
        for (Map.Entry<Integer, Integer> entry : this.bucketRecordDelta.entrySet()) {
            stream.putInt(entry.getKey().intValue());
            stream.putInt(entry.getValue().intValue());
        }
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.databaseName = stream.getString();
        this.changesUncompressedLength = stream.getInt();
        this.changesBuffer = CompressionFactory.getDefault().decompress(new Binary(stream.getBytes()), this.changesUncompressedLength);
        int deltaSize = stream.getInt();
        this.bucketRecordDelta = new HashMap<Integer, Integer>(deltaSize);
        for (int i = 0; i < deltaSize; ++i) {
            this.bucketRecordDelta.put(stream.getInt(), stream.getInt());
        }
    }

    protected WALFile.WALTransaction readTxFromBuffer() {
        int segmentSize;
        WALFile.WALTransaction tx = new WALFile.WALTransaction();
        Binary bufferChange = this.changesBuffer;
        int pos = 0;
        tx.txId = bufferChange.getLong(pos);
        tx.timestamp = bufferChange.getLong(pos += 8);
        int pages = bufferChange.getInt(pos += 8);
        pos += 4;
        if ((pos += 4) + (segmentSize = bufferChange.getInt(pos)) + 8 > bufferChange.size()) {
            throw new ReplicationException("Replicated transaction buffer is corrupted");
        }
        tx.pages = new WALFile.WALPage[pages];
        for (int i = 0; i < pages; ++i) {
            if (pos > bufferChange.size()) {
                throw new ReplicationException("Replicated transaction buffer is corrupted");
            }
            tx.pages[i] = new WALFile.WALPage();
            tx.pages[i].fileId = bufferChange.getInt(pos);
            tx.pages[i].pageNumber = bufferChange.getInt(pos += 4);
            tx.pages[i].changesFrom = bufferChange.getInt(pos += 4);
            tx.pages[i].changesTo = bufferChange.getInt(pos += 4);
            int deltaSize = tx.pages[i].changesTo - tx.pages[i].changesFrom + 1;
            tx.pages[i].currentPageVersion = bufferChange.getInt(pos += 4);
            tx.pages[i].currentPageSize = bufferChange.getInt(pos += 4);
            byte[] buffer = new byte[deltaSize];
            tx.pages[i].currentContent = new Binary(buffer);
            bufferChange.getByteArray(pos += 4, buffer, 0, deltaSize);
            pos += deltaSize;
        }
        long mn = bufferChange.getLong(pos + 4);
        if (mn != 9371515385058702L) {
            throw new ReplicationException("Replicated transaction buffer is corrupted");
        }
        return tx;
    }
}

