/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.OkResponse;
import java.io.IOException;

public class InstallDatabaseRequest
extends HAAbstractCommand {
    private String databaseName;

    public InstallDatabaseRequest() {
    }

    public InstallDatabaseRequest(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        try {
            server.getLeader().requestInstallDatabase(new Binary(), this.databaseName);
            return new OkResponse();
        }
        catch (IOException e) {
            throw new ReplicationException("Error on installing database '" + this.databaseName + "' on replica '" + server.getServerName() + "'", e);
        }
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.databaseName = stream.getString();
    }

    public String toString() {
        return "installDatabase(" + this.databaseName + ")";
    }
}

