/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseContext;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.DocumentCallback;
import com.arcadedb.database.DocumentIndexer;
import com.arcadedb.database.EmbeddedModifier;
import com.arcadedb.database.LocalDatabase;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.MutableEmbeddedDocument;
import com.arcadedb.database.RID;
import com.arcadedb.database.Record;
import com.arcadedb.database.RecordCallback;
import com.arcadedb.database.RecordEvents;
import com.arcadedb.database.RecordFactory;
import com.arcadedb.database.TransactionContext;
import com.arcadedb.database.async.DatabaseAsyncExecutor;
import com.arcadedb.database.async.ErrorCallback;
import com.arcadedb.database.async.OkCallback;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.engine.ErrorRecordCallback;
import com.arcadedb.engine.FileManager;
import com.arcadedb.engine.PageManager;
import com.arcadedb.engine.TransactionManager;
import com.arcadedb.engine.WALFile;
import com.arcadedb.engine.WALFileFactory;
import com.arcadedb.exception.ConfigurationException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.GraphEngine;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.IndexCursor;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.query.QueryEngine;
import com.arcadedb.query.select.Select;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.query.sql.parser.ExecutionPlanCache;
import com.arcadedb.query.sql.parser.StatementCache;
import com.arcadedb.schema.Schema;
import com.arcadedb.security.SecurityDatabaseUser;
import com.arcadedb.serializer.BinarySerializer;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.CommandForwardRequest;
import com.arcadedb.server.ha.message.DatabaseAlignRequest;
import com.arcadedb.server.ha.message.DatabaseAlignResponse;
import com.arcadedb.server.ha.message.DatabaseChangeStructureRequest;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.InstallDatabaseRequest;
import com.arcadedb.server.ha.message.TxForwardRequest;
import com.arcadedb.server.ha.message.TxRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class ReplicatedDatabase
implements DatabaseInternal {
    private final ArcadeDBServer server;
    private final LocalDatabase proxied;
    private final HAServer.QUORUM quorum;
    private final long timeout;

    public ReplicatedDatabase(ArcadeDBServer server, LocalDatabase proxied) {
        HAServer.QUORUM quorum;
        if (!server.getConfiguration().getValueAsBoolean(GlobalConfiguration.TX_WAL)) {
            throw new ConfigurationException("Cannot use replicated database if transaction WAL is disabled");
        }
        this.server = server;
        this.proxied = proxied;
        this.timeout = proxied.getConfiguration().getValueAsLong(GlobalConfiguration.HA_QUORUM_TIMEOUT);
        this.proxied.setWrappedDatabaseInstance((DatabaseInternal)this);
        String quorumValue = proxied.getConfiguration().getValueAsString(GlobalConfiguration.HA_QUORUM).toUpperCase(Locale.ENGLISH);
        try {
            quorum = HAServer.QUORUM.valueOf(quorumValue);
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on setting quorum to '%s' for database '%s'. Setting it to MAJORITY", (Throwable)e, (Object)quorumValue, (Object)this.getName());
            quorum = HAServer.QUORUM.MAJORITY;
        }
        this.quorum = quorum;
    }

    public void commit() {
        this.proxied.incrementStatsTxCommits();
        boolean isLeader = this.isLeader();
        this.proxied.executeInReadLock(() -> {
            this.proxied.checkTransactionIsActive(false);
            DatabaseContext.DatabaseContextTL current = DatabaseContext.INSTANCE.getContext(this.proxied.getDatabasePath());
            TransactionContext tx = current.getLastTransaction();
            try {
                TransactionContext.TransactionPhase1 phase1 = tx.commit1stPhase(isLeader);
                try {
                    if (phase1 != null) {
                        Binary bufferChanges = phase1.result;
                        if (isLeader) {
                            this.replicateTx(tx, phase1, bufferChanges);
                        } else {
                            TxForwardRequest command = new TxForwardRequest(this, this.getTransactionIsolationLevel(), tx.getBucketRecordDelta(), bufferChanges, tx.getIndexChanges().toMap());
                            this.server.getHA().forwardCommandToLeader(command, this.timeout * 2L);
                            tx.reset();
                        }
                    } else {
                        tx.reset();
                    }
                }
                catch (NeedRetryException | TransactionException e) {
                    this.rollback();
                    throw e;
                }
                catch (Exception e) {
                    this.rollback();
                    throw new TransactionException("Error on commit distributed transaction", (Throwable)e);
                }
                if (this.getSchema().getEmbedded().isDirty()) {
                    this.getSchema().getEmbedded().saveConfiguration();
                }
            }
            finally {
                current.popIfNotLastTransaction();
            }
            return null;
        });
    }

    public void replicateTx(TransactionContext tx, TransactionContext.TransactionPhase1 phase1, Binary bufferChanges) {
        int configuredServers = this.server.getHA().getConfiguredServers();
        int reqQuorum = this.quorum.quorum(configuredServers);
        TxRequest req = new TxRequest(this.getName(), tx.getBucketRecordDelta(), bufferChanges, reqQuorum > 1);
        DatabaseChangeStructureRequest changeStructureRequest = this.getChangeStructure(-1L);
        if (changeStructureRequest != null) {
            this.proxied.getFileManager().stopRecordingChanges();
            this.proxied.getFileManager().startRecordingChanges();
            req.changeStructure = changeStructureRequest;
        }
        this.server.getHA().sendCommandToReplicasWithQuorum(req, reqQuorum, this.timeout);
        tx.commit2ndPhase(phase1);
    }

    public DatabaseInternal getWrappedDatabaseInstance() {
        return this;
    }

    public Map<String, Object> getWrappers() {
        return this.proxied.getWrappers();
    }

    public void setWrapper(String name, Object instance) {
        this.proxied.setWrapper(name, instance);
    }

    public void checkPermissionsOnDatabase(SecurityDatabaseUser.DATABASE_ACCESS access) {
        this.proxied.checkPermissionsOnDatabase(access);
    }

    public void checkPermissionsOnFile(int fileId, SecurityDatabaseUser.ACCESS access) {
        this.proxied.checkPermissionsOnFile(fileId, access);
    }

    public long getResultSetLimit() {
        return this.proxied.getResultSetLimit();
    }

    public long getReadTimeout() {
        return this.proxied.getReadTimeout();
    }

    public Map<String, Object> getStats() {
        return this.proxied.getStats();
    }

    public LocalDatabase getEmbedded() {
        return this.proxied;
    }

    public DatabaseContext.DatabaseContextTL getContext() {
        return this.proxied.getContext();
    }

    public void close() {
        this.proxied.close();
    }

    public void drop() {
        throw new UnsupportedOperationException("Server proxied database instance cannot be drop");
    }

    public void registerCallback(DatabaseInternal.CALLBACK_EVENT event, Callable<Void> callback) {
        this.proxied.registerCallback(event, callback);
    }

    public void unregisterCallback(DatabaseInternal.CALLBACK_EVENT event, Callable<Void> callback) {
        this.proxied.unregisterCallback(event, callback);
    }

    public void executeCallbacks(DatabaseInternal.CALLBACK_EVENT event) throws IOException {
        this.proxied.executeCallbacks(event);
    }

    public GraphEngine getGraphEngine() {
        return this.proxied.getGraphEngine();
    }

    public TransactionManager getTransactionManager() {
        return this.proxied.getTransactionManager();
    }

    public void createRecord(MutableDocument record) {
        this.proxied.createRecord(record);
    }

    public void createRecord(Record record, String bucketName) {
        this.proxied.createRecord(record, bucketName);
    }

    public void createRecordNoLock(Record record, String bucketName, boolean discardRecordAfter) {
        this.proxied.createRecordNoLock(record, bucketName, discardRecordAfter);
    }

    public void updateRecord(Record record) {
        this.proxied.updateRecord(record);
    }

    public void updateRecordNoLock(Record record, boolean discardRecordAfter) {
        this.proxied.updateRecordNoLock(record, discardRecordAfter);
    }

    public void deleteRecordNoLock(Record record) {
        this.proxied.deleteRecordNoLock(record);
    }

    public DocumentIndexer getIndexer() {
        return this.proxied.getIndexer();
    }

    public void kill() {
        this.proxied.kill();
    }

    public WALFileFactory getWALFileFactory() {
        return this.proxied.getWALFileFactory();
    }

    public StatementCache getStatementCache() {
        return this.proxied.getStatementCache();
    }

    public ExecutionPlanCache getExecutionPlanCache() {
        return this.proxied.getExecutionPlanCache();
    }

    public int getNewEdgeListSize(int previousSize) {
        return this.proxied.getNewEdgeListSize(previousSize);
    }

    public String getName() {
        return this.proxied.getName();
    }

    public ComponentFile.MODE getMode() {
        return this.proxied.getMode();
    }

    public DatabaseAsyncExecutor async() {
        return this.proxied.async();
    }

    public String getDatabasePath() {
        return this.proxied.getDatabasePath();
    }

    public String getCurrentUserName() {
        return this.proxied.getCurrentUserName();
    }

    public Select select() {
        return this.proxied.select();
    }

    public ContextConfiguration getConfiguration() {
        return this.proxied.getConfiguration();
    }

    public Record invokeAfterReadEvents(Record record) {
        return record;
    }

    public TransactionContext getTransactionIfExists() {
        return this.proxied.getTransactionIfExists();
    }

    public boolean isTransactionActive() {
        return this.proxied.isTransactionActive();
    }

    public int getNestedTransactions() {
        return this.proxied.getNestedTransactions();
    }

    public boolean checkTransactionIsActive(boolean createTx) {
        return this.proxied.checkTransactionIsActive(createTx);
    }

    public boolean isAsyncProcessing() {
        return this.proxied.isAsyncProcessing();
    }

    public void transaction(BasicDatabase.TransactionScope txBlock) {
        this.proxied.transaction(txBlock);
    }

    public boolean isAutoTransaction() {
        return this.proxied.isAutoTransaction();
    }

    public void setAutoTransaction(boolean autoTransaction) {
        this.proxied.setAutoTransaction(autoTransaction);
    }

    public void begin() {
        this.proxied.begin();
    }

    public void begin(Database.TRANSACTION_ISOLATION_LEVEL isolationLevel) {
        this.proxied.begin(isolationLevel);
    }

    public void rollback() {
        this.proxied.rollback();
    }

    public void rollbackAllNested() {
        this.proxied.rollbackAllNested();
    }

    public void scanType(String typeName, boolean polymorphic, DocumentCallback callback) {
        this.proxied.scanType(typeName, polymorphic, callback);
    }

    public void scanType(String typeName, boolean polymorphic, DocumentCallback callback, ErrorRecordCallback errorRecordCallback) {
        this.proxied.scanType(typeName, polymorphic, callback, errorRecordCallback);
    }

    public void scanBucket(String bucketName, RecordCallback callback) {
        this.proxied.scanBucket(bucketName, callback);
    }

    public void scanBucket(String bucketName, RecordCallback callback, ErrorRecordCallback errorRecordCallback) {
        this.proxied.scanBucket(bucketName, callback, errorRecordCallback);
    }

    public boolean existsRecord(RID rid) {
        return this.proxied.existsRecord(rid);
    }

    public Record lookupByRID(RID rid, boolean loadContent) {
        return this.proxied.lookupByRID(rid, loadContent);
    }

    public Iterator<Record> iterateType(String typeName, boolean polymorphic) {
        return this.proxied.iterateType(typeName, polymorphic);
    }

    public Iterator<Record> iterateBucket(String bucketName) {
        return this.proxied.iterateBucket(bucketName);
    }

    public IndexCursor lookupByKey(String type, String keyName, Object keyValue) {
        return this.proxied.lookupByKey(type, keyName, keyValue);
    }

    public IndexCursor lookupByKey(String type, String[] keyNames, Object[] keyValues) {
        return this.proxied.lookupByKey(type, keyNames, keyValues);
    }

    public void deleteRecord(Record record) {
        this.proxied.deleteRecord(record);
    }

    public long countType(String typeName, boolean polymorphic) {
        return this.proxied.countType(typeName, polymorphic);
    }

    public long countBucket(String bucketName) {
        return this.proxied.countBucket(bucketName);
    }

    public MutableDocument newDocument(String typeName) {
        return this.proxied.newDocument(typeName);
    }

    public MutableEmbeddedDocument newEmbeddedDocument(EmbeddedModifier modifier, String typeName) {
        return this.proxied.newEmbeddedDocument(modifier, typeName);
    }

    public MutableVertex newVertex(String typeName) {
        return this.proxied.newVertex(typeName);
    }

    public Edge newEdgeByKeys(Vertex sourceVertex, String destinationVertexType, String[] destinationVertexKeyNames, Object[] destinationVertexKeyValues, boolean createVertexIfNotExist, String edgeType, boolean bidirectional, Object ... properties) {
        return this.proxied.newEdgeByKeys(sourceVertex, destinationVertexType, destinationVertexKeyNames, destinationVertexKeyValues, createVertexIfNotExist, edgeType, bidirectional, properties);
    }

    public QueryEngine getQueryEngine(String language) {
        return this.proxied.getQueryEngine(language);
    }

    public Edge newEdgeByKeys(String sourceVertexType, String[] sourceVertexKeyNames, Object[] sourceVertexKeyValues, String destinationVertexType, String[] destinationVertexKeyNames, Object[] destinationVertexKeyValues, boolean createVertexIfNotExist, String edgeType, boolean bidirectional, Object ... properties) {
        return this.proxied.newEdgeByKeys(sourceVertexType, sourceVertexKeyNames, sourceVertexKeyValues, destinationVertexType, destinationVertexKeyNames, destinationVertexKeyValues, createVertexIfNotExist, edgeType, bidirectional, properties);
    }

    public Schema getSchema() {
        return this.proxied.getSchema();
    }

    public RecordEvents getEvents() {
        return this.proxied.getEvents();
    }

    public FileManager getFileManager() {
        return this.proxied.getFileManager();
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinActiveTx) {
        return this.proxied.transaction(txBlock, joinActiveTx);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTx, int retries) {
        return this.proxied.transaction(txBlock, joinCurrentTx, retries);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTx, int retries, OkCallback ok, ErrorCallback error) {
        return this.proxied.transaction(txBlock, joinCurrentTx, retries, ok, error);
    }

    public RecordFactory getRecordFactory() {
        return this.proxied.getRecordFactory();
    }

    public BinarySerializer getSerializer() {
        return this.proxied.getSerializer();
    }

    public PageManager getPageManager() {
        return this.proxied.getPageManager();
    }

    public int hashCode() {
        return this.proxied.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)o;
        return Objects.equals(this.getDatabasePath(), other.getDatabasePath());
    }

    public ResultSet command(String language, String query, ContextConfiguration configuration, Object ... args) {
        if (!this.isLeader()) {
            QueryEngine queryEngine = this.proxied.getQueryEngineManager().getInstance(language, (DatabaseInternal)this);
            if (queryEngine.isExecutedByTheLeader() || queryEngine.analyze(query).isDDL()) {
                CommandForwardRequest command = new CommandForwardRequest(this, language, query, null, args);
                return (ResultSet)this.server.getHA().forwardCommandToLeader(command, this.timeout * 2L);
            }
            return this.proxied.command(language, query, configuration, args);
        }
        return this.proxied.command(language, query, configuration, args);
    }

    public ResultSet command(String language, String query, Object ... args) {
        return this.command(language, query, this.server.getConfiguration(), args);
    }

    public ResultSet command(String language, String query, Map<String, Object> args) {
        return this.command(language, query, this.server.getConfiguration(), args);
    }

    public ResultSet command(String language, String query, ContextConfiguration configuration, Map<String, Object> args) {
        QueryEngine queryEngine;
        if (!this.isLeader() && ((queryEngine = this.proxied.getQueryEngineManager().getInstance(language, (DatabaseInternal)this)).isExecutedByTheLeader() || queryEngine.analyze(query).isDDL())) {
            CommandForwardRequest command = new CommandForwardRequest(this, language, query, args, null);
            return (ResultSet)this.server.getHA().forwardCommandToLeader(command, this.timeout * 2L);
        }
        return this.proxied.command(language, query, configuration, args);
    }

    public ResultSet query(String language, String query, Object ... args) {
        return this.proxied.query(language, query, args);
    }

    public ResultSet query(String language, String query, Map<String, Object> args) {
        return this.proxied.query(language, query, args);
    }

    @Deprecated
    public ResultSet execute(String language, String script, Object ... args) {
        return this.proxied.execute(language, script, args);
    }

    @Deprecated
    public ResultSet execute(String language, String script, Map<String, Object> args) {
        return this.proxied.execute(language, script, new Object[]{this.server.getConfiguration(), args});
    }

    public <RET> RET executeInReadLock(Callable<RET> callable) {
        return (RET)this.proxied.executeInReadLock(callable);
    }

    public <RET> RET executeInWriteLock(Callable<RET> callable) {
        return (RET)this.proxied.executeInWriteLock(callable);
    }

    public <RET> RET executeLockingFiles(Collection<Integer> fileIds, Callable<RET> callable) {
        return (RET)this.proxied.executeLockingFiles(fileIds, callable);
    }

    public boolean isReadYourWrites() {
        return this.proxied.isReadYourWrites();
    }

    public Database setReadYourWrites(boolean value) {
        this.proxied.setReadYourWrites(value);
        return this;
    }

    public Database setTransactionIsolationLevel(Database.TRANSACTION_ISOLATION_LEVEL level) {
        return this.proxied.setTransactionIsolationLevel(level);
    }

    public Database.TRANSACTION_ISOLATION_LEVEL getTransactionIsolationLevel() {
        return this.proxied.getTransactionIsolationLevel();
    }

    public int getEdgeListSize() {
        return this.proxied.getEdgeListSize();
    }

    public Database setEdgeListSize(int size) {
        this.proxied.setEdgeListSize(size);
        return this;
    }

    public Database setUseWAL(boolean useWAL) {
        return this.proxied.setUseWAL(useWAL);
    }

    public Database setWALFlush(WALFile.FLUSH_TYPE flush) {
        return this.proxied.setWALFlush(flush);
    }

    public boolean isAsyncFlush() {
        return this.proxied.isAsyncFlush();
    }

    public Database setAsyncFlush(boolean value) {
        return this.proxied.setAsyncFlush(value);
    }

    public boolean isOpen() {
        return this.proxied.isOpen();
    }

    public String toString() {
        return this.proxied.toString() + "[" + this.server.getServerName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET recordFileChanges(Callable<Object> callback) {
        HAServer ha = this.server.getHA();
        AtomicReference result = new AtomicReference();
        AtomicReference command = new AtomicReference();
        try {
            this.proxied.executeInWriteLock(() -> {
                if (!ha.isLeader()) {
                    throw new ServerIsNotTheLeaderException("Changes to the schema must be executed on the leader server", ha.getLeaderName());
                }
                if (!this.proxied.getFileManager().startRecordingChanges()) {
                    result.set(callback.call());
                    return null;
                }
                long schemaVersionBefore = this.proxied.getSchema().getEmbedded().getVersion();
                try {
                    result.set(callback.call());
                    Object var7_6 = null;
                    return var7_6;
                }
                finally {
                    command.set(this.getChangeStructure(schemaVersionBefore));
                    this.proxied.getFileManager().stopRecordingChanges();
                }
            });
        }
        finally {
            if (command.get() != null) {
                int quorum = ha.getConfiguredServers();
                ha.sendCommandToReplicasWithQuorum((HACommand)command.get(), quorum, this.timeout);
            }
        }
        return (RET)result.get();
    }

    public void saveConfiguration() throws IOException {
        this.proxied.saveConfiguration();
    }

    public long getLastUpdatedOn() {
        return this.proxied.getLastUpdatedOn();
    }

    public long getLastUsedOn() {
        return this.proxied.getLastUsedOn();
    }

    public long getOpenedOn() {
        return this.proxied.getOpenedOn();
    }

    public HAServer.QUORUM getQuorum() {
        return this.quorum;
    }

    public Map<String, Object> alignToReplicas() {
        HAServer ha = this.server.getHA();
        if (!ha.isLeader()) {
            throw new ServerIsNotTheLeaderException("Align database can be executed only on the leader server", ha.getLeaderName());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        int quorum = ha.getConfiguredServers();
        if (quorum == 1) {
            return result;
        }
        HashMap fileChecksums = new HashMap();
        HashMap fileSizes = new HashMap();
        this.executeInReadLock(() -> {
            this.proxied.getPageManager().suspendFlushAndExecute((Database)this, () -> {
                List files = this.proxied.getFileManager().getFiles();
                for (ComponentFile file : files) {
                    if (file == null) continue;
                    long fileChecksum = file.calculateChecksum();
                    fileChecksums.put(file.getFileId(), fileChecksum);
                    fileSizes.put(file.getFileId(), file.getSize());
                }
                DatabaseAlignRequest request = new DatabaseAlignRequest(this.getName(), this.getSchema().getEmbedded().toJSON().toString(), fileChecksums, fileSizes);
                List<Object> responsePayloads = ha.sendCommandToReplicasWithQuorum(request, quorum, 120000L);
                if (responsePayloads != null) {
                    for (Object o : responsePayloads) {
                        DatabaseAlignResponse response = (DatabaseAlignResponse)o;
                        result.put(response.getRemoteServerName(), response.getAlignedPages());
                    }
                }
            });
            return null;
        });
        return result;
    }

    public void createInReplicas() {
        HAServer ha = this.server.getHA();
        if (!ha.isLeader()) {
            throw new ServerIsNotTheLeaderException("Creation of database can be executed only on the leader server", ha.getLeaderName());
        }
        int quorum = ha.getConfiguredServers();
        if (quorum == 1) {
            return;
        }
        InstallDatabaseRequest request = new InstallDatabaseRequest(this.getName());
        ha.sendCommandToReplicasWithQuorum(request, quorum, 30000L);
    }

    private DatabaseChangeStructureRequest getChangeStructure(long schemaVersionBefore) {
        String serializedSchema;
        boolean schemaChanged;
        List fileChanges = this.proxied.getFileManager().getRecordedChanges();
        boolean bl = schemaChanged = this.proxied.getSchema().getEmbedded().isDirty() || schemaVersionBefore < 0L || this.proxied.getSchema().getEmbedded().getVersion() != schemaVersionBefore;
        if (fileChanges == null || fileChanges.isEmpty() && !schemaChanged) {
            return null;
        }
        HashMap<Integer, String> addFiles = new HashMap<Integer, String>();
        HashMap<Integer, String> removeFiles = new HashMap<Integer, String>();
        for (FileManager.FileChange c : fileChanges) {
            if (c.create) {
                addFiles.put(c.fileId, c.fileName);
                continue;
            }
            removeFiles.put(c.fileId, c.fileName);
        }
        if (schemaChanged) {
            JSONObject schemaJson = this.proxied.getSchema().getEmbedded().toJSON();
            schemaJson.put("schemaVersion", (Number)(schemaJson.getLong("schemaVersion") + 1L));
            serializedSchema = schemaJson.toString();
        } else {
            serializedSchema = "";
        }
        return new DatabaseChangeStructureRequest(this.proxied.getName(), serializedSchema, addFiles, removeFiles);
    }

    private boolean isLeader() {
        return this.server.getHA() != null && this.server.getHA().isLeader();
    }
}

