/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ws;

import com.arcadedb.database.Record;
import com.arcadedb.serializer.json.JSONObject;
import java.util.Locale;

public class ChangeEvent {
    private final TYPE type;
    private final Record record;

    public ChangeEvent(TYPE type, Record record) {
        this.type = type;
        this.record = record;
    }

    public Record getRecord() {
        return this.record;
    }

    public TYPE getType() {
        return this.type;
    }

    public String toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("changeType", this.type.toString().toLowerCase(Locale.ENGLISH));
        jsonObject.put("record", (Object)this.record.toJSON());
        jsonObject.put("database", this.record.getDatabase().getName());
        return jsonObject.toString();
    }

    public String toString() {
        return this.toJSON();
    }

    public static enum TYPE {
        CREATE,
        UPDATE,
        DELETE;

    }
}

