/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.schema.Type;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.CommandForwardResponse;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommandForwardRequest
extends HAAbstractCommand {
    private DatabaseInternal database;
    private String databaseName;
    private String language;
    private String command;
    private LinkedHashMap<String, Object> namedParameters;
    private Object[] ordinalParameters;

    public CommandForwardRequest() {
    }

    public CommandForwardRequest(DatabaseInternal database, String language, String command, Map<String, Object> namedParameters, Object[] ordinalParameters) {
        this.database = database;
        this.databaseName = database.getName();
        this.language = language;
        this.command = command;
        if (namedParameters != null) {
            this.namedParameters = new LinkedHashMap();
            this.namedParameters.putAll(namedParameters);
        }
        this.ordinalParameters = ordinalParameters;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
        stream.putString(this.language);
        stream.putString(this.command);
        if (this.namedParameters == null) {
            stream.putInt(0);
        } else {
            stream.putInt(this.namedParameters.size());
            for (Map.Entry entry : this.namedParameters.entrySet()) {
                stream.putString((String)entry.getKey());
                byte type = Type.getTypeByValue(entry.getValue()).getBinaryType();
                stream.putByte(type);
                this.database.getSerializer().serializeValue((Database)this.database, stream, type, entry.getValue());
            }
        }
        if (this.ordinalParameters == null) {
            stream.putInt(0);
        } else {
            stream.putInt(this.ordinalParameters.length);
            for (Object entry : this.ordinalParameters) {
                byte type = Type.getTypeByValue((Object)entry).getBinaryType();
                stream.putByte(type);
                this.database.getSerializer().serializeValue((Database)this.database, stream, type, entry);
            }
        }
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        int ordinalParametersSize;
        byte type;
        this.databaseName = stream.getString();
        this.language = stream.getString();
        this.command = stream.getString();
        this.database = server.getDatabase(this.databaseName);
        int namedParametersSize = stream.getInt();
        if (namedParametersSize > 0) {
            this.namedParameters = new LinkedHashMap();
            for (int i = 0; i < namedParametersSize; ++i) {
                String key = stream.getString();
                type = stream.getByte();
                Object value = this.database.getSerializer().deserializeValue((Database)this.database, stream, type, null);
                this.namedParameters.put(key, value);
            }
        }
        if ((ordinalParametersSize = stream.getInt()) > 0) {
            this.ordinalParameters = new Object[ordinalParametersSize];
            for (int i = 0; i < ordinalParametersSize; ++i) {
                type = stream.getByte();
                this.ordinalParameters[i] = this.database.getSerializer().deserializeValue((Database)this.database, stream, type, null);
            }
        }
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase db = server.getServer().getDatabase(this.databaseName);
        if (!db.isOpen()) {
            throw new ReplicationException("Database '" + this.databaseName + "' is closed");
        }
        ResultSet result = this.namedParameters != null ? db.command(this.language, this.command, server.getServer().getConfiguration(), this.namedParameters) : db.command(this.language, this.command, server.getServer().getConfiguration(), this.ordinalParameters);
        return new CommandForwardResponse(this.database, result);
    }

    public String toString() {
        return "command-forward-request(" + this.databaseName + "," + this.language + "," + this.command + ")";
    }
}

