/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.event;

import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerException;
import com.arcadedb.server.event.ServerEventLog;
import com.arcadedb.server.security.ServerSecurityException;
import com.arcadedb.utility.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class FileServerEventLog
implements ServerEventLog {
    private static final String FILE_PREFIX = "server-event-log-";
    private static final String FILE_EXT = ".jsonl";
    private static final int KEEP_FILES = 10;
    private final ArcadeDBServer server;
    private final SimpleDateFormat dateFormat;
    private File newFileName;
    private List<String> existentFiles;
    private File logDirectory;

    public FileServerEventLog(ArcadeDBServer server) {
        this.server = server;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public void start() {
        int maxCounter = -1;
        this.logDirectory = new File(this.server.getRootPath() + File.separator + "log");
        if (!this.logDirectory.exists()) {
            if (!this.logDirectory.mkdirs()) {
                LogManager.instance().log((Object)this, Level.INFO, "Error on creating log directory tree " + String.valueOf(this.logDirectory));
            }
        } else {
            this.existentFiles = new ArrayList<String>();
            File[] files = this.logDirectory.listFiles(f -> f.getName().startsWith(FILE_PREFIX) && f.getName().endsWith(FILE_EXT));
            if (files != null) {
                for (File f2 : files) {
                    String fileName = f2.getName();
                    try {
                        int pos = fileName.indexOf(".");
                        if (pos < 0) continue;
                        int fileIdx = Integer.parseInt(fileName.substring(pos + 1, fileName.length() - FILE_EXT.length()));
                        if (fileIdx > maxCounter) {
                            maxCounter = fileIdx;
                        }
                        this.existentFiles.add(fileName);
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.INFO, "Error on loading server even log file " + fileName, (Throwable)e);
                    }
                }
            }
            this.existentFiles.sort(Comparator.reverseOrder());
            if (this.existentFiles.size() > 10) {
                while (this.existentFiles.size() > 10) {
                    String removed = this.existentFiles.remove(this.existentFiles.size() - 1);
                    FileUtils.deleteFile((File)new File(this.logDirectory, removed));
                    LogManager.instance().log((Object)this, Level.FINE, "Deleted server event log file %s (keep max %d files)", (Object)removed, (Object)10);
                }
            }
        }
        this.newFileName = new File(this.logDirectory, FILE_PREFIX + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + ++maxCounter + FILE_EXT);
        try {
            if (!this.newFileName.createNewFile()) {
                throw new ServerException("Error on creating new server event log file " + String.valueOf(this.newFileName));
            }
        }
        catch (IOException e) {
            throw new ServerException("Error on creating new server event log file " + String.valueOf(this.newFileName), e);
        }
    }

    @Override
    public void reportEvent(ServerEventLog.EVENT_TYPE eventType, String component, String databaseName, String message) {
        if (this.newFileName == null) {
            return;
        }
        try {
            JSONObject json = new JSONObject();
            json.put("time", this.dateFormat.format(new Date()));
            json.put("type", (Object)eventType);
            json.put("component", component);
            json.put("db", databaseName);
            json.put("message", message);
            FileUtils.appendContentToFile((File)this.newFileName, (String)(String.valueOf(json) + "\n"));
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on writing into server event log file %s", (Throwable)e, (Object)this.newFileName);
        }
    }

    @Override
    public JSONArray getCurrentEvents() {
        try {
            JSONArray result = new JSONArray();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.newFileName));){
                String line = reader.readLine();
                while (line != null) {
                    result.put(new JSONObject(line));
                    line = reader.readLine();
                }
            }
            return result;
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on reading from server event log file %s", (Throwable)e, (Object)this.newFileName);
            return null;
        }
    }

    @Override
    public JSONArray getEvents(String fileName) {
        if (fileName.contains("..") || fileName.contains("/")) {
            throw new ServerSecurityException("Invalid file name " + fileName);
        }
        File file = new File(this.logDirectory, fileName);
        if (!file.exists()) {
            return new JSONArray();
        }
        try {
            JSONArray result = new JSONArray();
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                while (line != null) {
                    result.put(new JSONObject(line));
                    line = reader.readLine();
                }
            }
            return result;
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on reading from server event log file %s", (Throwable)e, (Object)file);
            return null;
        }
    }

    @Override
    public JSONArray getFiles() {
        return new JSONArray(this.existentFiles);
    }
}

