/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http;

import com.arcadedb.database.TransactionContext;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.http.HttpSession;
import com.arcadedb.server.security.ServerSecurityUser;
import com.arcadedb.utility.RWLockContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;

public class HttpSessionManager
extends RWLockContext {
    public static final String ARCADEDB_SESSION_ID = "arcadedb-session-id";
    private final Map<String, HttpSession> sessions = new HashMap<String, HttpSession>();
    private final long expirationTimeInMs;
    private final Timer timer;

    public HttpSessionManager(long expirationTimeInMs) {
        this.expirationTimeInMs = expirationTimeInMs;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                int expired = HttpSessionManager.this.checkSessionsValidity();
                if (expired > 0) {
                    LogManager.instance().log((Object)this, Level.FINE, "Removed %d expired sessions", null, (Object)expired);
                }
            }
        }, expirationTimeInMs, expirationTimeInMs);
    }

    public void close() {
        this.timer.cancel();
        this.sessions.clear();
    }

    public int checkSessionsValidity() {
        if (this.sessions.isEmpty()) {
            return 0;
        }
        return (Integer)this.executeInWriteLock(() -> {
            int expired = 0;
            Iterator<Map.Entry<String, HttpSession>> it = this.sessions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, HttpSession> s = it.next();
                if (s.getValue().elapsedFromLastUpdate() <= this.expirationTimeInMs) continue;
                it.remove();
                ++expired;
            }
            return expired;
        });
    }

    public HttpSession getSessionById(ServerSecurityUser user, String txId) {
        return (HttpSession)this.executeInReadLock(() -> this.sessions.get(txId));
    }

    public HttpSession createSession(ServerSecurityUser user, TransactionContext dbTx) {
        return (HttpSession)this.executeInWriteLock(() -> {
            String id = "AS-" + UUID.randomUUID();
            HttpSession session = new HttpSession(user, id, dbTx);
            this.sessions.put(id, session);
            return session;
        });
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }
}

