/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server;

import com.arcadedb.Constants;
import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.LocalDatabase;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.exception.ConfigurationException;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.integration.misc.IntegrationUtils;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.ChannelBinary;
import com.arcadedb.query.QueryEngineManager;
import com.arcadedb.security.SecurityManager;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ReplicationCallback;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ServerException;
import com.arcadedb.server.ServerLogManager;
import com.arcadedb.server.ServerPlugin;
import com.arcadedb.server.event.FileServerEventLog;
import com.arcadedb.server.event.ServerEventLog;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicatedDatabase;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.security.ServerSecurity;
import com.arcadedb.server.security.ServerSecurityException;
import com.arcadedb.server.security.ServerSecurityUser;
import com.arcadedb.utility.CodeUtils;
import com.arcadedb.utility.FileUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.logging.LoggingMeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class ArcadeDBServer {
    public static final String CONFIG_SERVER_CONFIGURATION_FILENAME = "config/server-configuration.json";
    private final ContextConfiguration configuration;
    private final String serverName;
    private String hostAddress;
    private final boolean replicationLifecycleEventsEnabled;
    private FileServerEventLog eventLog;
    private final Map<String, ServerPlugin> plugins = new LinkedHashMap<String, ServerPlugin>();
    private String serverRootPath;
    private HAServer haServer;
    private ServerSecurity security;
    private HttpServer httpServer;
    private final ConcurrentMap<String, ServerDatabase> databases = new ConcurrentHashMap<String, ServerDatabase>();
    private final List<ReplicationCallback> testEventListeners = new ArrayList<ReplicationCallback>();
    private volatile STATUS status = STATUS.OFFLINE;

    public ArcadeDBServer() {
        this.configuration = new ContextConfiguration();
        this.serverRootPath = IntegrationUtils.setRootPath((ContextConfiguration)this.configuration);
        this.loadConfiguration();
        this.serverName = this.configuration.getValueAsString(GlobalConfiguration.SERVER_NAME);
        this.replicationLifecycleEventsEnabled = this.configuration.getValueAsBoolean(GlobalConfiguration.TEST);
        this.init();
    }

    public ArcadeDBServer(ContextConfiguration configuration) {
        this.configuration = configuration;
        this.serverRootPath = IntegrationUtils.setRootPath((ContextConfiguration)configuration);
        this.serverName = configuration.getValueAsString(GlobalConfiguration.SERVER_NAME);
        this.replicationLifecycleEventsEnabled = configuration.getValueAsBoolean(GlobalConfiguration.TEST);
        this.init();
    }

    public static void main(String[] args) {
        new ArcadeDBServer().start();
    }

    public ContextConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized void start() {
        InputStream file;
        LogManager.instance().setContext(this.getServerName());
        this.welcomeBanner();
        if (this.status != STATUS.OFFLINE) {
            return;
        }
        this.status = STATUS.STARTING;
        this.eventLog.start();
        try {
            this.lifecycleEvent(ReplicationCallback.TYPE.SERVER_STARTING, null);
        }
        catch (Exception e) {
            throw new ServerException("Error on starting the server '" + this.serverName + "'");
        }
        LogManager.instance().log((Object)this, Level.INFO, "Starting ArcadeDB Server in %s mode with plugins %s ...", (Object)GlobalConfiguration.SERVER_MODE.getValueAsString(), this.getPluginNames());
        if (this.configuration.getValueAsBoolean(GlobalConfiguration.SERVER_METRICS)) {
            Metrics.addRegistry((MeterRegistry)new SimpleMeterRegistry());
            new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmGcMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            if (this.configuration.getValueAsBoolean(GlobalConfiguration.SERVER_METRICS_LOGGING)) {
                LogManager.instance().log((Object)this, Level.INFO, "- Logging metrics enabled...");
                Metrics.addRegistry((MeterRegistry)new LoggingMeterRegistry());
            }
            LogManager.instance().log((Object)this, Level.INFO, "- Metrics Collection Started...");
        }
        this.security = new ServerSecurity(this, this.configuration, this.serverRootPath + "/config");
        this.security.startService();
        this.loadDatabases();
        this.security.loadUsers();
        this.httpServer = new HttpServer(this);
        this.registerPlugins(ServerPlugin.INSTALLATION_PRIORITY.BEFORE_HTTP_ON);
        this.httpServer.startService();
        if (this.configuration.getValueAsBoolean(GlobalConfiguration.HA_ENABLED)) {
            this.haServer = new HAServer(this, this.configuration);
            this.haServer.startService();
        }
        this.registerPlugins(ServerPlugin.INSTALLATION_PRIORITY.AFTER_HTTP_ON);
        this.loadDefaultDatabases();
        this.loadDatabases();
        this.registerPlugins(ServerPlugin.INSTALLATION_PRIORITY.AFTER_DATABASES_OPEN);
        this.status = STATUS.ONLINE;
        LogManager.instance().log((Object)this, Level.INFO, "Available query languages: %s", (Object)new QueryEngineManager().getAvailableLanguages());
        String mode = GlobalConfiguration.SERVER_MODE.getValueAsString();
        String msg = "ArcadeDB Server started in '%s' mode (CPUs=%d MAXRAM=%s)".formatted(mode, Runtime.getRuntime().availableProcessors(), FileUtils.getSizeAsString((long)Runtime.getRuntime().maxMemory()));
        LogManager.instance().log((Object)this, Level.INFO, msg);
        this.getEventLog().reportEvent(ServerEventLog.EVENT_TYPE.INFO, "Server", null, msg);
        if (!"production".equals(mode) && (file = this.getClass().getClassLoader().getResourceAsStream("static/index.html")) != null) {
            LogManager.instance().log((Object)this, Level.INFO, "Studio web tool available at http://%s:%d ", (Object)this.hostAddress, (Object)this.httpServer.getPort());
        }
        try {
            this.lifecycleEvent(ReplicationCallback.TYPE.SERVER_UP, null);
        }
        catch (Exception e) {
            this.stop();
            throw new ServerException("Error on starting the server '" + this.serverName + "'");
        }
    }

    private void welcomeBanner() {
        LogManager.instance().log((Object)this, Level.INFO, "ArcadeDB Server v" + Constants.getVersion() + " is starting up...");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String vmName = System.getProperty("java.vm.name");
        String vmVendorVersion = System.getProperty("java.vendor.version");
        String vmVersion = System.getProperty("java.version");
        LogManager.instance().log((Object)this, Level.INFO, "Running on " + osName + " " + osVersion + " - " + (vmName != null ? vmName : "Java") + " " + vmVersion + " " + (String)(vmVendorVersion != null ? "(" + vmVendorVersion + ")" : ""));
    }

    private Set<String> getPluginNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String registeredPlugins = this.configuration.getValueAsString(GlobalConfiguration.SERVER_PLUGINS);
        if (registeredPlugins != null && !registeredPlugins.isEmpty()) {
            String[] pluginEntries;
            for (String p : pluginEntries = registeredPlugins.split(",")) {
                String[] pluginPair = p.split(":");
                String pluginName = pluginPair[0];
                result.add(pluginName);
            }
        }
        return result;
    }

    private void registerPlugins(ServerPlugin.INSTALLATION_PRIORITY installationPriority) {
        String registeredPlugins = this.configuration.getValueAsString(GlobalConfiguration.SERVER_PLUGINS);
        if (registeredPlugins != null && !registeredPlugins.isEmpty()) {
            String[] pluginEntries;
            for (String p : pluginEntries = registeredPlugins.split(",")) {
                try {
                    String[] pluginPair = p.split(":");
                    String pluginName = pluginPair[0];
                    String pluginClass = pluginPair.length > 1 ? pluginPair[1] : pluginPair[0];
                    Class<?> c = Class.forName(pluginClass);
                    ServerPlugin pluginInstance = (ServerPlugin)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (pluginInstance.getInstallationPriority() != installationPriority) continue;
                    pluginInstance.configure(this, this.configuration);
                    pluginInstance.startService();
                    this.plugins.put(pluginName, pluginInstance);
                    LogManager.instance().log((Object)this, Level.INFO, "- %s plugin started", (Object)pluginName);
                }
                catch (Exception e) {
                    throw new ServerException("Error on loading plugin from class '" + p + ";", e);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.status == STATUS.OFFLINE || this.status == STATUS.SHUTTING_DOWN) {
            return;
        }
        LogManager.instance().log((Object)this, Level.INFO, "Shutting down ArcadeDB Server...");
        try {
            this.lifecycleEvent(ReplicationCallback.TYPE.SERVER_SHUTTING_DOWN, null);
        }
        catch (Exception e) {
            throw new ServerException("Error on stopping the server '" + this.serverName + "'");
        }
        this.status = STATUS.SHUTTING_DOWN;
        for (Map.Entry<String, ServerPlugin> pEntry : this.plugins.entrySet()) {
            LogManager.instance().log((Object)this, Level.INFO, "- Stop %s plugin", (Object)pEntry.getKey());
            CodeUtils.executeIgnoringExceptions(() -> ((ServerPlugin)pEntry.getValue()).stopService(), (String)("Error on halting '" + pEntry.getKey() + "' plugin"), (boolean)false);
        }
        if (this.haServer != null) {
            CodeUtils.executeIgnoringExceptions(this.haServer::stopService, (String)"Error on stopping HA service", (boolean)false);
        }
        if (this.httpServer != null) {
            CodeUtils.executeIgnoringExceptions(this.httpServer::stopService, (String)"Error on stopping HTTP service", (boolean)false);
        }
        if (this.security != null) {
            CodeUtils.executeIgnoringExceptions(this.security::stopService, (String)"Error on stopping Security service", (boolean)false);
        }
        for (ServerDatabase db : this.databases.values()) {
            CodeUtils.executeIgnoringExceptions(() -> ((DatabaseInternal)db.getEmbedded()).close(), (String)("Error closing database '" + db.getName() + "'"), (boolean)false);
        }
        this.databases.clear();
        CodeUtils.executeIgnoringExceptions(() -> LogManager.instance().log((Object)this, Level.INFO, "- Stop JMX Metrics"), (String)"Error on stopping JMX Metrics", (boolean)false);
        LogManager.instance().log((Object)this, Level.INFO, "ArcadeDB Server is down");
        try {
            this.lifecycleEvent(ReplicationCallback.TYPE.SERVER_DOWN, null);
        }
        catch (Exception e) {
            throw new ServerException("Error on stopping the server '" + this.serverName + "'");
        }
        LogManager.instance().setContext(null);
        this.status = STATUS.OFFLINE;
        this.getEventLog().reportEvent(ServerEventLog.EVENT_TYPE.INFO, "Server", null, "Server shutdown correctly");
        ServerLogManager.resetFinally();
    }

    public Collection<ServerPlugin> getPlugins() {
        return Collections.unmodifiableCollection(this.plugins.values());
    }

    public ServerDatabase getDatabase(String databaseName) {
        return this.getDatabase(databaseName, false, true);
    }

    public ServerDatabase getOrCreateDatabase(String databaseName) {
        return this.getDatabase(databaseName, true, true);
    }

    public FileServerEventLog getEventLog() {
        return this.eventLog;
    }

    public boolean isStarted() {
        return this.status == STATUS.ONLINE;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public boolean existsDatabase(String databaseName) {
        return this.databases.containsKey(databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDatabase createDatabase(String databaseName, ComponentFile.MODE mode) {
        ConcurrentMap<String, ServerDatabase> concurrentMap = this.databases;
        synchronized (concurrentMap) {
            ServerDatabase serverDatabase = (ServerDatabase)this.databases.get(databaseName);
            if (serverDatabase != null) {
                throw new IllegalArgumentException("Database '" + databaseName + "' already exists");
            }
            DatabaseFactory factory = new DatabaseFactory(this.configuration.getValueAsString(GlobalConfiguration.SERVER_DATABASE_DIRECTORY) + File.separator + databaseName).setAutoTransaction(true);
            if (factory.exists()) {
                throw new IllegalArgumentException("Database '" + databaseName + "' already exists");
            }
            DatabaseInternal embeddedDatabase = (DatabaseInternal)factory.create();
            if (mode == ComponentFile.MODE.READ_ONLY) {
                embeddedDatabase.close();
                embeddedDatabase = (DatabaseInternal)factory.open(mode);
            }
            if (this.configuration.getValueAsBoolean(GlobalConfiguration.HA_ENABLED)) {
                embeddedDatabase = new ReplicatedDatabase(this, (LocalDatabase)embeddedDatabase);
            }
            serverDatabase = new ServerDatabase(embeddedDatabase);
            this.databases.put(databaseName, serverDatabase);
            return serverDatabase;
        }
    }

    public Set<String> getDatabaseNames() {
        return Collections.unmodifiableSet(this.databases.keySet());
    }

    public void removeDatabase(String databaseName) {
        this.databases.remove(databaseName);
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public HAServer getHA() {
        return this.haServer;
    }

    public ServerSecurity getSecurity() {
        return this.security;
    }

    public void registerTestEventListener(ReplicationCallback callback) {
        this.testEventListeners.add(callback);
    }

    public void lifecycleEvent(ReplicationCallback.TYPE type, Object object) throws Exception {
        if (this.replicationLifecycleEventsEnabled) {
            for (ReplicationCallback c : this.testEventListeners) {
                c.onEvent(type, object, this);
            }
        }
    }

    public String getRootPath() {
        return this.serverRootPath;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public String toString() {
        return this.getServerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDatabase getDatabase(String databaseName, boolean createIfNotExists, boolean allowLoad) {
        ServerDatabase db;
        if (databaseName == null || databaseName.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid database name " + databaseName);
        }
        ConcurrentMap<String, ServerDatabase> concurrentMap = this.databases;
        synchronized (concurrentMap) {
            db = (ServerDatabase)this.databases.get(databaseName);
            if (db == null || !db.isOpen()) {
                DatabaseInternal embDatabase;
                if (!allowLoad) {
                    throw new DatabaseOperationException("Database '" + databaseName + "' is not available");
                }
                String path = this.configuration.getValueAsString(GlobalConfiguration.SERVER_DATABASE_DIRECTORY) + File.separator + databaseName;
                DatabaseFactory factory = new DatabaseFactory(path).setAutoTransaction(true);
                factory.setSecurity((SecurityManager)this.getSecurity());
                ComponentFile.MODE defaultDbMode = (ComponentFile.MODE)this.configuration.getValueAsEnum(GlobalConfiguration.SERVER_DEFAULT_DATABASE_MODE, ComponentFile.MODE.class);
                if (defaultDbMode == null) {
                    defaultDbMode = ComponentFile.MODE.READ_WRITE;
                }
                if (createIfNotExists) {
                    embDatabase = (DatabaseInternal)(factory.exists() ? factory.open(defaultDbMode) : factory.create());
                } else {
                    Collection activeDatabases = DatabaseFactory.getActiveDatabaseInstances();
                    if (!activeDatabases.isEmpty()) {
                        embDatabase = null;
                        for (Database existentDatabase : activeDatabases) {
                            if (!existentDatabase.getDatabasePath().equals(path)) continue;
                            embDatabase = (DatabaseInternal)existentDatabase;
                            break;
                        }
                        if (embDatabase == null) {
                            embDatabase = (DatabaseInternal)factory.open(defaultDbMode);
                        }
                    } else {
                        embDatabase = (DatabaseInternal)factory.open(defaultDbMode);
                    }
                }
                if (this.configuration.getValueAsBoolean(GlobalConfiguration.HA_ENABLED)) {
                    embDatabase = new ReplicatedDatabase(this, (LocalDatabase)embDatabase);
                }
                db = new ServerDatabase(embDatabase);
                this.databases.put(databaseName, db);
            }
        }
        return db;
    }

    private void loadDatabases() {
        File databaseDir = new File(this.configuration.getValueAsString(GlobalConfiguration.SERVER_DATABASE_DIRECTORY));
        if (!databaseDir.exists()) {
            databaseDir.mkdirs();
        } else {
            if (!databaseDir.isDirectory()) {
                throw new ConfigurationException("Configured database directory '" + databaseDir + "' is not a directory on file system");
            }
            if (this.configuration.getValueAsBoolean(GlobalConfiguration.SERVER_DATABASE_LOADATSTARTUP)) {
                File[] databaseDirectories;
                for (File f : databaseDirectories = databaseDir.listFiles(File::isDirectory)) {
                    this.getDatabase(f.getName());
                }
            }
        }
    }

    private void loadDefaultDatabases() {
        String defaultDatabases = this.configuration.getValueAsString(GlobalConfiguration.SERVER_DEFAULT_DATABASES);
        if (defaultDatabases != null && !defaultDatabases.isEmpty()) {
            String[] dbs;
            ComponentFile.MODE defaultDbMode = (ComponentFile.MODE)this.configuration.getValueAsEnum(GlobalConfiguration.SERVER_DEFAULT_DATABASE_MODE, ComponentFile.MODE.class);
            if (defaultDbMode == null) {
                defaultDbMode = ComponentFile.MODE.READ_WRITE;
            }
            block11: for (String db : dbs = defaultDatabases.split(";")) {
                ServerDatabase database;
                int credentialBegin = db.indexOf(91);
                if (credentialBegin < 0) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Error in default databases format: '%s'", (Object)defaultDatabases);
                    break;
                }
                String dbName = db.substring(0, credentialBegin);
                int credentialEnd = db.indexOf(93, credentialBegin);
                String credentials = db.substring(credentialBegin + 1, credentialEnd);
                if (!credentials.isEmpty()) {
                    this.parseCredentials(dbName, credentials);
                }
                ServerDatabase serverDatabase = database = this.existsDatabase(dbName) ? this.getDatabase(dbName) : null;
                if (credentialEnd < db.length() - 1 && db.charAt(credentialEnd + 1) == '{') {
                    String[] commandParts;
                    String commands = db.substring(credentialEnd + 2, db.length() - 1);
                    block12: for (String command : commandParts = commands.split(",")) {
                        int commandSeparator = command.indexOf(":");
                        if (commandSeparator < 0) {
                            LogManager.instance().log((Object)this, Level.WARNING, "Error in startup command configuration format: '%s'", (Object)commands);
                            continue block11;
                        }
                        String commandType = command.substring(0, commandSeparator).toLowerCase(Locale.ENGLISH);
                        String commandParams = command.substring(commandSeparator + 1);
                        switch (commandType) {
                            case "restore": {
                                if (database != null) {
                                    ((DatabaseInternal)database).getEmbedded().drop();
                                    this.databases.remove(dbName);
                                }
                                String dbPath = this.configuration.getValueAsString(GlobalConfiguration.SERVER_DATABASE_DIRECTORY) + File.separator + dbName;
                                try {
                                    Class<?> clazz = Class.forName("com.arcadedb.integration.restore.Restore");
                                    Object restorer = clazz.getConstructor(String.class, String.class).newInstance(commandParams, dbPath);
                                    clazz.getMethod("restoreDatabase", new Class[0]).invoke(restorer, new Object[0]);
                                }
                                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                                    throw new CommandExecutionException("Error on restoring database, restore libs not found in classpath", (Throwable)e);
                                }
                                catch (InvocationTargetException e) {
                                    throw new CommandExecutionException("Error on restoring database", e.getTargetException());
                                }
                                this.getDatabase(dbName);
                                continue block12;
                            }
                            case "import": {
                                if (database == null) {
                                    LogManager.instance().log((Object)this, Level.INFO, "Creating default database '%s'...", null, (Object)dbName);
                                    database = this.createDatabase(dbName, defaultDbMode);
                                }
                                database.command("sql", "import database " + commandParams, new Object[0]);
                                continue block12;
                            }
                            default: {
                                LogManager.instance().log((Object)this, Level.SEVERE, "Unsupported command %s in startup command: '%s'", null, (Object)commandType);
                            }
                        }
                    }
                    continue;
                }
                if (database != null) continue;
                LogManager.instance().log((Object)this, Level.INFO, "Creating default database '%s'...", null, (Object)dbName);
                this.createDatabase(dbName, defaultDbMode);
            }
        }
    }

    private void parseCredentials(String dbName, String credentials) {
        String[] credentialPairs;
        for (String credential : credentialPairs = credentials.split(",")) {
            ServerSecurityUser user;
            String userGroup;
            String[] credentialParts = credential.split(":");
            if (credentialParts.length < 2) {
                if (this.security.existsUser(credential)) continue;
                LogManager.instance().log((Object)this, Level.WARNING, "Cannot create user '%s' to access database '%s' because the user does not exist", null, (Object)credential, (Object)dbName);
                continue;
            }
            String userName = credentialParts[0];
            String userPassword = credentialParts[1];
            String string = userGroup = credentialParts.length > 2 ? credentialParts[2] : null;
            if (this.security.existsUser(userName)) {
                user = this.security.getUser(userName);
                if (user.canAccessToDatabase(dbName)) {
                    try {
                        user = this.security.authenticate(userName, userPassword, dbName);
                        user.addDatabase(dbName, new String[]{userGroup});
                        this.security.saveUsers();
                    }
                    catch (ServerSecurityException e) {
                        LogManager.instance().log((Object)this, Level.WARNING, "Cannot create database '%s' because the user '%s' already exists with a different password", null, (Object)dbName, (Object)userName);
                    }
                    continue;
                }
                user.addDatabase(dbName, new String[]{userGroup});
                this.security.saveUsers();
                continue;
            }
            this.security.createUser(new JSONObject().put("name", userName).put("password", this.security.encodePassword(userPassword)).put("databases", (Object)new JSONObject().put(dbName, (Object)new JSONArray())));
            user = this.security.getUser(userName);
            user.addDatabase(dbName, new String[]{userGroup});
            this.security.saveUsers();
        }
    }

    private void loadConfiguration() {
        File file = new File(this.getRootPath() + File.separator + CONFIG_SERVER_CONFIGURATION_FILENAME);
        if (file.exists()) {
            try {
                String content = FileUtils.readFileAsString((File)file);
                this.configuration.reset();
                this.configuration.fromJSON(content);
            }
            catch (IOException e) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Error on loading configuration from file '%s'", (Throwable)e, (Object)file);
            }
        }
    }

    private void init() {
        this.eventLog = new FileServerEventLog(this);
        GlobalConfiguration.ASYNC_WORKER_THREADS.setValue((Object)1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogManager.instance().log((Object)this, Level.SEVERE, "Received shutdown signal. The server will be halted");
            this.stop();
        }));
        this.hostAddress = this.assignHostAddress();
    }

    private String assignHostAddress() {
        Object hostAddress;
        String hostNameEnvVariable = System.getenv("HOSTNAME");
        hostNameEnvVariable = hostNameEnvVariable != null && !hostNameEnvVariable.trim().isEmpty() ? hostNameEnvVariable.trim() : null;
        if (this.configuration.getValueAsBoolean(GlobalConfiguration.HA_K8S)) {
            if (hostNameEnvVariable == null) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Error: HOSTNAME environment variable not found but needed when running inside Kubernetes. The server will be halted");
                this.stop();
                System.exit(1);
                return null;
            }
            hostAddress = hostNameEnvVariable + this.configuration.getValueAsString(GlobalConfiguration.HA_K8S_DNS_SUFFIX);
            LogManager.instance().log((Object)this, Level.INFO, "Server is running inside Kubernetes. Hostname: %s", null, hostAddress);
        } else if (hostNameEnvVariable != null) {
            hostAddress = hostNameEnvVariable;
        } else {
            hostAddress = this.configuration.getValueAsString(GlobalConfiguration.SERVER_HTTP_INCOMING_HOST);
            if (((String)hostAddress).equals("0.0.0.0")) {
                try {
                    hostAddress = ChannelBinary.getLocalIpAddress((boolean)true);
                }
                catch (Exception e) {
                    hostAddress = "localhost";
                }
            }
        }
        return hostAddress;
    }

    static {
        System.setProperty("java.util.logging.manager", ServerLogManager.class.getName());
        LogManager.instance();
        ServerLogManager.enableReset(false);
    }

    public static enum STATUS {
        OFFLINE,
        STARTING,
        ONLINE,
        SHUTTING_DOWN;

    }
}

