/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.TransactionExplicitLock;
import com.arcadedb.remote.RemoteDatabase;
import java.util.HashSet;
import java.util.Set;

public class RemoteTransactionExplicitLock
implements TransactionExplicitLock {
    private final RemoteDatabase database;
    private final Set<String> lockedTypeNames = new HashSet<String>();
    private final Set<String> lockedBucketNames = new HashSet<String>();

    public RemoteTransactionExplicitLock(RemoteDatabase database) {
        this.database = database;
    }

    public RemoteTransactionExplicitLock bucket(String bucketName) {
        this.lockedBucketNames.add(bucketName);
        return this;
    }

    public RemoteTransactionExplicitLock type(String typeName) {
        this.lockedTypeNames.add(typeName);
        return this;
    }

    public void lock() {
        StringBuilder command = new StringBuilder();
        command.append("LOCK");
        if (!this.lockedTypeNames.isEmpty()) {
            command.append(" TYPE ");
            command.append(String.join((CharSequence)", ", this.lockedTypeNames));
        }
        if (!this.lockedBucketNames.isEmpty()) {
            command.append(" BUCKET ");
            command.append(String.join((CharSequence)", ", this.lockedBucketNames));
        }
        this.lockedBucketNames.clear();
        this.lockedTypeNames.clear();
        this.database.command("sql", command.toString(), new Object[0]);
    }
}

