/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.ImmutableDocument;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.log.LogManager;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteMutableDocument;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.Property;
import com.arcadedb.schema.Type;
import com.arcadedb.serializer.json.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RemoteImmutableDocument
extends ImmutableDocument {
    protected final RemoteDatabase remoteDatabase;
    protected final Map<String, Object> map;

    protected RemoteImmutableDocument(RemoteDatabase remoteDatabase, Map<String, Object> attributes) {
        super(null, remoteDatabase.getSchema().getType((String)attributes.get("@type")), null, null);
        this.remoteDatabase = remoteDatabase;
        this.map = new HashMap<String, Object>(attributes.size());
        Map<String, Type> propTypes = this.parsePropertyTypes((String)attributes.get("@props"));
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Class javaImplementation;
            String fieldName = entry.getKey();
            if (Property.METADATA_PROPERTIES.contains(fieldName)) continue;
            Object value = entry.getValue();
            Property property = this.type.getPolymorphicPropertyIfExists(fieldName);
            Type propType = property != null ? property.getType() : propTypes.get(fieldName);
            Class clazz = javaImplementation = value != null ? value.getClass() : null;
            if (propType == Type.DATE) {
                javaImplementation = remoteDatabase.getSerializer().getDateImplementation();
            } else if (propType == Type.DATETIME) {
                javaImplementation = remoteDatabase.getSerializer().getDateTimeImplementation();
            } else if (propType != null) {
                javaImplementation = propType.getDefaultJavaType();
            }
            value = Type.convert(null, (Object)value, (Class)javaImplementation, (Property)property);
            this.map.put(fieldName, value);
        }
        String ridAsString = (String)attributes.get("@rid");
        this.rid = ridAsString != null ? new RID((BasicDatabase)remoteDatabase, ridAsString) : null;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public synchronized Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public synchronized boolean has(String propertyName) {
        return this.map.containsKey(propertyName);
    }

    public synchronized Object get(String propertyName) {
        return this.map.get(propertyName);
    }

    public synchronized MutableDocument modify() {
        return new RemoteMutableDocument(this);
    }

    public synchronized Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "d");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public synchronized JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, this.type, includeMetadata, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "d");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public DocumentType getType() {
        return this.type;
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public void reload() {
        throw new UnsupportedOperationException("Unable to reload an immutable document");
    }

    protected boolean checkForLazyLoading() {
        return false;
    }

    private Map<String, Type> parsePropertyTypes(String propTypesAsString) {
        Map<String, Type> propTypes = null;
        if (propTypesAsString != null) {
            for (String entry : propTypesAsString.split(",")) {
                try {
                    String[] entryPair = entry.split(":");
                    if (entryPair.length == 2) {
                        Type propType = Type.getById((byte)((byte)Integer.parseInt(entryPair[1])));
                        propTypes.put(entryPair[0], propType);
                        continue;
                    }
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error parsing property types " + String.valueOf(entryPair));
                }
                catch (Exception e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error parsing property types", (Throwable)e);
                }
            }
        }
        return propTypes != null ? propTypes : Collections.emptyMap();
    }
}

