/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseStats;
import com.arcadedb.database.RID;
import com.arcadedb.exception.ConcurrentModificationException;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.exception.DuplicatedKeyException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.exception.SchemaException;
import com.arcadedb.exception.TimeoutException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.HostUtil;
import com.arcadedb.network.binary.QuorumNotReachedException;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.remote.RemoteException;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.utility.Pair;
import com.arcadedb.utility.RWLockContext;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class RemoteHttpComponent
extends RWLockContext {
    public static final int DEFAULT_PORT = 2480;
    private static final String charset = "UTF-8";
    protected String protocol = "http";
    private final String originalServer;
    private final int originalPort;
    private final String userName;
    private final String userPassword;
    private final List<Pair<String, Integer>> replicaServerList = new ArrayList<Pair<String, Integer>>();
    protected final HttpClient httpClient;
    protected final DatabaseStats stats = new DatabaseStats();
    protected final ContextConfiguration configuration;
    private int sameServerErrorRetries;
    private int haServerErrorRetries;
    private final Integer txRetries;
    private int apiVersion = 1;
    private CONNECTION_STRATEGY connectionStrategy = CONNECTION_STRATEGY.ROUND_ROBIN;
    private Pair<String, Integer> leaderServer;
    private int currentReplicaServerIndex = -1;
    private int timeout;
    protected String currentServer;
    protected int currentPort;

    public RemoteHttpComponent(String server, int port, String userName, String userPassword) {
        this(server, port, userName, userPassword, new ContextConfiguration());
    }

    public RemoteHttpComponent(String server, int port, final String userName, final String userPassword, ContextConfiguration configuration) {
        if (server.startsWith("https://")) {
            this.protocol = "https";
            server = server.substring("https://".length());
        } else if (server.startsWith("http://")) {
            this.protocol = "http";
            server = server.substring("http://".length());
        }
        this.originalServer = server;
        this.originalPort = port;
        this.currentServer = this.originalServer;
        this.currentPort = this.originalPort;
        this.userName = userName;
        this.userPassword = userPassword;
        this.configuration = configuration;
        this.timeout = this.configuration.getValueAsInteger(GlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
        this.setSameServerErrorRetries(this.configuration.getValueAsInteger(GlobalConfiguration.NETWORK_SAME_SERVER_ERROR_RETRIES));
        this.haServerErrorRetries = this.configuration.getValueAsInteger(GlobalConfiguration.HA_ERROR_RETRIES);
        this.txRetries = this.configuration.getValueAsInteger(GlobalConfiguration.TX_RETRIES);
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(60L)).version(HttpClient.Version.HTTP_2).authenticator(new Authenticator(this){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, userPassword.toCharArray());
            }
        }).build();
        this.requestClusterConfiguration();
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.shutdownNow();
            this.httpClient.close();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSameServerErrorRetries(Integer maxRetries) {
        if (maxRetries == null || maxRetries < 0) {
            maxRetries = 0;
        }
        this.sameServerErrorRetries = maxRetries;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public CONNECTION_STRATEGY getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(CONNECTION_STRATEGY connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    List<Pair<String, Integer>> getReplicaServerList() {
        return this.replicaServerList;
    }

    public Map<String, Object> getStats() {
        return this.stats.toMap();
    }

    Object httpCommand(String method, String extendedURL, String operation, String language, String payloadCommand, Map<String, Object> params, boolean leaderIsPreferable, boolean autoReconnect, Callback callback) {
        int maxRetry;
        Object lastException = null;
        int n = leaderIsPreferable || this.connectionStrategy == CONNECTION_STRATEGY.FIXED ? this.sameServerErrorRetries : (maxRetry = this.haServerErrorRetries == 0 ? this.getReplicaServerList().size() + 1 : this.haServerErrorRetries);
        if (maxRetry < 1) {
            maxRetry = 1;
        }
        Pair<String, Integer> connectToServer = leaderIsPreferable && this.leaderServer != null ? this.leaderServer : new Pair<String, Integer>((Object)this.currentServer, (Object)this.currentPort);
        String server = null;
        for (int retry = 0; retry < maxRetry && connectToServer != null; ++retry) {
            server = (String)connectToServer.getFirst() + ":" + String.valueOf(connectToServer.getSecond());
            String url = this.protocol + "://" + server + "/api/v" + this.apiVersion + "/" + operation;
            if (extendedURL != null) {
                url = url + "/" + extendedURL;
            }
            try {
                HttpRequest request;
                HttpRequest.Builder requestBuilder = this.createRequestBuilder(method, url);
                if (payloadCommand != null) {
                    if ("GET".equalsIgnoreCase(method)) {
                        throw new IllegalArgumentException("Cannot execute a HTTP GET request with a payload");
                    }
                    JSONObject jsonRequest = new JSONObject();
                    if (language != null) {
                        jsonRequest.put("language", language);
                    }
                    jsonRequest.put("command", payloadCommand);
                    jsonRequest.put("serializer", "record");
                    jsonRequest.put("retries", (Number)this.txRetries);
                    if (params != null) {
                        jsonRequest.put("params", (Object)new JSONObject(params));
                    }
                    String payload = this.getRequestPayload(jsonRequest);
                    request = requestBuilder.method(method, HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", "application/json").build();
                } else {
                    request = "GET".equalsIgnoreCase(method) ? requestBuilder.GET().build() : requestBuilder.method(method, HttpRequest.BodyPublishers.noBody()).build();
                }
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    lastException = this.manageException(response, payloadCommand != null ? payloadCommand : operation);
                    if (!(lastException instanceof RuntimeException) || !((Throwable)lastException).getMessage().equals("Empty payload received")) {
                        throw lastException;
                    }
                } else {
                    JSONObject jsonResponse = new JSONObject(response.body());
                    if (callback == null) {
                        return null;
                    }
                    return callback.call(response, jsonResponse);
                }
                LogManager.instance().log((Object)this, Level.FINE, "Empty payload received, retrying (retry=%d/%d)...", null, (Object)retry, (Object)maxRetry);
                continue;
            }
            catch (ServerIsNotTheLeaderException | IOException e) {
                lastException = e;
                if (!autoReconnect || retry + 1 >= maxRetry) break;
                if (this.connectionStrategy == CONNECTION_STRATEGY.FIXED) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Remote server (%s:%d) seems unreachable, retrying...", connectToServer.getFirst(), connectToServer.getSecond());
                    continue;
                }
                if (!this.reloadClusterConfiguration()) {
                    throw new RemoteException("Error on executing remote operation " + operation + ", no server available", (Throwable)e);
                }
                Pair<String, Integer> currentConnectToServer = connectToServer;
                connectToServer = leaderIsPreferable && !currentConnectToServer.equals(this.leaderServer) ? this.leaderServer : this.getNextReplicaAddress();
                if (connectToServer == null) continue;
                LogManager.instance().log((Object)this, Level.WARNING, "Remote server (%s:%d) seems unreachable, switching to server %s:%d...", null, currentConnectToServer.getFirst(), currentConnectToServer.getSecond(), connectToServer.getFirst(), connectToServer.getSecond());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RemoteException("Request interrupted", e);
            }
            catch (DuplicatedKeyException | NeedRetryException | TimeoutException | TransactionException | RemoteException | SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RemoteException("Error on executing remote operation " + operation + " (cause: " + e.getMessage() + ")", e);
            }
        }
        if (lastException instanceof RuntimeException) {
            RuntimeException exception = (RuntimeException)lastException;
            throw exception;
        }
        throw new RemoteException("Error on executing remote operation '" + operation + "' (server=" + server + " retry=" + maxRetry + ")", (Throwable)lastException);
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getLeaderAddress() {
        return (String)this.leaderServer.getFirst() + ":" + String.valueOf(this.leaderServer.getSecond());
    }

    public List<String> getReplicaAddresses() {
        return this.replicaServerList.stream().map(e -> (String)e.getFirst() + ":" + String.valueOf(e.getSecond())).collect(Collectors.toList());
    }

    HttpRequest.Builder createRequestBuilder(String httpMethod, String url) {
        String authorization = this.userName + ":" + this.userPassword;
        String authHeader = "Basic " + Base64.getEncoder().encodeToString(authorization.getBytes(DatabaseFactory.getDefaultCharset()));
        return HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMillis(this.timeout)).header("charset", "utf-8").header("Authorization", authHeader);
    }

    void requestClusterConfiguration() {
        JSONObject response;
        try {
            HttpRequest request = this.createRequestBuilder("GET", this.getUrl("server?mode=cluster")).GET().build();
            HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                Exception detail = this.manageException(httpResponse, "cluster configuration");
                if (detail instanceof SecurityException) {
                    throw detail;
                }
                throw new RemoteException("Error on requesting cluster configuration", detail);
            }
            response = new JSONObject(httpResponse.body());
            LogManager.instance().log((Object)this, Level.FINE, "Configuring remote database: %s", null, (Object)response);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on connecting to the server", (Throwable)e);
        }
        try {
            if (!response.has("ha")) {
                this.leaderServer = new Pair((Object)this.originalServer, (Object)this.originalPort);
                this.replicaServerList.clear();
                return;
            }
            JSONObject ha = response.getJSONObject("ha");
            String cfgLeaderServer = (String)ha.get("leaderAddress");
            String[] leaderServerParts = HostUtil.parseHostAddress(cfgLeaderServer, "2424");
            this.leaderServer = new Pair((Object)leaderServerParts[0], (Object)Integer.parseInt(leaderServerParts[1]));
            String cfgReplicaServers = (String)ha.get("replicaAddresses");
            this.replicaServerList.clear();
            if (cfgReplicaServers != null && !cfgReplicaServers.isEmpty()) {
                String[] serverEntries;
                for (String serverEntry : serverEntries = cfgReplicaServers.split(",")) {
                    try {
                        String[] serverParts = HostUtil.parseHostAddress(serverEntry, "2480");
                        String sHost = serverParts[0];
                        int sPort = Integer.parseInt(serverParts[1]);
                        this.replicaServerList.add((Pair<String, Integer>)new Pair((Object)sHost, (Object)sPort));
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Invalid replica server address '%s'", null, (Object)serverEntry);
                    }
                }
            }
            LogManager.instance().log((Object)this, Level.FINE, "Remote Database configured with leader=%s and replicas=%s strategy=%s", this.leaderServer, this.replicaServerList, (Object)this.connectionStrategy);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on requesting cluster configuration", (Throwable)e);
        }
    }

    private Pair<String, Integer> getNextReplicaAddress() {
        if (this.replicaServerList.isEmpty()) {
            return this.leaderServer;
        }
        ++this.currentReplicaServerIndex;
        if (this.currentReplicaServerIndex > this.replicaServerList.size() - 1) {
            this.currentReplicaServerIndex = 0;
        }
        return this.replicaServerList.get(this.currentReplicaServerIndex);
    }

    boolean reloadClusterConfiguration() {
        Pair<String, Integer> oldLeader = this.leaderServer;
        for (int replicaIdx = 0; replicaIdx < this.replicaServerList.size(); ++replicaIdx) {
            Pair<String, Integer> connectToServer = this.replicaServerList.get(replicaIdx);
            this.currentServer = (String)connectToServer.getFirst();
            this.currentPort = (Integer)connectToServer.getSecond();
            try {
                this.requestClusterConfiguration();
            }
            catch (Exception e) {
                continue;
            }
            if (this.leaderServer == null) continue;
            return true;
        }
        if (oldLeader != null) {
            this.leaderServer = null;
            this.currentServer = (String)oldLeader.getFirst();
            this.currentPort = (Integer)oldLeader.getSecond();
            try {
                this.requestClusterConfiguration();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.leaderServer != null;
    }

    protected String getUrl(String command) {
        return this.protocol + "://" + this.currentServer + ":" + this.currentPort + "/api/v" + this.apiVersion + "/" + command;
    }

    String getRequestPayload(JSONObject jsonRequest) {
        return jsonRequest.toString();
    }

    protected Exception manageException(HttpResponse<String> response, String operation) {
        String httpErrorDescription;
        String detail = null;
        String reason = null;
        String exception = null;
        String exceptionArgs = null;
        String responsePayload = response.body();
        try {
            if (responsePayload != null && !responsePayload.isEmpty()) {
                JSONObject jsonResponse = new JSONObject(responsePayload);
                reason = jsonResponse.has("error") ? jsonResponse.getString("error") : null;
                detail = jsonResponse.has("detail") ? jsonResponse.getString("detail") : null;
                exception = jsonResponse.has("exception") ? jsonResponse.getString("exception") : null;
                exceptionArgs = jsonResponse.has("exceptionArgs") ? jsonResponse.getString("exceptionArgs") : null;
            }
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.WARNING, "Error on executing command, retrying... (payload=%s, error=%s)", null, (Object)responsePayload, (Object)e.toString());
            return e;
        }
        if (exception != null) {
            if (detail == null) {
                detail = "Unknown";
            }
            if (exception.equals(ServerIsNotTheLeaderException.class.getName())) {
                int sep = detail.lastIndexOf(46);
                return new ServerIsNotTheLeaderException(sep > -1 ? detail.substring(0, sep) : detail, exceptionArgs);
            }
            if (exception.equals(RecordNotFoundException.class.getName())) {
                int begin = detail.indexOf("#");
                int end = detail.indexOf(" ", begin);
                return new RecordNotFoundException(detail, new RID(detail.substring(begin, end)));
            }
            if (exception.equals(QuorumNotReachedException.class.getName())) {
                return new QuorumNotReachedException(detail);
            }
            if (exception.equals(DuplicatedKeyException.class.getName()) && exceptionArgs != null) {
                String[] exceptionArgsParts = exceptionArgs.split("\\|");
                return new DuplicatedKeyException(exceptionArgsParts[0], exceptionArgsParts[1], new RID(exceptionArgsParts[2]));
            }
            if (exception.equals(ConcurrentModificationException.class.getName())) {
                return new ConcurrentModificationException(detail);
            }
            if (exception.equals(TransactionException.class.getName())) {
                return new TransactionException(detail);
            }
            if (exception.equals(TimeoutException.class.getName())) {
                return new TimeoutException(detail);
            }
            if (exception.equals(SchemaException.class.getName())) {
                return new SchemaException(detail);
            }
            if (exception.equals(NoSuchElementException.class.getName())) {
                return new NoSuchElementException(detail);
            }
            if (exception.equals(SecurityException.class.getName())) {
                return new SecurityException(detail);
            }
            if (exception.equals("com.arcadedb.server.security.ServerSecurityException")) {
                return new SecurityException(detail);
            }
            if (exception.equals(ConnectException.class.getName())) {
                return new NeedRetryException(detail);
            }
            if (exception.equals("com.arcadedb.server.ha.ReplicationException")) {
                return new NeedRetryException(detail);
            }
            return new RemoteException("Error on executing remote operation " + operation + " (cause:" + exception + " detail:" + detail + ")");
        }
        String string = response.statusCode() == 400 ? "Bad Request" : (response.statusCode() == 404 ? "Not Found" : (httpErrorDescription = response.statusCode() == 500 ? "Internal Server Error" : "HTTP Error"));
        if (response.statusCode() == 400 && "Bad Request".equals(httpErrorDescription) && "Command text is null".equals(reason)) {
            return new RemoteException("Empty payload received");
        }
        return new RemoteException("Error on executing remote command '" + operation + "' (httpErrorCode=" + response.statusCode() + " httpErrorDescription=" + httpErrorDescription + " reason=" + reason + " detail=" + detail + " exception=" + exception + ")");
    }

    public static enum CONNECTION_STRATEGY {
        STICKY,
        ROUND_ROBIN,
        FIXED;

    }

    public static interface Callback {
        public Object call(HttpResponse<String> var1, JSONObject var2) throws Exception;
    }
}

