/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.network.binary;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.network.binary.ChannelBinary;
import com.arcadedb.network.binary.NetworkProtocolException;
import com.arcadedb.network.binary.SocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class ChannelBinaryClient
extends ChannelBinary {
    protected final int socketTimeout;
    protected String url;

    public ChannelBinaryClient(String remoteHost, int remotePort, ContextConfiguration config) throws IOException {
        super(SocketFactory.instance(config).createSocket(), config.getValueAsInteger(GlobalConfiguration.HA_REPLICATION_CHUNK_MAXSIZE));
        try {
            this.url = remoteHost + ":" + remotePort;
            this.socketTimeout = config.getValueAsInteger(GlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
            try {
                if (remoteHost.contains(":")) {
                    InetAddress[] addresses = Inet6Address.getAllByName(remoteHost);
                    this.socket.connect(new InetSocketAddress(addresses[0], remotePort), this.socketTimeout);
                } else {
                    this.socket.connect(new InetSocketAddress(remoteHost, remotePort), this.socketTimeout);
                }
                this.setReadResponseTimeout();
            }
            catch (SocketTimeoutException e) {
                throw new IOException("Cannot connect to host " + remoteHost + ":" + remotePort + " (timeout=" + this.socketTimeout + ")", e);
            }
            try {
                this.inStream = new BufferedInputStream(this.socket.getInputStream());
                this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
                this.in = new DataInputStream(this.inStream);
                this.out = new DataOutputStream(this.outStream);
            }
            catch (IOException e) {
                throw new NetworkProtocolException("Error on reading data from remote server " + String.valueOf(this.socket.getRemoteSocketAddress()) + ": ", e);
            }
        }
        catch (RuntimeException e) {
            if (this.socket.isConnected()) {
                this.socket.close();
            }
            throw e;
        }
    }

    public boolean isConnected() {
        Socket s = this.socket;
        return s != null && !s.isClosed() && s.isConnected() && !s.isInputShutdown() && !s.isOutputShutdown();
    }

    protected void setReadResponseTimeout() throws SocketException {
        Socket s = this.socket;
        if (s != null && s.isConnected() && !s.isClosed()) {
            s.setSoTimeout(this.socketTimeout);
        }
    }

    public String getURL() {
        return this.url;
    }
}

