/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.network.binary;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.RID;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.Channel;
import com.arcadedb.network.binary.ChannelDataInput;
import com.arcadedb.network.binary.ChannelDataOutput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;

public abstract class ChannelBinary
extends Channel
implements ChannelDataInput,
ChannelDataOutput {
    private static final int MAX_LENGTH_DEBUG = 150;
    private final int maxChunkSize;
    protected DataInputStream in;
    protected DataOutputStream out;

    public ChannelBinary(Socket iSocket, int chunkMaxSize) throws IOException {
        super(iSocket);
        this.maxChunkSize = chunkMaxSize;
    }

    @Override
    public boolean inputHasData() {
        if (this.in != null) {
            try {
                return this.in.available() > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        this.updateMetricReceivedBytes(1);
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        this.updateMetricReceivedBytes(1);
        return this.in.readUnsignedByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.updateMetricReceivedBytes(1);
        return this.in.readBoolean();
    }

    @Override
    public int readInt() throws IOException {
        this.updateMetricReceivedBytes(4);
        return this.in.readInt();
    }

    public long readUnsignedInt() throws IOException {
        this.updateMetricReceivedBytes(4);
        return (long)this.in.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        this.updateMetricReceivedBytes(8);
        return this.in.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.updateMetricReceivedBytes(2);
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.updateMetricReceivedBytes(2);
        return this.in.readUnsignedShort();
    }

    @Override
    public String readString() throws IOException {
        int len = this.in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        this.updateMetricReceivedBytes(4 + len);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public void readBytes(byte[] buffer) throws IOException {
        this.in.readFully(buffer);
    }

    @Override
    public byte[] readBytes() throws IOException {
        int len = this.in.readInt();
        if (len > this.maxChunkSize) {
            throw new IOException("Impossible to read a chunk of length:" + len + " max allowed chunk length:" + this.maxChunkSize + " see NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
        }
        this.updateMetricReceivedBytes(4 + len);
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        return tmp;
    }

    @Override
    public RID readRID(Database database) throws IOException {
        int bucketId = this.readInt();
        long clusterPosition = this.readLong();
        return new RID((BasicDatabase)database, bucketId, clusterPosition);
    }

    @Override
    public int readVersion() throws IOException {
        return this.readInt();
    }

    @Override
    public ChannelBinary writeByte(byte iContent) throws IOException {
        this.out.write(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    @Override
    public ChannelBinary writeBoolean(boolean iContent) throws IOException {
        this.out.writeBoolean(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    @Override
    public ChannelBinary writeInt(int iContent) throws IOException {
        this.out.writeInt(iContent);
        this.updateMetricTransmittedBytes(4);
        return this;
    }

    public ChannelBinary writeUnsignedInt(int iContent) throws IOException {
        this.out.writeInt((int)Integer.toUnsignedLong(iContent));
        this.updateMetricTransmittedBytes(4);
        return this;
    }

    @Override
    public ChannelBinary writeLong(long iContent) throws IOException {
        this.out.writeLong(iContent);
        this.updateMetricTransmittedBytes(8);
        return this;
    }

    @Override
    public ChannelBinary writeShort(short iContent) throws IOException {
        this.out.writeShort(iContent);
        this.updateMetricTransmittedBytes(2);
        return this;
    }

    public ChannelBinary writeUnsignedShort(short iContent) throws IOException {
        this.out.writeShort(Short.toUnsignedInt(iContent));
        this.updateMetricTransmittedBytes(2);
        return this;
    }

    @Override
    public ChannelBinary writeString(String iContent) throws IOException {
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            byte[] buffer = iContent.getBytes(StandardCharsets.UTF_8);
            this.out.writeInt(buffer.length);
            this.out.write(buffer, 0, buffer.length);
            this.updateMetricTransmittedBytes(4 + buffer.length);
        }
        return this;
    }

    @Override
    public ChannelBinary writeVarLengthBytes(byte[] iContent) throws IOException {
        return this.writeVarLengthBytes(iContent, iContent != null ? iContent.length : 0);
    }

    @Override
    public ChannelBinary writeVarLengthBytes(byte[] iContent, int iLength) throws IOException {
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            if (iLength > this.maxChunkSize) {
                throw new IOException("Impossible to write a chunk of " + iLength + " bytes. Max allowed chunk is " + this.maxChunkSize + " bytes. See NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
            }
            this.out.writeInt(iLength);
            this.out.write(iContent, 0, iLength);
            this.updateMetricTransmittedBytes(4 + iLength);
        }
        return this;
    }

    public ChannelBinary writeBytes(byte[] content) throws IOException {
        if (content != null) {
            int length = content.length;
            if (length > this.maxChunkSize) {
                throw new IOException("Impossible to write a chunk of " + length + " bytes. Max allowed chunk is " + this.maxChunkSize + " bytes. See NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
            }
            this.out.write(content, 0, length);
            this.updateMetricTransmittedBytes(length);
        }
        return this;
    }

    @Override
    public void writeRID(RID iRID) throws IOException {
        this.writeInt(iRID.getBucketId());
        this.writeLong(iRID.getPosition());
    }

    @Override
    public void writeVersion(int version) throws IOException {
        this.writeInt(version);
    }

    public void clearInput() throws IOException {
        if (this.in == null) {
            return;
        }
        StringBuilder dirtyBuffer = new StringBuilder(150);
        int i = 0;
        while (this.in.available() > 0) {
            char c = (char)this.in.read();
            ++i;
            if (dirtyBuffer.length() >= 150) continue;
            dirtyBuffer.append(c);
        }
        this.updateMetricReceivedBytes(i);
        String message = "Received unread response from " + String.valueOf(this.socket.getRemoteSocketAddress()) + " probably corrupted data from the network connection. Cleared dirty data in the buffer (" + i + " bytes): [" + String.valueOf(dirtyBuffer) + (i > dirtyBuffer.length() ? "..." : "") + "]";
        LogManager.instance().log((Object)this, Level.SEVERE, message);
        throw new IOException(message);
    }

    @Override
    public void flush() throws IOException {
        this.updateMetricFlushes();
        if (this.out != null) {
            this.out.flush();
        } else {
            super.flush();
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during closing of input stream", (Throwable)e);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during closing of output stream", (Throwable)e);
        }
        super.close();
    }

    @Override
    public DataOutputStream getDataOutput() {
        return this.out;
    }

    @Override
    public DataInputStream getDataInput() {
        return this.in;
    }

    public ChannelBinary writeBuffer(ByteBuffer buffer) throws IOException {
        int length = buffer.limit();
        if (length > this.maxChunkSize) {
            throw new IOException("Impossible to write a chunk of " + length + " bytes max allowed chunk is " + this.maxChunkSize + " bytes. See NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
        }
        this.out.write(buffer.array(), buffer.arrayOffset(), length);
        this.updateMetricTransmittedBytes(length);
        return this;
    }
}

