/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.graph;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.RID;
import com.arcadedb.database.async.DatabaseAsyncExecutorImpl;
import com.arcadedb.database.async.DatabaseAsyncTask;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.EdgeLinkedList;
import com.arcadedb.graph.EdgeSegment;
import com.arcadedb.graph.GraphEngine;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.graph.VertexInternal;
import com.arcadedb.index.CompressedRID2RIDsIndex;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.graph.EdgeLinkedCallback;
import com.arcadedb.integration.importer.graph.GraphImporter;
import com.arcadedb.log.LogManager;
import com.arcadedb.utility.FileUtils;
import com.arcadedb.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class CreateEdgeFromImportTask
implements DatabaseAsyncTask {
    private final GraphImporter.GraphImporterThreadContext threadContext;
    private final String edgeTypeName;
    private final long sourceVertexKey;
    private final long destinationVertexKey;
    private final Object[] params;
    private final ImporterContext context;
    private final ImporterSettings settings;

    public CreateEdgeFromImportTask(GraphImporter.GraphImporterThreadContext threadContext, String edgeTypeName, long sourceVertexKey, long destinationVertexKey, Object[] edgeProperties, ImporterContext context, ImporterSettings settings) {
        this.threadContext = threadContext;
        this.edgeTypeName = edgeTypeName;
        this.sourceVertexKey = sourceVertexKey;
        this.destinationVertexKey = destinationVertexKey;
        this.params = edgeProperties;
        this.context = context;
        this.settings = settings;
    }

    public void execute(DatabaseAsyncExecutorImpl.AsyncThread async, DatabaseInternal database) {
        RID destinationVertexRID = this.context.graphImporter.getVertex(this.threadContext.vertexIndexThreadBuffer, this.destinationVertexKey);
        if (destinationVertexRID == null) {
            this.context.skippedEdges.incrementAndGet();
            return;
        }
        if (this.threadContext.lastSourceKey == null || !this.threadContext.lastSourceKey.equals(this.sourceVertexKey)) {
            this.createEdgesInBatch(database, this.threadContext.incomingConnectionsIndexThread, this.context, this.settings, this.threadContext.connections);
            this.threadContext.connections = new ArrayList<GraphEngine.CreateEdgeOperation>();
            RID sourceVertexRID = this.context.graphImporter.getVertex(this.threadContext.vertexIndexThreadBuffer, this.sourceVertexKey);
            if (sourceVertexRID == null) {
                this.context.skippedEdges.incrementAndGet();
                return;
            }
            this.threadContext.lastSourceKey = this.sourceVertexKey;
            this.threadContext.lastSourceVertex = (VertexInternal)sourceVertexRID.asVertex(true);
        }
        this.threadContext.connections.add(new GraphEngine.CreateEdgeOperation(this.edgeTypeName, (Identifiable)destinationVertexRID, this.params));
        ++this.threadContext.importedEdges;
        if ((long)this.threadContext.incomingConnectionsIndexThread.getChunkSize() >= this.settings.maxRAMIncomingEdges) {
            LogManager.instance().log((Object)this, Level.INFO, "Creation of back connections, reached %s size (max=%s), flushing %d connections (slots=%d thread=%d)...", null, (Object)FileUtils.getSizeAsString((long)this.threadContext.incomingConnectionsIndexThread.getChunkSize()), (Object)FileUtils.getSizeAsString((long)this.settings.maxRAMIncomingEdges), (Object)this.threadContext.incomingConnectionsIndexThread.size(), (Object)this.threadContext.incomingConnectionsIndexThread.getTotalUsedSlots(), (Object)Thread.currentThread().threadId());
            CreateEdgeFromImportTask.createIncomingEdgesInBatch(database, this.threadContext.incomingConnectionsIndexThread, linked -> this.context.linkedEdges.addAndGet(linked));
            try {
                this.threadContext.incomingConnectionsIndexThread = new CompressedRID2RIDsIndex((Database)database, this.threadContext.incomingConnectionsIndexThread.getKeys(), (int)this.settings.expectedEdges);
            }
            catch (ClassNotFoundException e) {
                throw new ImportException("Error on creating internal component", e);
            }
            LogManager.instance().log((Object)this, Level.INFO, "Creation done, reset index buffer and continue");
        }
        if (this.threadContext.importedEdges % this.settings.commitEvery == 0) {
            LogManager.instance().log((Object)this, Level.FINE, "Committing batch of outgoing edges (chunkSize=%s max=%s entries=%d slots=%d)...", null, (Object)FileUtils.getSizeAsString((long)this.threadContext.incomingConnectionsIndexThread.getChunkSize()), (Object)FileUtils.getSizeAsString((long)this.settings.maxRAMIncomingEdges), (Object)this.threadContext.incomingConnectionsIndexThread.size(), (Object)this.threadContext.incomingConnectionsIndexThread.getTotalUsedSlots());
            this.createEdgesInBatch(database, this.threadContext.incomingConnectionsIndexThread, this.context, this.settings, this.threadContext.connections);
            this.threadContext.connections = new ArrayList<GraphEngine.CreateEdgeOperation>();
        }
    }

    private void createEdgesInBatch(DatabaseInternal database, CompressedRID2RIDsIndex edgeIndex, ImporterContext context, ImporterSettings settings, List<GraphEngine.CreateEdgeOperation> connections) {
        if (!connections.isEmpty()) {
            if (this.threadContext.lastSourceVertex.getOutEdgesHeadChunk() == null) {
                this.threadContext.lastSourceVertex = (VertexInternal)this.threadContext.lastSourceVertex.getIdentity().asVertex();
            }
            List newEdges = database.getGraphEngine().newEdges(this.threadContext.lastSourceVertex, connections, false);
            context.createdEdges.addAndGet(newEdges.size());
            for (Edge e : newEdges) {
                edgeIndex.put(e.getIn(), e.getIdentity(), this.threadContext.lastSourceVertex.getIdentity());
            }
            connections.clear();
        }
    }

    protected static void createIncomingEdgesInBatch(DatabaseInternal database, CompressedRID2RIDsIndex index, EdgeLinkedCallback callback) {
        Vertex lastVertex = null;
        LogManager.instance().log(CreateEdgeFromImportTask.class, Level.INFO, "Linking %d incoming connections (chunk=%s allocated=%s totalSlotUsed=%d keys=%d)...", null, (Object)index.size(), (Object)FileUtils.getSizeAsString((long)index.getChunkSize()), (Object)FileUtils.getSizeAsString((long)index.getChunkAllocated()), (Object)index.getTotalUsedSlots(), (Object)index.getKeys());
        ArrayList<Object> connections = new ArrayList<Pair<Identifiable, Identifiable>>();
        long totalVertices = 0L;
        long totalEdges = 0L;
        int minEdges = Integer.MAX_VALUE;
        int maxEdges = -1;
        CompressedRID2RIDsIndex.EntryIterator it = index.entryIterator();
        while (it.hasNext()) {
            try {
                Vertex destinationVertex = it.getKeyRID().asVertex(true);
                if (!connections.isEmpty() && !destinationVertex.equals((Object)lastVertex)) {
                    ++totalVertices;
                    if (connections.size() < minEdges) {
                        minEdges = connections.size();
                    }
                    if (connections.size() > maxEdges) {
                        maxEdges = connections.size();
                    }
                    CreateEdgeFromImportTask.connectIncomingEdges(database, (Identifiable)lastVertex, connections, callback);
                    connections = new ArrayList();
                }
                lastVertex = destinationVertex;
                connections.add((Pair<Identifiable, Identifiable>)new Pair((Object)it.getEdgeRID(), (Object)it.getVertexRID()));
                ++totalEdges;
            }
            catch (Exception e) {
                LogManager.instance().log(CreateEdgeFromImportTask.class, Level.SEVERE, "Error on creating incoming edge from %s -[%s]-> %s", (Throwable)e, (Object)it.getVertexRID(), (Object)it.getEdgeRID(), (Object)it.getKeyRID(), (Object)it.getVertexRID());
            }
            it.moveNext();
        }
        if (lastVertex != null) {
            CreateEdgeFromImportTask.connectIncomingEdges(database, lastVertex, connections, callback);
        }
        LogManager.instance().log(CreateEdgeFromImportTask.class, Level.INFO, "Created %d back connections from %d vertices (min=%d max=%d avg=%d)", null, (Object)totalEdges, (Object)totalVertices, (Object)minEdges, (Object)maxEdges, (Object)(totalVertices > 0L ? totalEdges / totalVertices : 0L));
    }

    public static void connectIncomingEdges(DatabaseInternal database, Identifiable toVertex, List<Pair<Identifiable, Identifiable>> connections, EdgeLinkedCallback callback) {
        MutableVertex toVertexRecord = ((Vertex)toVertex.getRecord()).modify();
        EdgeSegment inChunk = database.getGraphEngine().createInEdgeChunk(toVertexRecord);
        EdgeLinkedList inLinkedList = new EdgeLinkedList((Vertex)toVertexRecord, Vertex.DIRECTION.IN, inChunk);
        inLinkedList.addAll(connections);
        if (callback != null) {
            callback.onLinked(connections.size());
        }
    }

    public String toString() {
        return "CreateEdgeFromImportTask(" + this.sourceVertexKey + "->" + this.destinationVertexKey + ")";
    }
}

