/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.exporter;

import com.arcadedb.utility.FileUtils;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ExporterSettings {
    public String format;
    public String databaseURL;
    public String file;
    public boolean overwriteFile = false;
    public int verboseLevel = 2;
    public Set<String> includeRecords;
    public Set<String> includeTypes;
    public Set<String> excludeTypes;
    public final Map<String, String> options = new HashMap<String, String>();

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length - 1; i += this.parseParameter(args[i].substring(1), args[i + 1])) {
            }
        }
        if (this.includeTypes != null && this.excludeTypes != null) {
            throw new IllegalArgumentException("Both includeTypes and excludeTypes were defined, but they are mutual exclusive");
        }
        if (this.format == null) {
            throw new IllegalArgumentException("Missing export format");
        }
        if (this.file == null) {
            switch (this.format) {
                case "backup": {
                    this.file = "arcadedb-backup-%s.zip";
                    break;
                }
                default: {
                    this.file = "arcadedb-backup-%s." + this.format + ".tgz";
                }
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
        this.file = this.file.formatted(dateFormat.format(System.currentTimeMillis()));
    }

    public int parseParameter(String name, String value) {
        if ("format".equals(name = FileUtils.getStringContent((Object)name))) {
            this.format = value.toLowerCase(Locale.ENGLISH);
        } else if ("f".equals(name) || "file".equals(name)) {
            this.file = value;
        } else if ("d".equals(name)) {
            this.databaseURL = value;
        } else if ("overwrite".equals(name)) {
            this.overwriteFile = true;
        } else {
            if ("o".equals(name)) {
                this.overwriteFile = true;
                return 1;
            }
            if ("includeTypes".equals(name)) {
                this.includeTypes = Set.of(value.split(","));
            } else if ("excludeTypes".equals(name)) {
                this.excludeTypes = Set.of(value.split(","));
            } else if ("includeRecords".equals(name)) {
                this.includeRecords = Set.of(value.split(","));
            } else {
                this.options.put(name, value);
            }
        }
        return 2;
    }
}

