/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.restore.format;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.restore.RestoreException;
import com.arcadedb.integration.restore.RestoreSettings;
import com.arcadedb.integration.restore.format.AbstractRestoreFormat;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FullRestoreFormat
extends AbstractRestoreFormat {
    private final byte[] BUFFER = new byte[8192];

    public FullRestoreFormat(DatabaseInternal database, RestoreSettings settings, ConsoleLogger logger) {
        super(database, settings, logger);
    }

    @Override
    public void restoreDatabase() throws Exception {
        this.settings.validate();
        RestoreInputSource inputSource = this.openInputFile();
        File databaseDirectory = new File(this.settings.databaseDirectory);
        if (databaseDirectory.exists()) {
            if (!this.settings.overwriteDestination) {
                throw new RestoreException("The database directory '%s' already exist and '-o' setting is false".formatted(this.settings.databaseDirectory));
            }
            FileUtils.deleteRecursively((File)databaseDirectory);
        }
        if (!databaseDirectory.mkdirs()) {
            throw new RestoreException("Error on restoring database: the database directory '%s' cannot be created".formatted(this.settings.databaseDirectory));
        }
        this.logger.logLine(0, "Executing full restore of database from file '%s' to '%s'...", this.settings.inputFileURL, this.settings.databaseDirectory);
        try (ZipInputStream zipFile = new ZipInputStream(inputSource.inputStream, DatabaseFactory.getDefaultCharset());){
            long beginTime = System.currentTimeMillis();
            long databaseOrigSize = 0L;
            ZipEntry compressedFile = zipFile.getNextEntry();
            while (compressedFile != null) {
                databaseOrigSize += this.uncompressFile(zipFile, compressedFile, databaseDirectory);
                compressedFile = zipFile.getNextEntry();
            }
            zipFile.close();
            long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
            this.logger.logLine(0, "Full restore completed in %d seconds %s -> %s (%,d%% compression)", elapsedInSecs, FileUtils.getSizeAsString((long)databaseOrigSize), FileUtils.getSizeAsString((long)inputSource.fileSize), databaseOrigSize > 0L ? (databaseOrigSize - inputSource.fileSize) * 100L / databaseOrigSize : 0L);
        }
    }

    private long uncompressFile(ZipInputStream inputFile, ZipEntry compressedFile, File databaseDirectory) throws IOException {
        String fileName = compressedFile.getName();
        FileUtils.checkValidName((String)fileName);
        this.logger.log(2, "- File '%s'...", fileName);
        File uncompressedFile = new File(databaseDirectory, fileName);
        if (!uncompressedFile.toPath().normalize().startsWith(databaseDirectory.toPath().normalize())) {
            throw new IOException("Bad zip entry");
        }
        try (FileOutputStream fileOut = new FileOutputStream(uncompressedFile);){
            int len;
            while ((len = inputFile.read(this.BUFFER)) > 0) {
                fileOut.write(this.BUFFER, 0, len);
            }
        }
        long origSize = uncompressedFile.length();
        long compressedSize = compressedFile.getCompressedSize();
        this.logger.logLine(2, " %s -> %s (%,d%% compressed)", FileUtils.getSizeAsString((long)origSize), FileUtils.getSizeAsString((long)compressedSize), origSize > 0L ? (origSize - compressedSize) * 100L / origSize : 0L);
        return origSize;
    }

    private RestoreInputSource openInputFile() throws IOException {
        if (this.settings.inputFileURL.startsWith("http://") || this.settings.inputFileURL.startsWith("https://")) {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.settings.inputFileURL).openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.connect();
            return new RestoreInputSource(connection.getInputStream(), 0L);
        }
        String path = this.settings.inputFileURL;
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        } else if (path.startsWith("classpath://")) {
            path = this.getClass().getClassLoader().getResource(path.substring("classpath://".length())).getFile();
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new RestoreException("The backup file '%s' does not exist (local path=%s)".formatted(this.settings.inputFileURL, new File(".").getAbsolutePath()));
        }
        return new RestoreInputSource(new FileInputStream(file), file.length());
    }

    private static class RestoreInputSource {
        public final InputStream inputStream;
        public final long fileSize;

        public RestoreInputSource(InputStream inputStream, long fileSize) {
            this.inputStream = inputStream;
            this.fileSize = fileSize;
        }
    }
}

