/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.graph;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.async.DatabaseAsyncExecutorImpl;
import com.arcadedb.database.async.DatabaseAsyncTask;
import com.arcadedb.graph.EdgeLinkedList;
import com.arcadedb.graph.EdgeSegment;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.integration.importer.graph.EdgeLinkedCallback;
import com.arcadedb.utility.Pair;
import java.util.List;

public class LinkEdgeFromImportTask
implements DatabaseAsyncTask {
    private final Identifiable destinationVertex;
    private final List<Pair<Identifiable, Identifiable>> connections;
    private final EdgeLinkedCallback callback;

    public LinkEdgeFromImportTask(Identifiable destinationVertex, List<Pair<Identifiable, Identifiable>> connections, EdgeLinkedCallback callback) {
        this.destinationVertex = destinationVertex;
        this.connections = connections;
        this.callback = callback;
    }

    public void execute(DatabaseAsyncExecutorImpl.AsyncThread async, DatabaseInternal database) {
        MutableVertex toVertexRecord = ((Vertex)this.destinationVertex.getRecord()).modify();
        EdgeSegment inChunk = database.getGraphEngine().createInEdgeChunk(toVertexRecord);
        EdgeLinkedList inLinkedList = new EdgeLinkedList((Vertex)toVertexRecord, Vertex.DIRECTION.IN, inChunk);
        inLinkedList.addAll(this.connections);
        if (this.callback != null) {
            this.callback.onLinked(this.connections.size());
        }
    }

    public String toString() {
        return "LinkEdgeFromImportTask(" + this.destinationVertex.getIdentity() + "<-" + this.connections.size() + ")";
    }
}

