/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.OrientDBImporter;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.AbstractImporterFormat;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class OrientDBImporterFormat
extends AbstractImporterFormat {
    @Override
    public void load(final SourceSchema sourceSchema, AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws ImportException {
        context.parsed.set(0L);
        try {
            new OrientDBImporter(database, settings){

                @Override
                public GZIPInputStream openInputStream() throws IOException {
                    sourceSchema.getSource().reset();
                    return (GZIPInputStream)sourceSchema.getSource().inputStream;
                }
            }.setContext(context).run();
        }
        catch (Exception e) {
            throw new ImportException("Error on importing OrientDB database", e);
        }
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) throws IOException {
        return new SourceSchema(this, parser.getSource(), analyzedSchema);
    }

    @Override
    public String getFormat() {
        return "OrientDB";
    }
}

