/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.MutableEmbeddedDocument;
import com.arcadedb.database.RID;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.CompressedRID2RIDIndex;
import com.arcadedb.index.TypeIndex;
import com.arcadedb.index.lsm.LSMTreeIndexAbstract;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.AbstractImporterFormat;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.LocalVertexType;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.VertexType;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JsonlImporterFormat
extends AbstractImporterFormat {
    private ConsoleLogger logger;
    private CompressedRID2RIDIndex ridIndex;

    @Override
    public void load(SourceSchema sourceSchema, AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws IOException {
        this.logger = new ConsoleLogger(settings.verboseLevel);
        this.logger.logLine(2, "Start importing... ", new Object[0]);
        try (InputStreamReader inputFileReader = new InputStreamReader(parser.getInputStream(), DatabaseFactory.getDefaultCharset());){
            String line;
            context.startedOn = System.currentTimeMillis();
            BufferedReader reader = new BufferedReader(inputFileReader);
            this.ridIndex = new CompressedRID2RIDIndex((Database)database, 1000, 1000);
            if (!database.isTransactionActive()) {
                database.begin();
            }
            while ((line = reader.readLine()) != null) {
                JSONObject jsonLine = new JSONObject(line);
                switch (jsonLine.getString("t")) {
                    case "schema": {
                        this.loadSchema(database, context, settings, jsonLine.getJSONObject("c"));
                        break;
                    }
                    case "d": {
                        this.loadDocument(database, context, settings, jsonLine.getJSONObject("c"));
                        break;
                    }
                    case "v": {
                        this.loadVertex(database, context, settings, jsonLine.getJSONObject("c"));
                        break;
                    }
                    case "e": {
                        this.loadEdge(database, context, settings, jsonLine.getJSONObject("c"));
                    }
                }
                context.parsed.incrementAndGet();
                if (context.parsed.get() % 1000L != 0L) continue;
                database.commit();
                database.begin();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            database.commit();
        }
        context.lastLapOn = System.currentTimeMillis();
    }

    private void loadSchema(DatabaseInternal database, ImporterContext context, ImporterSettings settings, JSONObject importedSchema) {
        this.logger.logLine(2, "Loading schema... ", new Object[0]);
        Schema databaseSchema = database.getSchema();
        JSONObject importedSettings = importedSchema.getJSONObject("settings");
        databaseSchema.setDateFormat(importedSettings.getString("dateFormat"));
        databaseSchema.setDateTimeFormat(importedSettings.getString("dateTimeFormat"));
        databaseSchema.setZoneId(ZoneId.of(importedSettings.getString("zoneId")));
        JSONObject types = importedSchema.getJSONObject("types");
        types.keySet().forEach(typeName -> {
            String typeType;
            JSONObject type = types.getJSONObject(typeName);
            VertexType docType = switch (typeType = type.getString("type")) {
                case "v" -> databaseSchema.createVertexType(typeName);
                case "e" -> databaseSchema.createEdgeType(typeName);
                case "d" -> databaseSchema.createDocumentType(typeName);
                default -> throw new IllegalStateException("Unexpected value: " + typeType);
            };
        });
        types.keySet().forEach(typeName -> {
            JSONObject type = types.getJSONObject(typeName);
            DocumentType docType = databaseSchema.getType(typeName);
            JSONObject properties = type.getJSONObject("properties");
            properties.keySet().forEach(propertyName -> {
                JSONObject property = properties.getJSONObject(propertyName);
                docType.createProperty(propertyName, property);
            });
        });
        types.keySet().forEach(typeName -> {
            JSONObject type = types.getJSONObject(typeName);
            DocumentType docType = databaseSchema.getType(typeName);
            JSONArray parents = type.getJSONArray("parents");
            parents.toList().stream().map(Object::toString).forEach(arg_0 -> ((DocumentType)docType).addSuperType(arg_0));
        });
        types.keySet().forEach(typeName -> {
            JSONObject type = types.getJSONObject(typeName);
            DocumentType docType = databaseSchema.getType(typeName);
            JSONObject indexes = type.getJSONObject("indexes");
            indexes.keySet().forEach(index -> {
                JSONObject idx = indexes.getJSONObject(index);
                Schema.INDEX_TYPE idxType = Schema.INDEX_TYPE.valueOf((String)idx.getString("type"));
                String[] idxFields = (String[])idx.getJSONArray("properties").toList().stream().map(Object::toString).toArray(String[]::new);
                TypeIndex typeIndex = docType.getOrCreateTypeIndex(idxType, idx.getBoolean("unique"), idxFields);
                typeIndex.setNullStrategy(LSMTreeIndexAbstract.NULL_STRATEGY.valueOf((String)idx.getString("nullStrategy")));
            });
        });
        databaseSchema.getTypes().forEach(type -> this.logger.logLine(2, " - Created type %s: %s", type.getName(), type.toJSON()));
    }

    private void loadDocument(DatabaseInternal database, ImporterContext context, ImporterSettings settings, JSONObject document) {
        JSONObject properties = document.getJSONObject("p");
        MutableDocument imported = database.newDocument(document.getString("t"));
        this.loadProperties(database, imported, properties);
        imported.save();
        RID oldRid = new RID((BasicDatabase)database, document.getString("r"));
        this.ridIndex.put(oldRid, imported.getIdentity());
        context.createdDocuments.incrementAndGet();
    }

    private void loadVertex(DatabaseInternal database, ImporterContext context, ImporterSettings settings, JSONObject vertex) {
        JSONObject properties = vertex.getJSONObject("p");
        MutableVertex imported = database.newVertex(vertex.getString("t"));
        this.loadProperties(database, (MutableDocument)imported, properties);
        imported.save();
        RID oldRid = new RID((BasicDatabase)database, vertex.getString("r"));
        this.ridIndex.put(oldRid, imported.getIdentity());
        context.createdVertices.incrementAndGet();
    }

    private void loadEdge(DatabaseInternal database, ImporterContext context, ImporterSettings settings, JSONObject edge) {
        JSONObject properties = edge.getJSONObject("p");
        String edgeType = edge.getString("t");
        RID out = new RID((BasicDatabase)database, edge.getString("o"));
        RID newOut = this.ridIndex.get(out);
        RID in = new RID((BasicDatabase)database, edge.getString("i"));
        RID newIn = this.ridIndex.get(in);
        Vertex sourceVertex = (Vertex)database.lookupByRID(newOut, false);
        MutableEdge imported = sourceVertex.newEdge(edgeType, (Identifiable)newIn, true, new Object[0]);
        this.loadProperties(database, (MutableDocument)imported, properties);
        imported.save();
        context.createdEdges.incrementAndGet();
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) throws IOException {
        return new SourceSchema(this, parser.getSource(), analyzedSchema);
    }

    @Override
    public String getFormat() {
        return "JSONL";
    }

    private void loadProperties(DatabaseInternal database, MutableDocument imported, JSONObject properties) {
        Map<String, Object> json2map = this.json2map(database, properties);
        imported.fromMap(json2map);
    }

    private Map<String, Object> json2map(DatabaseInternal database, JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String k : json.keySet()) {
            Object value = this.convertFromJSONType(database, json.get(k));
            map.put(k, value);
        }
        return map;
    }

    private Object convertFromJSONType(DatabaseInternal database, Object value) {
        if (value instanceof JSONObject) {
            JSONObject json = (JSONObject)value;
            if (json.has("t")) {
                String embeddedTypeName = json.getString("t");
                DocumentType type = database.getSchema().getType(embeddedTypeName);
                if (type instanceof LocalVertexType) {
                    MutableVertex v = database.newVertex(embeddedTypeName);
                    v.fromJSON((JSONObject)value);
                    value = v;
                } else if (type != null) {
                    MutableEmbeddedDocument embeddedDocument = database.newEmbeddedDocument(null, embeddedTypeName);
                    embeddedDocument.fromJSON(((JSONObject)value).getJSONObject("p"));
                    value = embeddedDocument;
                }
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String k : json.keySet()) {
                    Object v = this.convertFromJSONType(database, json.get(k));
                    map.put(k, v);
                }
                value = map;
            }
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                list.add(this.convertFromJSONType(database, array.get(i)));
            }
            value = list;
        }
        return value;
    }
}

