/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.IndexCursor;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.FormatImporter;
import com.arcadedb.log.LogManager;
import com.arcadedb.schema.Property;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.VertexType;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class JSONImporterFormat
implements FormatImporter {
    @Override
    public void load(SourceSchema sourceSchema, AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws IOException {
        JSONObject mapping = settings.mapping != null ? new JSONObject(settings.mapping) : null;
        JsonToken waitFor = null;
        Object tagValue = null;
        try (JsonReader reader = new Gson().newJsonReader((Reader)parser.getReader());){
            while (reader.hasNext()) {
                JsonToken token = reader.peek();
                if (mapping == null) {
                    Object record = this.parseRecord(reader, settings, context, (Database)database, mapping, false);
                    if (record instanceof Map) {
                        JSONImporterFormat.saveAnonymousRecord((Database)database, settings, (Map)record);
                    }
                    return;
                }
                switch (token) {
                    case BEGIN_OBJECT: {
                        reader.beginObject();
                        break;
                    }
                    case END_OBJECT: {
                        reader.endObject();
                    }
                    case BEGIN_ARRAY: {
                        this.parseRecords(reader, (Database)database, settings, context, (JSONArray)tagValue, waitFor != token);
                        break;
                    }
                    case NAME: {
                        String tag = reader.nextName();
                        if (!mapping.has(tag) && !mapping.has("*")) break;
                        Object object = tagValue = mapping.has(tag) ? mapping.get(tag) : mapping.get("*");
                        if (tagValue instanceof JSONArray) {
                            waitFor = JsonToken.BEGIN_ARRAY;
                            break;
                        }
                        if (!(tagValue instanceof JSONObject)) break;
                        waitFor = JsonToken.BEGIN_OBJECT;
                    }
                }
            }
        }
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) {
        return new SourceSchema(this, parser.getSource(), null);
    }

    @Override
    public String getFormat() {
        return "JSON";
    }

    private void parseRecords(JsonReader reader, Database database, ImporterSettings settings, ImporterContext context, JSONArray mapping, boolean ignore) throws IOException {
        Object mappingValue;
        reader.beginArray();
        database.begin();
        Object object = mappingValue = mapping != null && !mapping.isEmpty() ? mapping.get(0) : null;
        while (reader.peek() == JsonToken.BEGIN_OBJECT) {
            JSONObject mappingObject;
            if (mappingValue instanceof JSONObject) {
                JSONObject object2;
                mappingObject = object2 = (JSONObject)mappingValue;
                ignore = false;
            } else {
                mappingObject = null;
            }
            Object record = this.parseRecord(reader, settings, context, database, mappingObject, ignore);
            if (record instanceof Map) {
                JSONImporterFormat.saveAnonymousRecord(database, settings, (Map)record);
            }
            database.commit();
            database.begin();
        }
        database.commit();
        reader.endArray();
    }

    private static MutableDocument saveAnonymousRecord(Database database, ImporterSettings settings, Map<String, Object> map) {
        database.getSchema().getOrCreateDocumentType(settings.documentTypeName);
        return database.newDocument(settings.documentTypeName).set(map).save();
    }

    private Object parseRecord(JsonReader reader, ImporterSettings settings, ImporterContext context, Database database, JSONObject mapping, boolean ignore) throws IOException {
        CascadingProperties attributes = ignore ? null : new CascadingProperties(null, new LinkedHashMap<String, Object>());
        context.parsed.incrementAndGet();
        reader.beginObject();
        block8: while (reader.peek() != JsonToken.END_OBJECT) {
            Object attributeValue;
            String attributeName = reader.nextName();
            JsonToken propertyType = reader.peek();
            switch (propertyType) {
                case STRING: {
                    attributeValue = reader.nextString();
                    break;
                }
                case NUMBER: {
                    attributeValue = reader.nextDouble();
                    break;
                }
                case BOOLEAN: {
                    attributeValue = reader.nextBoolean();
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    attributeValue = null;
                    break;
                }
                case BEGIN_OBJECT: {
                    boolean ignoreObject = ignore;
                    JSONObject mappingObject = null;
                    if (mapping != null && mapping.has(attributeName)) {
                        Object mappingValue = mapping.get(attributeName);
                        if (mappingValue instanceof JSONObject) {
                            JSONObject object;
                            mappingObject = object = (JSONObject)mappingValue;
                        } else if (mappingValue instanceof String && mappingValue.toString().equals("@ignore")) {
                            ignoreObject = true;
                        }
                    }
                    attributeValue = this.parseRecord(reader, settings, context, database, mappingObject, ignoreObject);
                    break;
                }
                case BEGIN_ARRAY: {
                    JSONArray mappingArray = mapping != null && mapping.has(attributeName) ? mapping.getJSONArray(attributeName) : null;
                    attributeValue = this.parseArray(reader, settings, context, database, mappingArray, ignore);
                    break;
                }
                default: {
                    LogManager.instance().log((Object)this, Level.WARNING, "Skipping property '%s' of type '%s'", (Object)attributeName, (Object)propertyType);
                    context.errors.incrementAndGet();
                    continue block8;
                }
            }
            if (ignore) continue;
            attributes.map.put(attributeName, attributeValue);
        }
        reader.endObject();
        if (ignore) {
            return null;
        }
        this.resolveProperties(mapping, attributes);
        Document record = this.createRecord(database, context, attributes, mapping, settings);
        if (record instanceof MutableDocument) {
            MutableDocument document = (MutableDocument)record;
            document.save();
            return record;
        }
        return attributes.map;
    }

    private void resolveProperties(JSONObject mapping, CascadingProperties attributes) {
        if (mapping == null) {
            return;
        }
        for (Map.Entry entry : mapping.toMap().entrySet()) {
            String string;
            Object value;
            if (((String)entry.getKey()).startsWith("@") || !((value = entry.getValue()) instanceof String) || !(string = (String)value).startsWith("<") || !string.endsWith(">")) continue;
            String copyFrom = string.substring(1, string.length() - 1);
            attributes.map.put((String)entry.getKey(), this.getAttribute(attributes, copyFrom));
        }
    }

    private Object getAttribute(CascadingProperties properties, String name) {
        if (properties == null) {
            return null;
        }
        if (name.startsWith("../")) {
            return this.getAttribute(properties.parent, name.substring(3));
        }
        return properties.map.get(name);
    }

    private Document createRecord(Database database, ImporterContext context, CascadingProperties attributes, JSONObject mapping, ImporterSettings settings) {
        VertexType type;
        if (mapping == null) {
            return null;
        }
        if (!mapping.has("@cat")) {
            LogManager.instance().log((Object)this, Level.WARNING, "No @cat tag defined in mapping object. The following object will be skipped %s", (Object)attributes);
            context.errors.incrementAndGet();
            return null;
        }
        if (!mapping.has("@type")) {
            LogManager.instance().log((Object)this, Level.WARNING, "No @type tag defined in mapping object. The following object will be skipped %s", (Object)attributes);
            context.errors.incrementAndGet();
            return null;
        }
        String category = mapping.getString("@cat");
        String typeName = mapping.getString("@type");
        if (typeName.startsWith("<") && typeName.endsWith(">")) {
            String tName;
            typeName = typeName.substring(1, typeName.length() - 1);
            String[] stringArray = typeName.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n && (typeName = (String)this.getAttribute(attributes, tName = stringArray[i])) == null; ++i) {
            }
        }
        if (typeName == null) {
            LogManager.instance().log((Object)this, Level.WARNING, "Type is null, skipping object %s", (Object)attributes);
            context.errors.incrementAndGet();
            return null;
        }
        switch (category) {
            case "v": {
                type = database.getSchema().getOrCreateVertexType(typeName);
                break;
            }
            case "d": {
                type = database.getSchema().getOrCreateDocumentType(typeName);
                break;
            }
            case "e": {
                return null;
            }
            default: {
                LogManager.instance().log((Object)this, Level.WARNING, "Record category '%s' not supported", (Object)category);
                context.errors.incrementAndGet();
                return null;
            }
        }
        MutableVertex record = null;
        if (mapping.has("@id")) {
            String id = mapping.getString("@id");
            Object idValue = this.getAttribute(attributes, id);
            Property prop = type.getPropertyIfExists(id);
            if (prop == null) {
                if (idValue == null) {
                    LogManager.instance().log((Object)this, Level.WARNING, "@id property not found on current record, skipping record: %s", (Object)attributes);
                    context.errors.incrementAndGet();
                    return null;
                }
                Type propType = Type.getTypeByValue((Object)idValue);
                if (mapping.has("@idType")) {
                    propType = Type.getTypeByName((String)mapping.getString("@idType").toUpperCase(Locale.ENGLISH));
                }
                prop = type.createProperty(id, propType);
            }
            prop.getOrCreateIndex(Schema.INDEX_TYPE.LSM_TREE, true);
            IndexCursor existent = database.lookupByKey(typeName, id, idValue);
            if (existent.hasNext()) {
                String strategy = mapping.optString("@strategy");
                if ("merge".equalsIgnoreCase(strategy)) {
                    record = ((Identifiable)existent.next()).asDocument().modify();
                } else {
                    return ((Identifiable)existent.next()).asDocument();
                }
            }
        }
        if (record == null) {
            switch (category) {
                case "v": {
                    record = database.newVertex(typeName);
                    context.createdVertices.incrementAndGet();
                    break;
                }
                case "d": {
                    record = database.newDocument(typeName);
                    context.createdDocuments.incrementAndGet();
                }
            }
        }
        this.applyMappingRules(database, context, (MutableDocument)record, attributes, mapping, settings);
        LinkedHashMap<String, Object> recordProperties = new LinkedHashMap<String, Object>(attributes.map);
        recordProperties.keySet().removeIf(name -> name.startsWith("@"));
        record.set(recordProperties);
        return record;
    }

    private void applyMappingRules(Database database, ImporterContext context, MutableDocument record, CascadingProperties attributes, JSONObject mapping, ImporterSettings settings) {
        this.resolveProperties(mapping, attributes);
        for (String mappingName : mapping.keySet()) {
            Object mappingValue = mapping.get(mappingName);
            Object attributeValue = this.getAttribute(attributes, mappingName);
            if (attributeValue == null) continue;
            if (mappingValue instanceof JSONObject) {
                Object result = this.convertMap(database, context, record, attributeValue, mappingValue, attributes, settings);
                if (!(result instanceof Edge)) continue;
                attributes.map.remove(mappingName);
                continue;
            }
            if (mappingValue instanceof JSONArray) {
                JSONArray array = (JSONArray)mappingValue;
                if (!(attributeValue instanceof Collection)) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Defined an array on mapping for property '%s' but found the object of class %s as attribute", (Object)mappingName, attributeValue.getClass());
                    context.errors.incrementAndGet();
                    continue;
                }
                Object subMapping = array.get(0);
                for (Object attributeArrayItem : (Collection)attributeValue) {
                    Object result = this.convertMap(database, context, record, attributeArrayItem, subMapping, attributes, settings);
                    if (!(result instanceof Edge)) continue;
                    attributes.map.remove(mappingName);
                }
                continue;
            }
            if (!(mappingValue instanceof String) || !mappingValue.toString().equals("@ignore")) continue;
            attributes.map.remove(mappingName);
        }
    }

    private List<Object> parseArray(JsonReader reader, ImporterSettings settings, ImporterContext context, Database database, JSONArray mapping, boolean ignore) throws IOException {
        ArrayList<Object> list = ignore ? null : new ArrayList<Object>();
        reader.beginArray();
        block8: while (reader.peek() != JsonToken.END_ARRAY) {
            List<Object> entryValue;
            JsonToken entryType = reader.peek();
            switch (entryType) {
                case STRING: {
                    entryValue = reader.nextString();
                    break;
                }
                case NUMBER: {
                    entryValue = reader.nextDouble();
                    break;
                }
                case BOOLEAN: {
                    entryValue = reader.nextBoolean();
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    entryValue = null;
                    break;
                }
                case BEGIN_OBJECT: {
                    JSONObject mappingObject = mapping != null && !mapping.isEmpty() ? mapping.getJSONObject(0) : null;
                    entryValue = this.parseRecord(reader, settings, context, database, mappingObject, ignore);
                    break;
                }
                case BEGIN_ARRAY: {
                    JSONArray mappingArray = mapping != null && !mapping.isEmpty() ? mapping.getJSONArray(0) : null;
                    entryValue = this.parseArray(reader, settings, context, database, mappingArray, ignore);
                    break;
                }
                default: {
                    LogManager.instance().log((Object)this, Level.WARNING, "Skipping entry of type '%s'", (Object)entryType);
                    context.errors.incrementAndGet();
                    continue block8;
                }
            }
            if (ignore) continue;
            list.add(entryValue);
        }
        reader.endArray();
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Object convertMap(Database database, ImporterContext context, MutableDocument record, Object value, Object mapping, CascadingProperties attributes, ImporterSettings settings) {
        if (mapping instanceof JSONObject) {
            String subTypeName;
            JSONObject mappingObject = (JSONObject)mapping;
            if (value instanceof Map) {
                LinkedHashMap linkedHashMap = new LinkedHashMap((Map)value);
            } else {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
            }
            String subCategory = mappingObject.has("@cat") ? mappingObject.getString("@cat") : null;
            String string = subTypeName = mappingObject.has("@type") ? mappingObject.getString("@type") : null;
            if ("e".equals(subCategory)) {
                MutableVertex destVertex;
                void var13_20;
                void var9_11;
                JSONObject destVertexMappingObject;
                if (subTypeName == null) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Cannot convert object into an edge because the edge @type is not defined");
                    context.errors.incrementAndGet();
                    return null;
                }
                if (!(record instanceof Vertex)) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Cannot convert object into an edge because the root record is not a vertex");
                    context.errors.incrementAndGet();
                    return null;
                }
                if (!mappingObject.has("@in")) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Cannot convert object into an edge because the destination vertx @in is not defined");
                    context.errors.incrementAndGet();
                    return null;
                }
                Object inValue = mappingObject.get("@in");
                if (inValue instanceof String) {
                    String inVertex = inValue.toString();
                    destVertexMappingObject = mappingObject.getJSONObject(inVertex);
                    Object v = var9_11.get(inVertex);
                } else {
                    JSONObject object;
                    if (!(inValue instanceof JSONObject)) {
                        LogManager.instance().log((Object)this, Level.WARNING, "Cannot convert object into an edge because the destination vertx @in type is not supported: " + inValue);
                        context.errors.incrementAndGet();
                        return null;
                    }
                    destVertexMappingObject = object = (JSONObject)inValue;
                    var9_11.put((String)destVertexMappingObject.get("@id"), value);
                    void var13_19 = var9_11;
                }
                if (var13_20 instanceof Document) {
                    destVertex = (MutableVertex)var13_20;
                } else {
                    if (!(var13_20 instanceof Map)) {
                        LogManager.instance().log((Object)this, Level.WARNING, "Cannot convert object " + var13_20 + " into a record");
                        context.errors.incrementAndGet();
                        return null;
                    }
                    destVertex = (MutableVertex)this.createRecord(record.getDatabase(), context, new CascadingProperties(attributes, (Map)var13_20), destVertexMappingObject, settings);
                    if (destVertex == null) {
                        LogManager.instance().log((Object)this, Level.WARNING, "Cannot convert inner map into destination vertex: %s", (Object)var13_20);
                        context.errors.incrementAndGet();
                        return null;
                    }
                }
                record.save();
                destVertex.save();
                database.getSchema().getOrCreateEdgeType(subTypeName);
                String cardinality = mappingObject.optString("@cardinality");
                if ("no-duplicates".equalsIgnoreCase(cardinality)) {
                    boolean duplicates = false;
                    Iterator connectedVertices = ((Vertex)record).getVertices(Vertex.DIRECTION.OUT, new String[]{subTypeName}).iterator();
                    while (connectedVertices.hasNext()) {
                        RID connectedVertex = ((Vertex)connectedVertices.next()).getIdentity();
                        if (!destVertex.getIdentity().equals((Object)connectedVertex)) continue;
                        duplicates = true;
                        break;
                    }
                    if (duplicates) {
                        context.skippedEdges.incrementAndGet();
                        return null;
                    }
                }
                MutableEdge edge = ((Vertex)record).newEdge(subTypeName, (Identifiable)destVertex, true, new Object[0]);
                var9_11.keySet().removeIf(name -> name.startsWith("@"));
                edge.set((Map)var9_11);
                edge.save();
                context.createdEdges.incrementAndGet();
                return edge;
            }
        }
        return null;
    }

    static class CascadingProperties {
        final CascadingProperties parent;
        final Map<String, Object> map;

        public CascadingProperties(CascadingProperties parent, Map<String, Object> map) {
            this.parent = parent;
            this.map = map;
        }
    }
}

