/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Item;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Comparator;
import java.util.HashMap;

public class DateTime {
    private static ZoneId defaultZone = ZoneId.of("UTC");
    public static final DateTimeFormatter RFC_1123_DATE_TIME_NO_TIMEZONE;
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME_SPECIAL;

    private DateTime() {
    }

    public static void setDefaultZone(ZoneId defaultZone) {
        DateTime.defaultZone = defaultZone;
    }

    public static LocalDateTime toLocalDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        return LocalDateTime.parse(dateTime, formatter);
    }

    public static ZonedDateTime toZonedDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        if (dateTime.length() == 19 || (dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTime, formatter);
            return ZonedDateTime.of(localDateTime, defaultZone);
        }
        return ZonedDateTime.parse(dateTime, formatter);
    }

    private static DateTimeFormatter getDateTimeFormatter(String dateTime) {
        if (dateTime.length() >= 20 && dateTime.length() <= 31 && dateTime.charAt(4) == '-' && dateTime.charAt(10) == 'T') {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        }
        if (dateTime.length() >= 29 && dateTime.length() <= 31) {
            return DateTimeFormatter.RFC_1123_DATE_TIME;
        }
        if ((dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            return RFC_1123_DATE_TIME_NO_TIMEZONE;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == 'T') {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == ' ') {
            return ISO_LOCAL_DATE_TIME_SPECIAL;
        }
        return null;
    }

    public static Long toEpochMilli(String dateTime) {
        ZonedDateTime zonedDateTime = DateTime.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static Comparator<Item> pubDateComparator() {
        return Comparator.comparing(i -> i.getPubDate().map(DateTime::toEpochMilli).orElse(0L));
    }

    static {
        HashMap<Long, String> dow = new HashMap<Long, String>();
        dow.put(1L, "Mon");
        dow.put(2L, "Tue");
        dow.put(3L, "Wed");
        dow.put(4L, "Thu");
        dow.put(5L, "Fri");
        dow.put(6L, "Sat");
        dow.put(7L, "Sun");
        HashMap<Long, String> moy = new HashMap<Long, String>();
        moy.put(1L, "Jan");
        moy.put(2L, "Feb");
        moy.put(3L, "Mar");
        moy.put(4L, "Apr");
        moy.put(5L, "May");
        moy.put(6L, "Jun");
        moy.put(7L, "Jul");
        moy.put(8L, "Aug");
        moy.put(9L, "Sep");
        moy.put(10L, "Oct");
        moy.put(11L, "Nov");
        moy.put(12L, "Dec");
        RFC_1123_DATE_TIME_NO_TIMEZONE = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dow).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, moy).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
        ISO_LOCAL_DATE_TIME_SPECIAL = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    }
}

