/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.backends;

import com.anthropic.backends.Backend;
import com.anthropic.core.http.HttpRequest;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B#\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/anthropic/backends/AnthropicBackend;", "Lcom/anthropic/backends/Backend;", "apiKey", "", "authToken", "baseUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "()Ljava/lang/String;", "getBaseUrl", "authorizeRequest", "Lcom/anthropic/core/http/HttpRequest;", "request", "close", "", "prepareRequest", "Builder", "Companion", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nAnthropicBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicBackend.kt\ncom/anthropic/backends/AnthropicBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class AnthropicBackend
implements Backend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String apiKey;
    @Nullable
    private final String authToken;
    @NotNull
    private final String baseUrl;
    @NotNull
    private static final String PRODUCTION_URL = "https://api.anthropic.com";
    @NotNull
    private static final String ANTHROPIC_VERSION = "2023-06-01";
    @NotNull
    private static final String ENV_API_KEY = "ANTHROPIC_API_KEY";
    @NotNull
    private static final String ENV_AUTH_TOKEN = "ANTHROPIC_AUTH_TOKEN";
    @NotNull
    private static final String HEADER_API_KEY = "X-Api-Key";
    @NotNull
    private static final String HEADER_AUTHORIZATION = "Authorization";
    @NotNull
    private static final String HEADER_VERSION = "anthropic-version";

    private AnthropicBackend(String apiKey, String authToken, String baseUrl) {
        this.apiKey = apiKey;
        this.authToken = authToken;
        this.baseUrl = baseUrl;
    }

    @JvmName(name="apiKey")
    @Nullable
    public final String apiKey() {
        return this.apiKey;
    }

    @JvmName(name="authToken")
    @Nullable
    public final String authToken() {
        return this.authToken;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @NotNull
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    @NotNull
    public HttpRequest prepareRequest(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (!(!request2.headers().names().contains(HEADER_VERSION))) {
            boolean bl = false;
            String string = "Request already prepared for Anthropic.";
            throw new IllegalArgumentException(string.toString());
        }
        return request2.toBuilder().putHeader(HEADER_VERSION, ANTHROPIC_VERSION).build();
    }

    @Override
    @NotNull
    public HttpRequest authorizeRequest(@NotNull HttpRequest request2) {
        HttpRequest.Builder builder;
        block2: {
            String it;
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            if (!(!request2.headers().names().contains(HEADER_API_KEY) && !request2.headers().names().contains(HEADER_AUTHORIZATION))) {
                boolean $i$a$-require-AnthropicBackend$authorizeRequest$22 = false;
                String $i$a$-require-AnthropicBackend$authorizeRequest$22 = "Request already authorized for Anthropic.";
                throw new IllegalArgumentException($i$a$-require-AnthropicBackend$authorizeRequest$22.toString());
            }
            HttpRequest.Builder $this$authorizeRequest_u24lambda_u244 = builder = request2.toBuilder();
            boolean bl = false;
            String string = this.apiKey;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$authorizeRequest_u24lambda_u244.putHeader(HEADER_API_KEY, it);
            }
            String string2 = this.authToken;
            if (string2 == null) break block2;
            it = string2;
            boolean bl3 = false;
            $this$authorizeRequest_u24lambda_u244.putHeader(HEADER_AUTHORIZATION, "Bearer " + it);
        }
        return builder.build();
    }

    @Override
    public void close() {
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final AnthropicBackend fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ AnthropicBackend(String apiKey, String authToken, String baseUrl, DefaultConstructorMarker $constructor_marker) {
        this(apiKey, authToken, baseUrl);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\u0005\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007J\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/backends/AnthropicBackend$Builder;", "", "()V", "apiKey", "", "authToken", "baseUrl", "Ljava/util/Optional;", "build", "Lcom/anthropic/backends/AnthropicBackend;", "fromEnv", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nAnthropicBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicBackend.kt\ncom/anthropic/backends/AnthropicBackend$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
    public static final class Builder {
        @Nullable
        private String apiKey;
        @Nullable
        private String authToken;
        @NotNull
        private String baseUrl = "https://api.anthropic.com";

        @NotNull
        public final Builder fromEnv() {
            Builder builder;
            block0: {
                String string;
                Builder $this$fromEnv_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$fromEnv_u24lambda_u241.apiKey = System.getenv(AnthropicBackend.ENV_API_KEY);
                $this$fromEnv_u24lambda_u241.authToken = System.getenv(AnthropicBackend.ENV_AUTH_TOKEN);
                String string2 = string = System.getenv("ANTHROPIC_BASE_URL");
                if (string2 == null) break block0;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(\"ANTHROPIC_BASE_URL\")");
                String it = string;
                boolean bl2 = false;
                $this$fromEnv_u24lambda_u241.baseUrl = it;
            }
            return builder;
        }

        @NotNull
        public final Builder apiKey(@Nullable String apiKey) {
            Builder builder;
            Builder $this$apiKey_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$apiKey_u24lambda_u242.apiKey = apiKey;
            return builder;
        }

        @NotNull
        public final Builder apiKey(@NotNull Optional<String> apiKey) {
            Intrinsics.checkNotNullParameter(apiKey, (String)"apiKey");
            return this.apiKey((String)apiKey.orElse(null));
        }

        @NotNull
        public final Builder authToken(@Nullable String authToken) {
            Builder builder;
            Builder $this$authToken_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$authToken_u24lambda_u243.authToken = authToken;
            return builder;
        }

        @NotNull
        public final Builder authToken(@NotNull Optional<String> authToken) {
            Intrinsics.checkNotNullParameter(authToken, (String)"authToken");
            return this.authToken((String)authToken.orElse(null));
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u244.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final AnthropicBackend build() {
            return new AnthropicBackend(this.apiKey, this.authToken, this.baseUrl, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/anthropic/backends/AnthropicBackend$Companion;", "", "()V", "ANTHROPIC_VERSION", "", "ENV_API_KEY", "ENV_AUTH_TOKEN", "HEADER_API_KEY", "HEADER_AUTHORIZATION", "HEADER_VERSION", "PRODUCTION_URL", "builder", "Lcom/anthropic/backends/AnthropicBackend$Builder;", "fromEnv", "Lcom/anthropic/backends/AnthropicBackend;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final AnthropicBackend fromEnv() {
            return this.builder().fromEnv().build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

