/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.Pair;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class GroovyGradleDetector
extends GradleDetector {
    static final Implementation IMPLEMENTATION = new Implementation(GroovyGradleDetector.class, Scope.GRADLE_SCOPE);

    public void visitBuildScript(@NonNull Context context, Map<String, Object> sharedData) {
        try {
            this.visitQuietly(context, sharedData);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void visitQuietly(final @NonNull Context context, Map<String, Object> sharedData) {
        String source = context.getContents();
        if (source == null) {
            return;
        }
        List astNodes = new AstBuilder().buildFromString(source);
        CodeVisitorSupport visitor = new CodeVisitorSupport(){

            public void visitMethodCallExpression(MethodCallExpression expression) {
                ClosureExpression closureExpression;
                Statement block;
                String parent;
                ArgumentListExpression ale;
                List expressions;
                super.visitMethodCallExpression(expression);
                Expression arguments = expression.getArguments();
                if (arguments instanceof ArgumentListExpression && (expressions = (ale = (ArgumentListExpression)arguments).getExpressions()).size() == 1 && expressions.get(0) instanceof ClosureExpression && GroovyGradleDetector.isInterestingBlock((String)(parent = expression.getMethodAsString())) && (block = (closureExpression = (ClosureExpression)expressions.get(0)).getCode()) instanceof BlockStatement) {
                    BlockStatement bs = (BlockStatement)block;
                    for (Statement statement : bs.getStatements()) {
                        ExpressionStatement e;
                        if (statement instanceof ExpressionStatement) {
                            e = (ExpressionStatement)statement;
                            if (!(e.getExpression() instanceof MethodCallExpression)) continue;
                            this.checkDslProperty(parent, (MethodCallExpression)e.getExpression());
                            continue;
                        }
                        if (!(statement instanceof ReturnStatement) || !((e = (ReturnStatement)statement).getExpression() instanceof MethodCallExpression)) continue;
                        this.checkDslProperty(parent, (MethodCallExpression)e.getExpression());
                    }
                }
            }

            private void checkDslProperty(String parent, MethodCallExpression c) {
                String property = c.getMethodAsString();
                if (GroovyGradleDetector.isInterestingProperty((String)property, (String)parent)) {
                    String value = this.getText((ASTNode)c.getArguments());
                    GroovyGradleDetector.this.checkDslPropertyAssignment(context, property, value, parent, c);
                }
            }

            private String getText(ASTNode node) {
                String source = context.getContents();
                Pair offsets = GroovyGradleDetector.getOffsets(node, context);
                return source.substring((Integer)offsets.getFirst(), (Integer)offsets.getSecond());
            }
        };
        for (ASTNode node : astNodes) {
            node.visit((GroovyCodeVisitor)visitor);
        }
    }

    @NonNull
    private static Pair<Integer, Integer> getOffsets(ASTNode node, Context context) {
        String source = context.getContents();
        assert (source != null);
        int start = 0;
        int end = source.length();
        int line = 1;
        int startLine = node.getLineNumber();
        int startColumn = node.getColumnNumber();
        int endLine = node.getLastLineNumber();
        int endColumn = node.getLastColumnNumber();
        int column = 1;
        int len = end;
        for (int index = 0; index < len; ++index) {
            if (line == startLine && column == startColumn) {
                start = index;
            }
            if (line == endLine && column == endColumn) {
                end = index;
                break;
            }
            char c = source.charAt(index);
            if (c == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return Pair.of((Object)start, (Object)end);
    }

    protected int getStartOffset(@NonNull Context context, @NonNull Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleDetector.getOffsets(node, context);
        return (Integer)offsets.getFirst();
    }

    protected Location createLocation(@NonNull Context context, @NonNull Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleDetector.getOffsets(node, context);
        int fromLine = node.getLineNumber() - 1;
        int fromColumn = node.getColumnNumber() - 1;
        int toLine = node.getLastLineNumber() - 1;
        int toColumn = node.getLastColumnNumber() - 1;
        return Location.create((File)context.file, (Position)new DefaultPosition(fromLine, fromColumn, ((Integer)offsets.getFirst()).intValue()), (Position)new DefaultPosition(toLine, toColumn, ((Integer)offsets.getSecond()).intValue()));
    }
}

