/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.NdkConfig;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class NdkConfigDsl
implements NdkConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private String moduleName;
    private String cFlags;
    private Set<String> ldLibs;
    private Set<String> abiFilters;
    private String stl;

    public NdkConfigDsl() {
    }

    public NdkConfigDsl(@NonNull NdkConfigDsl ndkConfig) {
        this.moduleName = ndkConfig.moduleName;
        this.cFlags = ndkConfig.cFlags;
        this.setLdLibs(ndkConfig.ldLibs);
        this.setAbiFilters(ndkConfig.abiFilters);
    }

    @Input
    @Optional
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Input
    @Optional
    public String getcFlags() {
        return this.cFlags;
    }

    public void setcFlags(String cFlags) {
        this.cFlags = cFlags;
    }

    @Input
    @Optional
    public Set<String> getLdLibs() {
        return this.ldLibs;
    }

    @NonNull
    public NdkConfigDsl ldLibs(String lib) {
        if (this.ldLibs == null) {
            this.ldLibs = Sets.newHashSet();
        }
        this.ldLibs.add(lib);
        return this;
    }

    @NonNull
    public NdkConfigDsl ldLibs(String ... libs) {
        if (this.ldLibs == null) {
            this.ldLibs = Sets.newHashSetWithExpectedSize((int)libs.length);
        }
        Collections.addAll(this.ldLibs, libs);
        return this;
    }

    @NonNull
    public NdkConfigDsl setLdLibs(Collection<String> libs) {
        if (libs != null) {
            if (this.abiFilters == null) {
                this.abiFilters = Sets.newHashSetWithExpectedSize((int)libs.size());
            } else {
                this.abiFilters.clear();
            }
            for (String filter : libs) {
                this.abiFilters.add(filter);
            }
        } else {
            this.abiFilters = null;
        }
        return this;
    }

    @Input
    @Optional
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @NonNull
    public NdkConfigDsl abiFilter(String filter) {
        if (this.abiFilters == null) {
            this.abiFilters = Sets.newHashSetWithExpectedSize((int)2);
        }
        this.abiFilters.add(filter);
        return this;
    }

    @NonNull
    public NdkConfigDsl abiFilters(String ... filters) {
        if (this.abiFilters == null) {
            this.abiFilters = Sets.newHashSetWithExpectedSize((int)2);
        }
        Collections.addAll(this.abiFilters, filters);
        return this;
    }

    @NonNull
    public NdkConfigDsl setAbiFilters(Collection<String> filters) {
        if (filters != null) {
            if (this.abiFilters == null) {
                this.abiFilters = Sets.newHashSetWithExpectedSize((int)filters.size());
            } else {
                this.abiFilters.clear();
            }
            for (String filter : filters) {
                this.abiFilters.add(filter);
            }
        } else {
            this.abiFilters = null;
        }
        return this;
    }

    @Nullable
    public String getStl() {
        return this.stl;
    }

    public void setStl(String stl) {
        this.stl = stl;
    }
}

