/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.dependency.ManifestDependency;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ManifestDependencyImpl
implements ManifestDependency {
    @NonNull
    private final File manifest;
    @NonNull
    private final List<ManifestDependencyImpl> dependencies;
    @NonNull
    private final String name;

    public ManifestDependencyImpl(@NonNull File manifest, @NonNull List<ManifestDependencyImpl> dependencies) {
        this.manifest = manifest;
        this.dependencies = dependencies;
        this.name = manifest.getName();
    }

    public ManifestDependencyImpl(@NonNull String name, @NonNull File manifest, @NonNull List<ManifestDependencyImpl> dependencies) {
        this.manifest = manifest;
        this.dependencies = dependencies;
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NonNull
    public File getManifest() {
        return this.manifest;
    }

    @NonNull
    public List<? extends ManifestDependency> getManifestDependencies() {
        return this.dependencies;
    }

    @NonNull
    public List<ManifestDependencyImpl> getManifestDependenciesForInput() {
        return this.dependencies;
    }

    public List<File> getAllManifests() {
        ArrayList files = Lists.newArrayListWithExpectedSize((int)(1 + this.dependencies.size() * 2));
        files.add(this.manifest);
        for (ManifestDependencyImpl manifestDep : this.dependencies) {
            files.addAll(manifestDep.getAllManifests());
        }
        return files;
    }
}

