/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesweb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspacesweb.model.CookieSynchronizationConfiguration;
import com.amazonaws.services.workspacesweb.model.EnabledType;
import com.amazonaws.services.workspacesweb.model.transform.UserSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> additionalEncryptionContext;
    private List<String> associatedPortalArns;
    private CookieSynchronizationConfiguration cookieSynchronizationConfiguration;
    private String copyAllowed;
    private String customerManagedKey;
    private String deepLinkAllowed;
    private Integer disconnectTimeoutInMinutes;
    private String downloadAllowed;
    private Integer idleDisconnectTimeoutInMinutes;
    private String pasteAllowed;
    private String printAllowed;
    private String uploadAllowed;
    private String userSettingsArn;

    public Map<String, String> getAdditionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext;
    }

    public UserSettings withAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    public UserSettings addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new HashMap<String, String>();
        }
        if (this.additionalEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalEncryptionContext.put(key, value);
        return this;
    }

    public UserSettings clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    public List<String> getAssociatedPortalArns() {
        return this.associatedPortalArns;
    }

    public void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
        if (associatedPortalArns == null) {
            this.associatedPortalArns = null;
            return;
        }
        this.associatedPortalArns = new ArrayList<String>(associatedPortalArns);
    }

    public UserSettings withAssociatedPortalArns(String ... associatedPortalArns) {
        if (this.associatedPortalArns == null) {
            this.setAssociatedPortalArns(new ArrayList<String>(associatedPortalArns.length));
        }
        for (String ele : associatedPortalArns) {
            this.associatedPortalArns.add(ele);
        }
        return this;
    }

    public UserSettings withAssociatedPortalArns(Collection<String> associatedPortalArns) {
        this.setAssociatedPortalArns(associatedPortalArns);
        return this;
    }

    public void setCookieSynchronizationConfiguration(CookieSynchronizationConfiguration cookieSynchronizationConfiguration) {
        this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration;
    }

    public CookieSynchronizationConfiguration getCookieSynchronizationConfiguration() {
        return this.cookieSynchronizationConfiguration;
    }

    public UserSettings withCookieSynchronizationConfiguration(CookieSynchronizationConfiguration cookieSynchronizationConfiguration) {
        this.setCookieSynchronizationConfiguration(cookieSynchronizationConfiguration);
        return this;
    }

    public void setCopyAllowed(String copyAllowed) {
        this.copyAllowed = copyAllowed;
    }

    public String getCopyAllowed() {
        return this.copyAllowed;
    }

    public UserSettings withCopyAllowed(String copyAllowed) {
        this.setCopyAllowed(copyAllowed);
        return this;
    }

    public UserSettings withCopyAllowed(EnabledType copyAllowed) {
        this.copyAllowed = copyAllowed.toString();
        return this;
    }

    public void setCustomerManagedKey(String customerManagedKey) {
        this.customerManagedKey = customerManagedKey;
    }

    public String getCustomerManagedKey() {
        return this.customerManagedKey;
    }

    public UserSettings withCustomerManagedKey(String customerManagedKey) {
        this.setCustomerManagedKey(customerManagedKey);
        return this;
    }

    public void setDeepLinkAllowed(String deepLinkAllowed) {
        this.deepLinkAllowed = deepLinkAllowed;
    }

    public String getDeepLinkAllowed() {
        return this.deepLinkAllowed;
    }

    public UserSettings withDeepLinkAllowed(String deepLinkAllowed) {
        this.setDeepLinkAllowed(deepLinkAllowed);
        return this;
    }

    public UserSettings withDeepLinkAllowed(EnabledType deepLinkAllowed) {
        this.deepLinkAllowed = deepLinkAllowed.toString();
        return this;
    }

    public void setDisconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
        this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
    }

    public Integer getDisconnectTimeoutInMinutes() {
        return this.disconnectTimeoutInMinutes;
    }

    public UserSettings withDisconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
        this.setDisconnectTimeoutInMinutes(disconnectTimeoutInMinutes);
        return this;
    }

    public void setDownloadAllowed(String downloadAllowed) {
        this.downloadAllowed = downloadAllowed;
    }

    public String getDownloadAllowed() {
        return this.downloadAllowed;
    }

    public UserSettings withDownloadAllowed(String downloadAllowed) {
        this.setDownloadAllowed(downloadAllowed);
        return this;
    }

    public UserSettings withDownloadAllowed(EnabledType downloadAllowed) {
        this.downloadAllowed = downloadAllowed.toString();
        return this;
    }

    public void setIdleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
        this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
    }

    public Integer getIdleDisconnectTimeoutInMinutes() {
        return this.idleDisconnectTimeoutInMinutes;
    }

    public UserSettings withIdleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
        this.setIdleDisconnectTimeoutInMinutes(idleDisconnectTimeoutInMinutes);
        return this;
    }

    public void setPasteAllowed(String pasteAllowed) {
        this.pasteAllowed = pasteAllowed;
    }

    public String getPasteAllowed() {
        return this.pasteAllowed;
    }

    public UserSettings withPasteAllowed(String pasteAllowed) {
        this.setPasteAllowed(pasteAllowed);
        return this;
    }

    public UserSettings withPasteAllowed(EnabledType pasteAllowed) {
        this.pasteAllowed = pasteAllowed.toString();
        return this;
    }

    public void setPrintAllowed(String printAllowed) {
        this.printAllowed = printAllowed;
    }

    public String getPrintAllowed() {
        return this.printAllowed;
    }

    public UserSettings withPrintAllowed(String printAllowed) {
        this.setPrintAllowed(printAllowed);
        return this;
    }

    public UserSettings withPrintAllowed(EnabledType printAllowed) {
        this.printAllowed = printAllowed.toString();
        return this;
    }

    public void setUploadAllowed(String uploadAllowed) {
        this.uploadAllowed = uploadAllowed;
    }

    public String getUploadAllowed() {
        return this.uploadAllowed;
    }

    public UserSettings withUploadAllowed(String uploadAllowed) {
        this.setUploadAllowed(uploadAllowed);
        return this;
    }

    public UserSettings withUploadAllowed(EnabledType uploadAllowed) {
        this.uploadAllowed = uploadAllowed.toString();
        return this;
    }

    public void setUserSettingsArn(String userSettingsArn) {
        this.userSettingsArn = userSettingsArn;
    }

    public String getUserSettingsArn() {
        return this.userSettingsArn;
    }

    public UserSettings withUserSettingsArn(String userSettingsArn) {
        this.setUserSettingsArn(userSettingsArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalEncryptionContext() != null) {
            sb.append("AdditionalEncryptionContext: ").append(this.getAdditionalEncryptionContext()).append(",");
        }
        if (this.getAssociatedPortalArns() != null) {
            sb.append("AssociatedPortalArns: ").append(this.getAssociatedPortalArns()).append(",");
        }
        if (this.getCookieSynchronizationConfiguration() != null) {
            sb.append("CookieSynchronizationConfiguration: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCopyAllowed() != null) {
            sb.append("CopyAllowed: ").append(this.getCopyAllowed()).append(",");
        }
        if (this.getCustomerManagedKey() != null) {
            sb.append("CustomerManagedKey: ").append(this.getCustomerManagedKey()).append(",");
        }
        if (this.getDeepLinkAllowed() != null) {
            sb.append("DeepLinkAllowed: ").append(this.getDeepLinkAllowed()).append(",");
        }
        if (this.getDisconnectTimeoutInMinutes() != null) {
            sb.append("DisconnectTimeoutInMinutes: ").append(this.getDisconnectTimeoutInMinutes()).append(",");
        }
        if (this.getDownloadAllowed() != null) {
            sb.append("DownloadAllowed: ").append(this.getDownloadAllowed()).append(",");
        }
        if (this.getIdleDisconnectTimeoutInMinutes() != null) {
            sb.append("IdleDisconnectTimeoutInMinutes: ").append(this.getIdleDisconnectTimeoutInMinutes()).append(",");
        }
        if (this.getPasteAllowed() != null) {
            sb.append("PasteAllowed: ").append(this.getPasteAllowed()).append(",");
        }
        if (this.getPrintAllowed() != null) {
            sb.append("PrintAllowed: ").append(this.getPrintAllowed()).append(",");
        }
        if (this.getUploadAllowed() != null) {
            sb.append("UploadAllowed: ").append(this.getUploadAllowed()).append(",");
        }
        if (this.getUserSettingsArn() != null) {
            sb.append("UserSettingsArn: ").append(this.getUserSettingsArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)obj;
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() != null && !other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext())) {
            return false;
        }
        if (other.getAssociatedPortalArns() == null ^ this.getAssociatedPortalArns() == null) {
            return false;
        }
        if (other.getAssociatedPortalArns() != null && !other.getAssociatedPortalArns().equals(this.getAssociatedPortalArns())) {
            return false;
        }
        if (other.getCookieSynchronizationConfiguration() == null ^ this.getCookieSynchronizationConfiguration() == null) {
            return false;
        }
        if (other.getCookieSynchronizationConfiguration() != null && !other.getCookieSynchronizationConfiguration().equals(this.getCookieSynchronizationConfiguration())) {
            return false;
        }
        if (other.getCopyAllowed() == null ^ this.getCopyAllowed() == null) {
            return false;
        }
        if (other.getCopyAllowed() != null && !other.getCopyAllowed().equals(this.getCopyAllowed())) {
            return false;
        }
        if (other.getCustomerManagedKey() == null ^ this.getCustomerManagedKey() == null) {
            return false;
        }
        if (other.getCustomerManagedKey() != null && !other.getCustomerManagedKey().equals(this.getCustomerManagedKey())) {
            return false;
        }
        if (other.getDeepLinkAllowed() == null ^ this.getDeepLinkAllowed() == null) {
            return false;
        }
        if (other.getDeepLinkAllowed() != null && !other.getDeepLinkAllowed().equals(this.getDeepLinkAllowed())) {
            return false;
        }
        if (other.getDisconnectTimeoutInMinutes() == null ^ this.getDisconnectTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getDisconnectTimeoutInMinutes() != null && !other.getDisconnectTimeoutInMinutes().equals(this.getDisconnectTimeoutInMinutes())) {
            return false;
        }
        if (other.getDownloadAllowed() == null ^ this.getDownloadAllowed() == null) {
            return false;
        }
        if (other.getDownloadAllowed() != null && !other.getDownloadAllowed().equals(this.getDownloadAllowed())) {
            return false;
        }
        if (other.getIdleDisconnectTimeoutInMinutes() == null ^ this.getIdleDisconnectTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getIdleDisconnectTimeoutInMinutes() != null && !other.getIdleDisconnectTimeoutInMinutes().equals(this.getIdleDisconnectTimeoutInMinutes())) {
            return false;
        }
        if (other.getPasteAllowed() == null ^ this.getPasteAllowed() == null) {
            return false;
        }
        if (other.getPasteAllowed() != null && !other.getPasteAllowed().equals(this.getPasteAllowed())) {
            return false;
        }
        if (other.getPrintAllowed() == null ^ this.getPrintAllowed() == null) {
            return false;
        }
        if (other.getPrintAllowed() != null && !other.getPrintAllowed().equals(this.getPrintAllowed())) {
            return false;
        }
        if (other.getUploadAllowed() == null ^ this.getUploadAllowed() == null) {
            return false;
        }
        if (other.getUploadAllowed() != null && !other.getUploadAllowed().equals(this.getUploadAllowed())) {
            return false;
        }
        if (other.getUserSettingsArn() == null ^ this.getUserSettingsArn() == null) {
            return false;
        }
        return other.getUserSettingsArn() == null || other.getUserSettingsArn().equals(this.getUserSettingsArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdditionalEncryptionContext() == null ? 0 : this.getAdditionalEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedPortalArns() == null ? 0 : this.getAssociatedPortalArns().hashCode());
        hashCode = 31 * hashCode + (this.getCookieSynchronizationConfiguration() == null ? 0 : this.getCookieSynchronizationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCopyAllowed() == null ? 0 : this.getCopyAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerManagedKey() == null ? 0 : this.getCustomerManagedKey().hashCode());
        hashCode = 31 * hashCode + (this.getDeepLinkAllowed() == null ? 0 : this.getDeepLinkAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getDisconnectTimeoutInMinutes() == null ? 0 : this.getDisconnectTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getDownloadAllowed() == null ? 0 : this.getDownloadAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getIdleDisconnectTimeoutInMinutes() == null ? 0 : this.getIdleDisconnectTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getPasteAllowed() == null ? 0 : this.getPasteAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getPrintAllowed() == null ? 0 : this.getPrintAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getUploadAllowed() == null ? 0 : this.getUploadAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getUserSettingsArn() == null ? 0 : this.getUserSettingsArn().hashCode());
        return hashCode;
    }

    public UserSettings clone() {
        try {
            return (UserSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

