/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesweb.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTrustStoreRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<ByteBuffer> certificatesToAdd;
    private List<String> certificatesToDelete;
    private String clientToken;
    private String trustStoreArn;

    public List<ByteBuffer> getCertificatesToAdd() {
        return this.certificatesToAdd;
    }

    public void setCertificatesToAdd(Collection<ByteBuffer> certificatesToAdd) {
        if (certificatesToAdd == null) {
            this.certificatesToAdd = null;
            return;
        }
        this.certificatesToAdd = new ArrayList<ByteBuffer>(certificatesToAdd);
    }

    public UpdateTrustStoreRequest withCertificatesToAdd(ByteBuffer ... certificatesToAdd) {
        if (this.certificatesToAdd == null) {
            this.setCertificatesToAdd(new ArrayList<ByteBuffer>(certificatesToAdd.length));
        }
        for (ByteBuffer ele : certificatesToAdd) {
            this.certificatesToAdd.add(ele);
        }
        return this;
    }

    public UpdateTrustStoreRequest withCertificatesToAdd(Collection<ByteBuffer> certificatesToAdd) {
        this.setCertificatesToAdd(certificatesToAdd);
        return this;
    }

    public List<String> getCertificatesToDelete() {
        return this.certificatesToDelete;
    }

    public void setCertificatesToDelete(Collection<String> certificatesToDelete) {
        if (certificatesToDelete == null) {
            this.certificatesToDelete = null;
            return;
        }
        this.certificatesToDelete = new ArrayList<String>(certificatesToDelete);
    }

    public UpdateTrustStoreRequest withCertificatesToDelete(String ... certificatesToDelete) {
        if (this.certificatesToDelete == null) {
            this.setCertificatesToDelete(new ArrayList<String>(certificatesToDelete.length));
        }
        for (String ele : certificatesToDelete) {
            this.certificatesToDelete.add(ele);
        }
        return this;
    }

    public UpdateTrustStoreRequest withCertificatesToDelete(Collection<String> certificatesToDelete) {
        this.setCertificatesToDelete(certificatesToDelete);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateTrustStoreRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setTrustStoreArn(String trustStoreArn) {
        this.trustStoreArn = trustStoreArn;
    }

    public String getTrustStoreArn() {
        return this.trustStoreArn;
    }

    public UpdateTrustStoreRequest withTrustStoreArn(String trustStoreArn) {
        this.setTrustStoreArn(trustStoreArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificatesToAdd() != null) {
            sb.append("CertificatesToAdd: ").append(this.getCertificatesToAdd()).append(",");
        }
        if (this.getCertificatesToDelete() != null) {
            sb.append("CertificatesToDelete: ").append(this.getCertificatesToDelete()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTrustStoreArn() != null) {
            sb.append("TrustStoreArn: ").append(this.getTrustStoreArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustStoreRequest)) {
            return false;
        }
        UpdateTrustStoreRequest other = (UpdateTrustStoreRequest)obj;
        if (other.getCertificatesToAdd() == null ^ this.getCertificatesToAdd() == null) {
            return false;
        }
        if (other.getCertificatesToAdd() != null && !other.getCertificatesToAdd().equals(this.getCertificatesToAdd())) {
            return false;
        }
        if (other.getCertificatesToDelete() == null ^ this.getCertificatesToDelete() == null) {
            return false;
        }
        if (other.getCertificatesToDelete() != null && !other.getCertificatesToDelete().equals(this.getCertificatesToDelete())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTrustStoreArn() == null ^ this.getTrustStoreArn() == null) {
            return false;
        }
        return other.getTrustStoreArn() == null || other.getTrustStoreArn().equals(this.getTrustStoreArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificatesToAdd() == null ? 0 : this.getCertificatesToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getCertificatesToDelete() == null ? 0 : this.getCertificatesToDelete().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTrustStoreArn() == null ? 0 : this.getTrustStoreArn().hashCode());
        return hashCode;
    }

    public UpdateTrustStoreRequest clone() {
        return (UpdateTrustStoreRequest)super.clone();
    }
}

