/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesthinclient.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.workspacesthinclient.model.Device;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class DeviceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> SERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serialNumber").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("model").build();
    private static final MarshallingInfo<String> ENVIRONMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> CURRENTSOFTWARESETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentSoftwareSetId").build();
    private static final MarshallingInfo<String> CURRENTSOFTWARESETVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentSoftwareSetVersion").build();
    private static final MarshallingInfo<String> DESIREDSOFTWARESETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredSoftwareSetId").build();
    private static final MarshallingInfo<String> PENDINGSOFTWARESETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pendingSoftwareSetId").build();
    private static final MarshallingInfo<String> PENDINGSOFTWARESETVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pendingSoftwareSetVersion").build();
    private static final MarshallingInfo<String> SOFTWARESETUPDATESCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softwareSetUpdateSchedule").build();
    private static final MarshallingInfo<String> SOFTWARESETCOMPLIANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softwareSetComplianceStatus").build();
    private static final MarshallingInfo<String> SOFTWARESETUPDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softwareSetUpdateStatus").build();
    private static final MarshallingInfo<Date> LASTCONNECTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastConnectedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTPOSTUREAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastPostureAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyArn").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final DeviceMarshaller instance = new DeviceMarshaller();

    public static DeviceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Device device, ProtocolMarshaller protocolMarshaller) {
        if (device == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)device.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)device.getSerialNumber(), SERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)device.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)device.getModel(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)device.getEnvironmentId(), ENVIRONMENTID_BINDING);
            protocolMarshaller.marshall((Object)device.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)device.getCurrentSoftwareSetId(), CURRENTSOFTWARESETID_BINDING);
            protocolMarshaller.marshall((Object)device.getCurrentSoftwareSetVersion(), CURRENTSOFTWARESETVERSION_BINDING);
            protocolMarshaller.marshall((Object)device.getDesiredSoftwareSetId(), DESIREDSOFTWARESETID_BINDING);
            protocolMarshaller.marshall((Object)device.getPendingSoftwareSetId(), PENDINGSOFTWARESETID_BINDING);
            protocolMarshaller.marshall((Object)device.getPendingSoftwareSetVersion(), PENDINGSOFTWARESETVERSION_BINDING);
            protocolMarshaller.marshall((Object)device.getSoftwareSetUpdateSchedule(), SOFTWARESETUPDATESCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)device.getSoftwareSetComplianceStatus(), SOFTWARESETCOMPLIANCESTATUS_BINDING);
            protocolMarshaller.marshall((Object)device.getSoftwareSetUpdateStatus(), SOFTWARESETUPDATESTATUS_BINDING);
            protocolMarshaller.marshall((Object)device.getLastConnectedAt(), LASTCONNECTEDAT_BINDING);
            protocolMarshaller.marshall((Object)device.getLastPostureAt(), LASTPOSTUREAT_BINDING);
            protocolMarshaller.marshall((Object)device.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)device.getUpdatedAt(), UPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)device.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)device.getKmsKeyArn(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall(device.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

