/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.Compute;
import com.amazonaws.services.workspaces.model.OperatingSystemName;
import com.amazonaws.services.workspaces.model.WorkSpaceApplicationLicenseType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeApplicationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> applicationIds;
    private SdkInternalList<String> computeTypeNames;
    private String licenseType;
    private SdkInternalList<String> operatingSystemNames;
    private String owner;
    private Integer maxResults;
    private String nextToken;

    public List<String> getApplicationIds() {
        if (this.applicationIds == null) {
            this.applicationIds = new SdkInternalList();
        }
        return this.applicationIds;
    }

    public void setApplicationIds(Collection<String> applicationIds) {
        if (applicationIds == null) {
            this.applicationIds = null;
            return;
        }
        this.applicationIds = new SdkInternalList(applicationIds);
    }

    public DescribeApplicationsRequest withApplicationIds(String ... applicationIds) {
        if (this.applicationIds == null) {
            this.setApplicationIds((Collection<String>)new SdkInternalList(applicationIds.length));
        }
        for (String ele : applicationIds) {
            this.applicationIds.add((Object)ele);
        }
        return this;
    }

    public DescribeApplicationsRequest withApplicationIds(Collection<String> applicationIds) {
        this.setApplicationIds(applicationIds);
        return this;
    }

    public List<String> getComputeTypeNames() {
        if (this.computeTypeNames == null) {
            this.computeTypeNames = new SdkInternalList();
        }
        return this.computeTypeNames;
    }

    public void setComputeTypeNames(Collection<String> computeTypeNames) {
        if (computeTypeNames == null) {
            this.computeTypeNames = null;
            return;
        }
        this.computeTypeNames = new SdkInternalList(computeTypeNames);
    }

    public DescribeApplicationsRequest withComputeTypeNames(String ... computeTypeNames) {
        if (this.computeTypeNames == null) {
            this.setComputeTypeNames((Collection<String>)new SdkInternalList(computeTypeNames.length));
        }
        for (String ele : computeTypeNames) {
            this.computeTypeNames.add((Object)ele);
        }
        return this;
    }

    public DescribeApplicationsRequest withComputeTypeNames(Collection<String> computeTypeNames) {
        this.setComputeTypeNames(computeTypeNames);
        return this;
    }

    public DescribeApplicationsRequest withComputeTypeNames(Compute ... computeTypeNames) {
        SdkInternalList computeTypeNamesCopy = new SdkInternalList(computeTypeNames.length);
        for (Compute value : computeTypeNames) {
            computeTypeNamesCopy.add((Object)value.toString());
        }
        if (this.getComputeTypeNames() == null) {
            this.setComputeTypeNames((Collection<String>)computeTypeNamesCopy);
        } else {
            this.getComputeTypeNames().addAll((Collection<String>)computeTypeNamesCopy);
        }
        return this;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public DescribeApplicationsRequest withLicenseType(String licenseType) {
        this.setLicenseType(licenseType);
        return this;
    }

    public DescribeApplicationsRequest withLicenseType(WorkSpaceApplicationLicenseType licenseType) {
        this.licenseType = licenseType.toString();
        return this;
    }

    public List<String> getOperatingSystemNames() {
        if (this.operatingSystemNames == null) {
            this.operatingSystemNames = new SdkInternalList();
        }
        return this.operatingSystemNames;
    }

    public void setOperatingSystemNames(Collection<String> operatingSystemNames) {
        if (operatingSystemNames == null) {
            this.operatingSystemNames = null;
            return;
        }
        this.operatingSystemNames = new SdkInternalList(operatingSystemNames);
    }

    public DescribeApplicationsRequest withOperatingSystemNames(String ... operatingSystemNames) {
        if (this.operatingSystemNames == null) {
            this.setOperatingSystemNames((Collection<String>)new SdkInternalList(operatingSystemNames.length));
        }
        for (String ele : operatingSystemNames) {
            this.operatingSystemNames.add((Object)ele);
        }
        return this;
    }

    public DescribeApplicationsRequest withOperatingSystemNames(Collection<String> operatingSystemNames) {
        this.setOperatingSystemNames(operatingSystemNames);
        return this;
    }

    public DescribeApplicationsRequest withOperatingSystemNames(OperatingSystemName ... operatingSystemNames) {
        SdkInternalList operatingSystemNamesCopy = new SdkInternalList(operatingSystemNames.length);
        for (OperatingSystemName value : operatingSystemNames) {
            operatingSystemNamesCopy.add((Object)value.toString());
        }
        if (this.getOperatingSystemNames() == null) {
            this.setOperatingSystemNames((Collection<String>)operatingSystemNamesCopy);
        } else {
            this.getOperatingSystemNames().addAll((Collection<String>)operatingSystemNamesCopy);
        }
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public DescribeApplicationsRequest withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeApplicationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeApplicationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationIds() != null) {
            sb.append("ApplicationIds: ").append(this.getApplicationIds()).append(",");
        }
        if (this.getComputeTypeNames() != null) {
            sb.append("ComputeTypeNames: ").append(this.getComputeTypeNames()).append(",");
        }
        if (this.getLicenseType() != null) {
            sb.append("LicenseType: ").append(this.getLicenseType()).append(",");
        }
        if (this.getOperatingSystemNames() != null) {
            sb.append("OperatingSystemNames: ").append(this.getOperatingSystemNames()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsRequest)) {
            return false;
        }
        DescribeApplicationsRequest other = (DescribeApplicationsRequest)obj;
        if (other.getApplicationIds() == null ^ this.getApplicationIds() == null) {
            return false;
        }
        if (other.getApplicationIds() != null && !other.getApplicationIds().equals(this.getApplicationIds())) {
            return false;
        }
        if (other.getComputeTypeNames() == null ^ this.getComputeTypeNames() == null) {
            return false;
        }
        if (other.getComputeTypeNames() != null && !other.getComputeTypeNames().equals(this.getComputeTypeNames())) {
            return false;
        }
        if (other.getLicenseType() == null ^ this.getLicenseType() == null) {
            return false;
        }
        if (other.getLicenseType() != null && !other.getLicenseType().equals(this.getLicenseType())) {
            return false;
        }
        if (other.getOperatingSystemNames() == null ^ this.getOperatingSystemNames() == null) {
            return false;
        }
        if (other.getOperatingSystemNames() != null && !other.getOperatingSystemNames().equals(this.getOperatingSystemNames())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationIds() == null ? 0 : this.getApplicationIds().hashCode());
        hashCode = 31 * hashCode + (this.getComputeTypeNames() == null ? 0 : this.getComputeTypeNames().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseType() == null ? 0 : this.getLicenseType().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystemNames() == null ? 0 : this.getOperatingSystemNames().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeApplicationsRequest clone() {
        return (DescribeApplicationsRequest)super.clone();
    }
}

