/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workmail.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMailboxDetailsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier for the organization that contains the user whose mailbox details are being requested.
     * </p>
     */
    private String organizationId;
    /**
     * <p>
     * The identifier for the user whose mailbox details are being requested.
     * </p>
     * <p>
     * The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: user@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: user
     * </p>
     * </li>
     * </ul>
     */
    private String userId;

    /**
     * <p>
     * The identifier for the organization that contains the user whose mailbox details are being requested.
     * </p>
     * 
     * @param organizationId
     *        The identifier for the organization that contains the user whose mailbox details are being requested.
     */

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * <p>
     * The identifier for the organization that contains the user whose mailbox details are being requested.
     * </p>
     * 
     * @return The identifier for the organization that contains the user whose mailbox details are being requested.
     */

    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * <p>
     * The identifier for the organization that contains the user whose mailbox details are being requested.
     * </p>
     * 
     * @param organizationId
     *        The identifier for the organization that contains the user whose mailbox details are being requested.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMailboxDetailsRequest withOrganizationId(String organizationId) {
        setOrganizationId(organizationId);
        return this;
    }

    /**
     * <p>
     * The identifier for the user whose mailbox details are being requested.
     * </p>
     * <p>
     * The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: user@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: user
     * </p>
     * </li>
     * </ul>
     * 
     * @param userId
     *        The identifier for the user whose mailbox details are being requested.</p>
     *        <p>
     *        The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats
     *        are available:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Email address: user@domain.tld
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        User name: user
     *        </p>
     *        </li>
     */

    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * <p>
     * The identifier for the user whose mailbox details are being requested.
     * </p>
     * <p>
     * The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: user@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: user
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the user whose mailbox details are being requested.</p>
     *         <p>
     *         The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats
     *         are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: user@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         User name: user
     *         </p>
     *         </li>
     */

    public String getUserId() {
        return this.userId;
    }

    /**
     * <p>
     * The identifier for the user whose mailbox details are being requested.
     * </p>
     * <p>
     * The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: user@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: user
     * </p>
     * </li>
     * </ul>
     * 
     * @param userId
     *        The identifier for the user whose mailbox details are being requested.</p>
     *        <p>
     *        The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats
     *        are available:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Email address: user@domain.tld
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        User name: user
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMailboxDetailsRequest withUserId(String userId) {
        setUserId(userId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOrganizationId() != null)
            sb.append("OrganizationId: ").append(getOrganizationId()).append(",");
        if (getUserId() != null)
            sb.append("UserId: ").append(getUserId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMailboxDetailsRequest == false)
            return false;
        GetMailboxDetailsRequest other = (GetMailboxDetailsRequest) obj;
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null)
            return false;
        if (other.getOrganizationId() != null && other.getOrganizationId().equals(this.getOrganizationId()) == false)
            return false;
        if (other.getUserId() == null ^ this.getUserId() == null)
            return false;
        if (other.getUserId() != null && other.getUserId().equals(this.getUserId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOrganizationId() == null) ? 0 : getOrganizationId().hashCode());
        hashCode = prime * hashCode + ((getUserId() == null) ? 0 : getUserId().hashCode());
        return hashCode;
    }

    @Override
    public GetMailboxDetailsRequest clone() {
        return (GetMailboxDetailsRequest) super.clone();
    }

}
