/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workdocs.model.transform.UploadMetadataMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UploadMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String uploadUrl;
    private Map<String, String> signedHeaders;

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public UploadMetadata withUploadUrl(String uploadUrl) {
        this.setUploadUrl(uploadUrl);
        return this;
    }

    public Map<String, String> getSignedHeaders() {
        return this.signedHeaders;
    }

    public void setSignedHeaders(Map<String, String> signedHeaders) {
        this.signedHeaders = signedHeaders;
    }

    public UploadMetadata withSignedHeaders(Map<String, String> signedHeaders) {
        this.setSignedHeaders(signedHeaders);
        return this;
    }

    public UploadMetadata addSignedHeadersEntry(String key, String value) {
        if (null == this.signedHeaders) {
            this.signedHeaders = new HashMap<String, String>();
        }
        if (this.signedHeaders.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.signedHeaders.put(key, value);
        return this;
    }

    public UploadMetadata clearSignedHeadersEntries() {
        this.signedHeaders = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUploadUrl() != null) {
            sb.append("UploadUrl: ").append(this.getUploadUrl()).append(",");
        }
        if (this.getSignedHeaders() != null) {
            sb.append("SignedHeaders: ").append(this.getSignedHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata)obj;
        if (other.getUploadUrl() == null ^ this.getUploadUrl() == null) {
            return false;
        }
        if (other.getUploadUrl() != null && !other.getUploadUrl().equals(this.getUploadUrl())) {
            return false;
        }
        if (other.getSignedHeaders() == null ^ this.getSignedHeaders() == null) {
            return false;
        }
        return other.getSignedHeaders() == null || other.getSignedHeaders().equals(this.getSignedHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUploadUrl() == null ? 0 : this.getUploadUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSignedHeaders() == null ? 0 : this.getSignedHeaders().hashCode());
        return hashCode;
    }

    public UploadMetadata clone() {
        try {
            return (UploadMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

