/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.workdocs.model.DocumentMetadata;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GetDocumentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private DocumentMetadata metadata;
    private Map<String, String> customMetadata;

    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    public GetDocumentResult withMetadata(DocumentMetadata metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public GetDocumentResult withCustomMetadata(Map<String, String> customMetadata) {
        this.setCustomMetadata(customMetadata);
        return this;
    }

    public GetDocumentResult addCustomMetadataEntry(String key, String value) {
        if (null == this.customMetadata) {
            this.customMetadata = new HashMap<String, String>();
        }
        if (this.customMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customMetadata.put(key, value);
        return this;
    }

    public GetDocumentResult clearCustomMetadataEntries() {
        this.customMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getCustomMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.getCustomMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentResult)) {
            return false;
        }
        GetDocumentResult other = (GetDocumentResult)obj;
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getCustomMetadata() == null ^ this.getCustomMetadata() == null) {
            return false;
        }
        return other.getCustomMetadata() == null || other.getCustomMetadata().equals(this.getCustomMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getCustomMetadata() == null ? 0 : this.getCustomMetadata().hashCode());
        return hashCode;
    }

    public GetDocumentResult clone() {
        try {
            return (GetDocumentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

