/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wellarchitected.model.ProfileQuestionUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String profileName;
    private String profileDescription;
    private List<ProfileQuestionUpdate> profileQuestions;
    private String clientRequestToken;
    private Map<String, String> tags;

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public CreateProfileRequest withProfileName(String profileName) {
        this.setProfileName(profileName);
        return this;
    }

    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    public String getProfileDescription() {
        return this.profileDescription;
    }

    public CreateProfileRequest withProfileDescription(String profileDescription) {
        this.setProfileDescription(profileDescription);
        return this;
    }

    public List<ProfileQuestionUpdate> getProfileQuestions() {
        return this.profileQuestions;
    }

    public void setProfileQuestions(Collection<ProfileQuestionUpdate> profileQuestions) {
        if (profileQuestions == null) {
            this.profileQuestions = null;
            return;
        }
        this.profileQuestions = new ArrayList<ProfileQuestionUpdate>(profileQuestions);
    }

    public CreateProfileRequest withProfileQuestions(ProfileQuestionUpdate ... profileQuestions) {
        if (this.profileQuestions == null) {
            this.setProfileQuestions(new ArrayList<ProfileQuestionUpdate>(profileQuestions.length));
        }
        for (ProfileQuestionUpdate ele : profileQuestions) {
            this.profileQuestions.add(ele);
        }
        return this;
    }

    public CreateProfileRequest withProfileQuestions(Collection<ProfileQuestionUpdate> profileQuestions) {
        this.setProfileQuestions(profileQuestions);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateProfileRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateProfileRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateProfileRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateProfileRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfileName() != null) {
            sb.append("ProfileName: ").append(this.getProfileName()).append(",");
        }
        if (this.getProfileDescription() != null) {
            sb.append("ProfileDescription: ").append(this.getProfileDescription()).append(",");
        }
        if (this.getProfileQuestions() != null) {
            sb.append("ProfileQuestions: ").append(this.getProfileQuestions()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)obj;
        if (other.getProfileName() == null ^ this.getProfileName() == null) {
            return false;
        }
        if (other.getProfileName() != null && !other.getProfileName().equals(this.getProfileName())) {
            return false;
        }
        if (other.getProfileDescription() == null ^ this.getProfileDescription() == null) {
            return false;
        }
        if (other.getProfileDescription() != null && !other.getProfileDescription().equals(this.getProfileDescription())) {
            return false;
        }
        if (other.getProfileQuestions() == null ^ this.getProfileQuestions() == null) {
            return false;
        }
        if (other.getProfileQuestions() != null && !other.getProfileQuestions().equals(this.getProfileQuestions())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfileName() == null ? 0 : this.getProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getProfileDescription() == null ? 0 : this.getProfileDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProfileQuestions() == null ? 0 : this.getProfileQuestions().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateProfileRequest clone() {
        return (CreateProfileRequest)super.clone();
    }
}

