/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.WorkloadEnvironment;
import com.amazonaws.services.wellarchitected.model.WorkloadImprovementStatus;
import com.amazonaws.services.wellarchitected.model.transform.WorkloadMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Workload
implements Serializable,
Cloneable,
StructuredPojo {
    private String workloadId;
    private String workloadArn;
    private String workloadName;
    private String description;
    private String environment;
    private Date updatedAt;
    private List<String> accountIds;
    private List<String> awsRegions;
    private List<String> nonAwsRegions;
    private String architecturalDesign;
    private String reviewOwner;
    private Date reviewRestrictionDate;
    private Boolean isReviewOwnerUpdateAcknowledged;
    private String industryType;
    private String industry;
    private String notes;
    private String improvementStatus;
    private Map<String, Integer> riskCounts;
    private List<String> pillarPriorities;
    private List<String> lenses;
    private String owner;
    private String shareInvitationId;
    private Map<String, String> tags;

    public void setWorkloadId(String workloadId) {
        this.workloadId = workloadId;
    }

    public String getWorkloadId() {
        return this.workloadId;
    }

    public Workload withWorkloadId(String workloadId) {
        this.setWorkloadId(workloadId);
        return this;
    }

    public void setWorkloadArn(String workloadArn) {
        this.workloadArn = workloadArn;
    }

    public String getWorkloadArn() {
        return this.workloadArn;
    }

    public Workload withWorkloadArn(String workloadArn) {
        this.setWorkloadArn(workloadArn);
        return this;
    }

    public void setWorkloadName(String workloadName) {
        this.workloadName = workloadName;
    }

    public String getWorkloadName() {
        return this.workloadName;
    }

    public Workload withWorkloadName(String workloadName) {
        this.setWorkloadName(workloadName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Workload withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Workload withEnvironment(String environment) {
        this.setEnvironment(environment);
        return this;
    }

    public Workload withEnvironment(WorkloadEnvironment environment) {
        this.environment = environment.toString();
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Workload withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public Workload withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public Workload withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public List<String> getAwsRegions() {
        return this.awsRegions;
    }

    public void setAwsRegions(Collection<String> awsRegions) {
        if (awsRegions == null) {
            this.awsRegions = null;
            return;
        }
        this.awsRegions = new ArrayList<String>(awsRegions);
    }

    public Workload withAwsRegions(String ... awsRegions) {
        if (this.awsRegions == null) {
            this.setAwsRegions(new ArrayList<String>(awsRegions.length));
        }
        for (String ele : awsRegions) {
            this.awsRegions.add(ele);
        }
        return this;
    }

    public Workload withAwsRegions(Collection<String> awsRegions) {
        this.setAwsRegions(awsRegions);
        return this;
    }

    public List<String> getNonAwsRegions() {
        return this.nonAwsRegions;
    }

    public void setNonAwsRegions(Collection<String> nonAwsRegions) {
        if (nonAwsRegions == null) {
            this.nonAwsRegions = null;
            return;
        }
        this.nonAwsRegions = new ArrayList<String>(nonAwsRegions);
    }

    public Workload withNonAwsRegions(String ... nonAwsRegions) {
        if (this.nonAwsRegions == null) {
            this.setNonAwsRegions(new ArrayList<String>(nonAwsRegions.length));
        }
        for (String ele : nonAwsRegions) {
            this.nonAwsRegions.add(ele);
        }
        return this;
    }

    public Workload withNonAwsRegions(Collection<String> nonAwsRegions) {
        this.setNonAwsRegions(nonAwsRegions);
        return this;
    }

    public void setArchitecturalDesign(String architecturalDesign) {
        this.architecturalDesign = architecturalDesign;
    }

    public String getArchitecturalDesign() {
        return this.architecturalDesign;
    }

    public Workload withArchitecturalDesign(String architecturalDesign) {
        this.setArchitecturalDesign(architecturalDesign);
        return this;
    }

    public void setReviewOwner(String reviewOwner) {
        this.reviewOwner = reviewOwner;
    }

    public String getReviewOwner() {
        return this.reviewOwner;
    }

    public Workload withReviewOwner(String reviewOwner) {
        this.setReviewOwner(reviewOwner);
        return this;
    }

    public void setReviewRestrictionDate(Date reviewRestrictionDate) {
        this.reviewRestrictionDate = reviewRestrictionDate;
    }

    public Date getReviewRestrictionDate() {
        return this.reviewRestrictionDate;
    }

    public Workload withReviewRestrictionDate(Date reviewRestrictionDate) {
        this.setReviewRestrictionDate(reviewRestrictionDate);
        return this;
    }

    public void setIsReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
        this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
    }

    public Boolean getIsReviewOwnerUpdateAcknowledged() {
        return this.isReviewOwnerUpdateAcknowledged;
    }

    public Workload withIsReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
        this.setIsReviewOwnerUpdateAcknowledged(isReviewOwnerUpdateAcknowledged);
        return this;
    }

    public Boolean isReviewOwnerUpdateAcknowledged() {
        return this.isReviewOwnerUpdateAcknowledged;
    }

    public void setIndustryType(String industryType) {
        this.industryType = industryType;
    }

    public String getIndustryType() {
        return this.industryType;
    }

    public Workload withIndustryType(String industryType) {
        this.setIndustryType(industryType);
        return this;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getIndustry() {
        return this.industry;
    }

    public Workload withIndustry(String industry) {
        this.setIndustry(industry);
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public Workload withNotes(String notes) {
        this.setNotes(notes);
        return this;
    }

    public void setImprovementStatus(String improvementStatus) {
        this.improvementStatus = improvementStatus;
    }

    public String getImprovementStatus() {
        return this.improvementStatus;
    }

    public Workload withImprovementStatus(String improvementStatus) {
        this.setImprovementStatus(improvementStatus);
        return this;
    }

    public Workload withImprovementStatus(WorkloadImprovementStatus improvementStatus) {
        this.improvementStatus = improvementStatus.toString();
        return this;
    }

    public Map<String, Integer> getRiskCounts() {
        return this.riskCounts;
    }

    public void setRiskCounts(Map<String, Integer> riskCounts) {
        this.riskCounts = riskCounts;
    }

    public Workload withRiskCounts(Map<String, Integer> riskCounts) {
        this.setRiskCounts(riskCounts);
        return this;
    }

    public Workload addRiskCountsEntry(String key, Integer value) {
        if (null == this.riskCounts) {
            this.riskCounts = new HashMap<String, Integer>();
        }
        if (this.riskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.riskCounts.put(key, value);
        return this;
    }

    public Workload clearRiskCountsEntries() {
        this.riskCounts = null;
        return this;
    }

    public List<String> getPillarPriorities() {
        return this.pillarPriorities;
    }

    public void setPillarPriorities(Collection<String> pillarPriorities) {
        if (pillarPriorities == null) {
            this.pillarPriorities = null;
            return;
        }
        this.pillarPriorities = new ArrayList<String>(pillarPriorities);
    }

    public Workload withPillarPriorities(String ... pillarPriorities) {
        if (this.pillarPriorities == null) {
            this.setPillarPriorities(new ArrayList<String>(pillarPriorities.length));
        }
        for (String ele : pillarPriorities) {
            this.pillarPriorities.add(ele);
        }
        return this;
    }

    public Workload withPillarPriorities(Collection<String> pillarPriorities) {
        this.setPillarPriorities(pillarPriorities);
        return this;
    }

    public List<String> getLenses() {
        return this.lenses;
    }

    public void setLenses(Collection<String> lenses) {
        if (lenses == null) {
            this.lenses = null;
            return;
        }
        this.lenses = new ArrayList<String>(lenses);
    }

    public Workload withLenses(String ... lenses) {
        if (this.lenses == null) {
            this.setLenses(new ArrayList<String>(lenses.length));
        }
        for (String ele : lenses) {
            this.lenses.add(ele);
        }
        return this;
    }

    public Workload withLenses(Collection<String> lenses) {
        this.setLenses(lenses);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public Workload withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setShareInvitationId(String shareInvitationId) {
        this.shareInvitationId = shareInvitationId;
    }

    public String getShareInvitationId() {
        return this.shareInvitationId;
    }

    public Workload withShareInvitationId(String shareInvitationId) {
        this.setShareInvitationId(shareInvitationId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Workload withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Workload addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Workload clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkloadId() != null) {
            sb.append("WorkloadId: ").append(this.getWorkloadId()).append(",");
        }
        if (this.getWorkloadArn() != null) {
            sb.append("WorkloadArn: ").append(this.getWorkloadArn()).append(",");
        }
        if (this.getWorkloadName() != null) {
            sb.append("WorkloadName: ").append(this.getWorkloadName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt()).append(",");
        }
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getAwsRegions() != null) {
            sb.append("AwsRegions: ").append(this.getAwsRegions()).append(",");
        }
        if (this.getNonAwsRegions() != null) {
            sb.append("NonAwsRegions: ").append(this.getNonAwsRegions()).append(",");
        }
        if (this.getArchitecturalDesign() != null) {
            sb.append("ArchitecturalDesign: ").append(this.getArchitecturalDesign()).append(",");
        }
        if (this.getReviewOwner() != null) {
            sb.append("ReviewOwner: ").append(this.getReviewOwner()).append(",");
        }
        if (this.getReviewRestrictionDate() != null) {
            sb.append("ReviewRestrictionDate: ").append(this.getReviewRestrictionDate()).append(",");
        }
        if (this.getIsReviewOwnerUpdateAcknowledged() != null) {
            sb.append("IsReviewOwnerUpdateAcknowledged: ").append(this.getIsReviewOwnerUpdateAcknowledged()).append(",");
        }
        if (this.getIndustryType() != null) {
            sb.append("IndustryType: ").append(this.getIndustryType()).append(",");
        }
        if (this.getIndustry() != null) {
            sb.append("Industry: ").append(this.getIndustry()).append(",");
        }
        if (this.getNotes() != null) {
            sb.append("Notes: ").append(this.getNotes()).append(",");
        }
        if (this.getImprovementStatus() != null) {
            sb.append("ImprovementStatus: ").append(this.getImprovementStatus()).append(",");
        }
        if (this.getRiskCounts() != null) {
            sb.append("RiskCounts: ").append(this.getRiskCounts()).append(",");
        }
        if (this.getPillarPriorities() != null) {
            sb.append("PillarPriorities: ").append(this.getPillarPriorities()).append(",");
        }
        if (this.getLenses() != null) {
            sb.append("Lenses: ").append(this.getLenses()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getShareInvitationId() != null) {
            sb.append("ShareInvitationId: ").append(this.getShareInvitationId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workload)) {
            return false;
        }
        Workload other = (Workload)obj;
        if (other.getWorkloadId() == null ^ this.getWorkloadId() == null) {
            return false;
        }
        if (other.getWorkloadId() != null && !other.getWorkloadId().equals(this.getWorkloadId())) {
            return false;
        }
        if (other.getWorkloadArn() == null ^ this.getWorkloadArn() == null) {
            return false;
        }
        if (other.getWorkloadArn() != null && !other.getWorkloadArn().equals(this.getWorkloadArn())) {
            return false;
        }
        if (other.getWorkloadName() == null ^ this.getWorkloadName() == null) {
            return false;
        }
        if (other.getWorkloadName() != null && !other.getWorkloadName().equals(this.getWorkloadName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        if (other.getUpdatedAt() != null && !other.getUpdatedAt().equals(this.getUpdatedAt())) {
            return false;
        }
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getAwsRegions() == null ^ this.getAwsRegions() == null) {
            return false;
        }
        if (other.getAwsRegions() != null && !other.getAwsRegions().equals(this.getAwsRegions())) {
            return false;
        }
        if (other.getNonAwsRegions() == null ^ this.getNonAwsRegions() == null) {
            return false;
        }
        if (other.getNonAwsRegions() != null && !other.getNonAwsRegions().equals(this.getNonAwsRegions())) {
            return false;
        }
        if (other.getArchitecturalDesign() == null ^ this.getArchitecturalDesign() == null) {
            return false;
        }
        if (other.getArchitecturalDesign() != null && !other.getArchitecturalDesign().equals(this.getArchitecturalDesign())) {
            return false;
        }
        if (other.getReviewOwner() == null ^ this.getReviewOwner() == null) {
            return false;
        }
        if (other.getReviewOwner() != null && !other.getReviewOwner().equals(this.getReviewOwner())) {
            return false;
        }
        if (other.getReviewRestrictionDate() == null ^ this.getReviewRestrictionDate() == null) {
            return false;
        }
        if (other.getReviewRestrictionDate() != null && !other.getReviewRestrictionDate().equals(this.getReviewRestrictionDate())) {
            return false;
        }
        if (other.getIsReviewOwnerUpdateAcknowledged() == null ^ this.getIsReviewOwnerUpdateAcknowledged() == null) {
            return false;
        }
        if (other.getIsReviewOwnerUpdateAcknowledged() != null && !other.getIsReviewOwnerUpdateAcknowledged().equals(this.getIsReviewOwnerUpdateAcknowledged())) {
            return false;
        }
        if (other.getIndustryType() == null ^ this.getIndustryType() == null) {
            return false;
        }
        if (other.getIndustryType() != null && !other.getIndustryType().equals(this.getIndustryType())) {
            return false;
        }
        if (other.getIndustry() == null ^ this.getIndustry() == null) {
            return false;
        }
        if (other.getIndustry() != null && !other.getIndustry().equals(this.getIndustry())) {
            return false;
        }
        if (other.getNotes() == null ^ this.getNotes() == null) {
            return false;
        }
        if (other.getNotes() != null && !other.getNotes().equals(this.getNotes())) {
            return false;
        }
        if (other.getImprovementStatus() == null ^ this.getImprovementStatus() == null) {
            return false;
        }
        if (other.getImprovementStatus() != null && !other.getImprovementStatus().equals(this.getImprovementStatus())) {
            return false;
        }
        if (other.getRiskCounts() == null ^ this.getRiskCounts() == null) {
            return false;
        }
        if (other.getRiskCounts() != null && !other.getRiskCounts().equals(this.getRiskCounts())) {
            return false;
        }
        if (other.getPillarPriorities() == null ^ this.getPillarPriorities() == null) {
            return false;
        }
        if (other.getPillarPriorities() != null && !other.getPillarPriorities().equals(this.getPillarPriorities())) {
            return false;
        }
        if (other.getLenses() == null ^ this.getLenses() == null) {
            return false;
        }
        if (other.getLenses() != null && !other.getLenses().equals(this.getLenses())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getShareInvitationId() == null ^ this.getShareInvitationId() == null) {
            return false;
        }
        if (other.getShareInvitationId() != null && !other.getShareInvitationId().equals(this.getShareInvitationId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkloadId() == null ? 0 : this.getWorkloadId().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadArn() == null ? 0 : this.getWorkloadArn().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadName() == null ? 0 : this.getWorkloadName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getAwsRegions() == null ? 0 : this.getAwsRegions().hashCode());
        hashCode = 31 * hashCode + (this.getNonAwsRegions() == null ? 0 : this.getNonAwsRegions().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecturalDesign() == null ? 0 : this.getArchitecturalDesign().hashCode());
        hashCode = 31 * hashCode + (this.getReviewOwner() == null ? 0 : this.getReviewOwner().hashCode());
        hashCode = 31 * hashCode + (this.getReviewRestrictionDate() == null ? 0 : this.getReviewRestrictionDate().hashCode());
        hashCode = 31 * hashCode + (this.getIsReviewOwnerUpdateAcknowledged() == null ? 0 : this.getIsReviewOwnerUpdateAcknowledged().hashCode());
        hashCode = 31 * hashCode + (this.getIndustryType() == null ? 0 : this.getIndustryType().hashCode());
        hashCode = 31 * hashCode + (this.getIndustry() == null ? 0 : this.getIndustry().hashCode());
        hashCode = 31 * hashCode + (this.getNotes() == null ? 0 : this.getNotes().hashCode());
        hashCode = 31 * hashCode + (this.getImprovementStatus() == null ? 0 : this.getImprovementStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRiskCounts() == null ? 0 : this.getRiskCounts().hashCode());
        hashCode = 31 * hashCode + (this.getPillarPriorities() == null ? 0 : this.getPillarPriorities().hashCode());
        hashCode = 31 * hashCode + (this.getLenses() == null ? 0 : this.getLenses().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getShareInvitationId() == null ? 0 : this.getShareInvitationId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Workload clone() {
        try {
            return (Workload)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkloadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

