/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.CognitoGroupConfiguration;
import com.amazonaws.services.verifiedpermissions.model.transform.CognitoUserPoolConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CognitoUserPoolConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String userPoolArn;
    private List<String> clientIds;
    private CognitoGroupConfiguration groupConfiguration;

    public void setUserPoolArn(String userPoolArn) {
        this.userPoolArn = userPoolArn;
    }

    public String getUserPoolArn() {
        return this.userPoolArn;
    }

    public CognitoUserPoolConfiguration withUserPoolArn(String userPoolArn) {
        this.setUserPoolArn(userPoolArn);
        return this;
    }

    public List<String> getClientIds() {
        return this.clientIds;
    }

    public void setClientIds(Collection<String> clientIds) {
        if (clientIds == null) {
            this.clientIds = null;
            return;
        }
        this.clientIds = new ArrayList<String>(clientIds);
    }

    public CognitoUserPoolConfiguration withClientIds(String ... clientIds) {
        if (this.clientIds == null) {
            this.setClientIds(new ArrayList<String>(clientIds.length));
        }
        for (String ele : clientIds) {
            this.clientIds.add(ele);
        }
        return this;
    }

    public CognitoUserPoolConfiguration withClientIds(Collection<String> clientIds) {
        this.setClientIds(clientIds);
        return this;
    }

    public void setGroupConfiguration(CognitoGroupConfiguration groupConfiguration) {
        this.groupConfiguration = groupConfiguration;
    }

    public CognitoGroupConfiguration getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public CognitoUserPoolConfiguration withGroupConfiguration(CognitoGroupConfiguration groupConfiguration) {
        this.setGroupConfiguration(groupConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolArn() != null) {
            sb.append("UserPoolArn: ").append(this.getUserPoolArn()).append(",");
        }
        if (this.getClientIds() != null) {
            sb.append("ClientIds: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getGroupConfiguration() != null) {
            sb.append("GroupConfiguration: ").append(this.getGroupConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoUserPoolConfiguration)) {
            return false;
        }
        CognitoUserPoolConfiguration other = (CognitoUserPoolConfiguration)obj;
        if (other.getUserPoolArn() == null ^ this.getUserPoolArn() == null) {
            return false;
        }
        if (other.getUserPoolArn() != null && !other.getUserPoolArn().equals(this.getUserPoolArn())) {
            return false;
        }
        if (other.getClientIds() == null ^ this.getClientIds() == null) {
            return false;
        }
        if (other.getClientIds() != null && !other.getClientIds().equals(this.getClientIds())) {
            return false;
        }
        if (other.getGroupConfiguration() == null ^ this.getGroupConfiguration() == null) {
            return false;
        }
        return other.getGroupConfiguration() == null || other.getGroupConfiguration().equals(this.getGroupConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolArn() == null ? 0 : this.getUserPoolArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientIds() == null ? 0 : this.getClientIds().hashCode());
        hashCode = 31 * hashCode + (this.getGroupConfiguration() == null ? 0 : this.getGroupConfiguration().hashCode());
        return hashCode;
    }

    public CognitoUserPoolConfiguration clone() {
        try {
            return (CognitoUserPoolConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoUserPoolConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

