/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.EntityReference;
import com.amazonaws.services.verifiedpermissions.model.PolicyType;
import com.amazonaws.services.verifiedpermissions.model.transform.PolicyFilterMarshaller;
import java.io.Serializable;

public class PolicyFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private EntityReference principal;
    private EntityReference resource;
    private String policyType;
    private String policyTemplateId;

    public void setPrincipal(EntityReference principal) {
        this.principal = principal;
    }

    public EntityReference getPrincipal() {
        return this.principal;
    }

    public PolicyFilter withPrincipal(EntityReference principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setResource(EntityReference resource) {
        this.resource = resource;
    }

    public EntityReference getResource() {
        return this.resource;
    }

    public PolicyFilter withResource(EntityReference resource) {
        this.setResource(resource);
        return this;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public PolicyFilter withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public PolicyFilter withPolicyType(PolicyType policyType) {
        this.policyType = policyType.toString();
        return this;
    }

    public void setPolicyTemplateId(String policyTemplateId) {
        this.policyTemplateId = policyTemplateId;
    }

    public String getPolicyTemplateId() {
        return this.policyTemplateId;
    }

    public PolicyFilter withPolicyTemplateId(String policyTemplateId) {
        this.setPolicyTemplateId(policyTemplateId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: ").append(this.getPolicyType()).append(",");
        }
        if (this.getPolicyTemplateId() != null) {
            sb.append("PolicyTemplateId: ").append(this.getPolicyTemplateId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyFilter)) {
            return false;
        }
        PolicyFilter other = (PolicyFilter)obj;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        if (other.getPolicyType() != null && !other.getPolicyType().equals(this.getPolicyType())) {
            return false;
        }
        if (other.getPolicyTemplateId() == null ^ this.getPolicyTemplateId() == null) {
            return false;
        }
        return other.getPolicyTemplateId() == null || other.getPolicyTemplateId().equals(this.getPolicyTemplateId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyTemplateId() == null ? 0 : this.getPolicyTemplateId().hashCode());
        return hashCode;
    }

    public PolicyFilter clone() {
        try {
            return (PolicyFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

