/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.transform.SftpConnectorConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SftpConnectorConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String userSecretId;
    private List<String> trustedHostKeys;

    public void setUserSecretId(String userSecretId) {
        this.userSecretId = userSecretId;
    }

    public String getUserSecretId() {
        return this.userSecretId;
    }

    public SftpConnectorConfig withUserSecretId(String userSecretId) {
        this.setUserSecretId(userSecretId);
        return this;
    }

    public List<String> getTrustedHostKeys() {
        return this.trustedHostKeys;
    }

    public void setTrustedHostKeys(Collection<String> trustedHostKeys) {
        if (trustedHostKeys == null) {
            this.trustedHostKeys = null;
            return;
        }
        this.trustedHostKeys = new ArrayList<String>(trustedHostKeys);
    }

    public SftpConnectorConfig withTrustedHostKeys(String ... trustedHostKeys) {
        if (this.trustedHostKeys == null) {
            this.setTrustedHostKeys(new ArrayList<String>(trustedHostKeys.length));
        }
        for (String ele : trustedHostKeys) {
            this.trustedHostKeys.add(ele);
        }
        return this;
    }

    public SftpConnectorConfig withTrustedHostKeys(Collection<String> trustedHostKeys) {
        this.setTrustedHostKeys(trustedHostKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserSecretId() != null) {
            sb.append("UserSecretId: ").append(this.getUserSecretId()).append(",");
        }
        if (this.getTrustedHostKeys() != null) {
            sb.append("TrustedHostKeys: ").append(this.getTrustedHostKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SftpConnectorConfig)) {
            return false;
        }
        SftpConnectorConfig other = (SftpConnectorConfig)obj;
        if (other.getUserSecretId() == null ^ this.getUserSecretId() == null) {
            return false;
        }
        if (other.getUserSecretId() != null && !other.getUserSecretId().equals(this.getUserSecretId())) {
            return false;
        }
        if (other.getTrustedHostKeys() == null ^ this.getTrustedHostKeys() == null) {
            return false;
        }
        return other.getTrustedHostKeys() == null || other.getTrustedHostKeys().equals(this.getTrustedHostKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserSecretId() == null ? 0 : this.getUserSecretId().hashCode());
        hashCode = 31 * hashCode + (this.getTrustedHostKeys() == null ? 0 : this.getTrustedHostKeys().hashCode());
        return hashCode;
    }

    public SftpConnectorConfig clone() {
        try {
            return (SftpConnectorConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SftpConnectorConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

